### Name: RODBCtables
### Title: Operations on Tables in ODBC databases
### Aliases: sqlPrimaryKeys sqlColumns sqlDrop sqlClear
### Keywords: IO database

### ** Examples

## Not run: 
##D ## example results from MySQL
##D data(USArrests) # R < 2.0.0 only
##D channel <- odbcConnect("test")
##D sqlDrop(channel, "USArrests", errors = FALSE) # precautionary
##D sqlSave(channel, USArrests)
##D sqlColumns(channel, "USArrests")
##D sqlColumns(channel, "USArrests", special = TRUE)
##D sqlPrimaryKeys(channel, "USArrests")
##D sqlColumns(channel, "USArrests")
##D ##   Table_cat Table_schema Table_name Column_name Data_type Type_name
##D ## 1                         USArrests    rownames        12   varchar
##D ## 2                         USArrests      murder         8    double
##D ## 3                         USArrests     assault         4   integer
##D ## 4                         USArrests    urbanpop         4   integer
##D ## 5                         USArrests        rape         8    double
##D ##   Column_size Buffer_length Decimal_digits Num_prec_radix Nullable Remarks
##D ## 1         255           255           <NA>           <NA>        0
##D ## 2          22             8             31             10        1
##D ## 3          11             4              0             10        1
##D ## 4          11             4              0             10        1
##D ## 5          22             8             31             10        1
##D sqlColumns(channel, "USArrests", special = TRUE)
##D ##   Scope Column_name Data_type Type_name Precision Length Scale
##D ## 1     2    rownames        12   varchar         0      0     0
##D ##   Pseudo_column
##D ## 1             1
##D sqlPrimaryKeys(channel, "USArrests")
##D ##   Table_qualifer Table_owner Table_name Column_name Key_seq Pk_name
##D ## 1           <NA>        <NA>  USArrests    rownames       1 PRIMARY
##D sqlClear(channel, "USArrests")
##D sqlDrop(channel, "USArrests")
##D close(channel)
## End(Not run)


