## ----setup, include = FALSE----------------------------------------------
has_gcloud <- AnVILBase::has_avworkspace(
    strict = TRUE, platform = AnVILGCP::gcp()
)
knitr::opts_chunk$set(
    eval =  has_gcloud, collapse = TRUE, cache = TRUE
)
options(width=75)

## ----install-anvil, eval = FALSE-----------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager", repos = "https://cran.r-project.org")
# BiocManager::install("AnVIL")

## ----load-packages, message = FALSE, eval = TRUE, cache = FALSE----------
library(AnVILGCP)
library(AnVIL)

## ----workspace, eval = has_gcloud----------------------------------------
# avworkspace("bioconductor-rpci-anvil/Bioconductor-Workflow-DESeq2")

## ----workflows, eval = has_gcloud----------------------------------------
# avworkflows()

## ----workflow, eval = has_gcloud-----------------------------------------
# avworkflow("bioconductor-rpci-anvil/AnVILBulkRNASeq")

## ----configuration, eval = has_gcloud------------------------------------
# config <- avworkflow_configuration_get()
# config

## ----inputs-outputs, eval = has_gcloud-----------------------------------
# inputs <- avworkflow_configuration_inputs(config)
# inputs
# 
# outputs <- avworkflow_configuration_outputs(config)
# outputs

## ----change-input, eval = has_gcloud-------------------------------------
# inputs <-
#     inputs |>
#     mutate(
#         attribute = ifelse(
#             name == "salmon.transcriptome_index_name",
#             '"new_index_name"',
#             attribute
#         )
#     )
# inputs

## ----update-config, eval = has_gcloud------------------------------------
# new_config <- avworkflow_configuration_update(config, inputs)
# new_config

## ----set-config, eval = has_gcloud---------------------------------------
# avworkflow_configuration_set(new_config)

## ----set-config-not-dry--------------------------------------------------
# ## avworkflow_configuration_set(new_config, dry = FALSE)

## ----entityName, eval = has_gcloud---------------------------------------
# entityName <- avtable("participant_set") |>
#     pull(participant_set_id) |>
#     head(1)
# avworkflow_run(new_config, entityName)

## ----run-not-dry---------------------------------------------------------
# ## avworkflow_run(new_config, entityName, dry = FALSE)

## ----checking-workflow, eval = has_gcloud--------------------------------
# avworkflow_jobs()

## ----stop-workflow, eval = has_gcloud------------------------------------
# avworkflow_stop() # dry = FALSE to stop
# 
# avworkflow_jobs()

## ----files, eval = has_gcloud--------------------------------------------
# submissionId <- "fb8e35b7-df5d-49e6-affa-9893aaeebf37"
# avworkflow_files(submissionId)

## ----localize, eval = has_gcloud-----------------------------------------
# avworkflow_localize(
#     submissionId,
#     type = "output"
#     ## dry = FALSE to localize
# )

## ----workflow-info-example1-retrieval, eval = FALSE----------------------
# avworkspace("bioconductor-rpci-yubo/Rcollectlworkflowh5ad")
# submissionId <- "9385fd75-4cb7-470f-9e07-1979e2c8f193"
# info_1 <- avworkflow_info(submissionId)

## ----workflow-info-1-read, message=FALSE, warning=FALSE------------------
# info_file_1 <-
#     system.file(package = "AnVIL", "extdata", "avworkflow_info_1.rds")
# info_1 <- readRDS(info_file_1)
# 
# ## view result of avworkflow_info()
# info_1

## ----workflow-info-1-select----------------------------------------------
# info_1 |>
#     select(workflowId, status, inputs, outputs)

## ----workflow-info-1-inputs-unnested-------------------------------------
# info_1 |>
#     select(workflowId, status, inputs) |>
#     tidyr::unnest_wider(inputs)

## ----workflow-info-1-outputs-unnested------------------------------------
# info_1 |>
#     select(workflowId, outputs) |>
#     tidyr::unnest_wider(outputs) |>
#     tidyr::unnest_longer(starts_with("Rcollectl"), keep_empty = TRUE)

## ----workflow-info-example2-retrieval, eval = FALSE, eval = has_gcloud----
# submissionId <- "35280de1-42d8-492b-aa8c-5feff984bffa"
# info_2 <- avworkflow_info(submissionId)

## ----workflow-info-2-read, message=FALSE, warning=FALSE------------------
# info_file_2 <-
#     system.file(package = "AnVIL", "extdata", "avworkflow_info_2.rds")
# info_2 <- readRDS(info_file_2)
# info_2

## ----workflow-info-2-outputs-unnested, message=FALSE, warning=FALSE------
# info_2 |>
#     select(workflowId, outputs) |>
#     tidyr::unnest_wider(outputs)

## ----workflow-info-2-output-files----------------------------------------
# output_files <-
#     info_2 |>
#     select(workflowId, outputs) |>
#     tidyr::unnest_wider(outputs) |>
#     select(RcollectlWorkflowDelayedArrayParameters.Rcollectl_result) |>
#     tidyr::unnest_longer(
#         "RcollectlWorkflowDelayedArrayParameters.Rcollectl_result"
#     )
# output_files

## ----workflow-info-2-output-paths----------------------------------------
# output_files |>
#     as.vector()

## ----sessionInfo---------------------------------------------------------
# sessionInfo()

