### Name: surfacePlot
### Title: Density or uncertainty surface for two dimensional mixtures.
### Aliases: surfacePlot
### Keywords: cluster

### ** Examples

n <- 250 ## create artificial data
set.seed(0)
x <- rbind(matrix(rnorm(n*2), n, 2) %*% diag(c(1,9)),
           matrix(rnorm(n*2), n, 2) %*% diag(c(1,9))[,2:1])
xclass <- c(rep(1,n),rep(2,n))

xEMclust <- summary(EMclust(x),x)
surfacePlot(x, mu = xEMclust$mu, sigma = xEMclust$sigma, pro=xEMclust$pro,
            type = "contour", what = "density", transformation = "none")

## Not run: do.call("surfacePlot", c(list(data = x), xEMclust))



