## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  out.width = "100%",
  collapse = TRUE,
  comment = "#>"
)

## ----setup, echo=FALSE, warning=FALSE-----------------------------------------
library(TrIdent)
library(knitr)
library(patchwork)
library(ggplot2)
library(kableExtra)

## ----eval=FALSE---------------------------------------------------------------
# if (!require("BiocManager", quietly = TRUE)) {
#   install.packages("BiocManager")
# }
# 
# BiocManager::install("TrIdent")
# library(TrIdent)

## ----eval=FALSE---------------------------------------------------------------
# BiocManager::install("jlmaier12/TrIdent")
# library(TrIdent)

## ----echo=FALSE---------------------------------------------------------------
data("WholeCommunitySamplePileup")
data("VLPFractionSamplePileup")
kable(head(VLPFractionSamplePileup), row.names = FALSE) %>%
  kable_styling(latex_options = "HOLD_position")

## ----echo=FALSE, fig.width=4,fig.height=4-------------------------------------
dataframe <- cbind.data.frame(c(1:100), c(seq(1, 100, 1)))
colnames(dataframe) <- c("mockpos", "mockcov")
plot1 <- ggplot(dataframe, aes(x = mockpos, y = mockcov)) +
  geom_line(linewidth = 1) +
  labs(x = NULL, y = NULL, title = "Pattern 1") +
  theme_classic() +
  ggplot2::theme(
    axis.text.x = element_blank(),
    axis.ticks.x = element_blank(),
    axis.text.y = element_blank(),
    axis.ticks.y = element_blank(),
    plot.title = element_text(size = 10),
    panel.border = element_rect(colour = "black", fill = NA, linewidth = 2)
  )

dataframe <- cbind.data.frame(c(1:100), c(seq(100, 1, -1)))
colnames(dataframe) <- c("mockpos", "mockcov")
plot2 <- ggplot(dataframe, aes(x = mockpos, y = mockcov)) +
  geom_line(linewidth = 1) +
  labs(x = NULL, y = NULL, title = "Pattern 2") +
  theme_classic() +
  ggplot2::theme(
    axis.text.x = element_blank(),
    axis.ticks.x = element_blank(),
    axis.text.y = element_blank(),
    axis.ticks.y = element_blank(),
    plot.title = element_text(size = 10),
    panel.border = element_rect(colour = "black", fill = NA, linewidth = 2)
  )

dataframe <- cbind.data.frame(c(1:100), c(rep(0, 20), seq(80, 1, -1)))
colnames(dataframe) <- c("mockpos", "mockcov")
plot3 <- ggplot(dataframe, aes(x = mockpos, y = mockcov)) +
  geom_line(linewidth = 1) +
  labs(x = NULL, y = NULL, title = "Pattern 3") +
  theme_classic() +
  ggplot2::theme(
    axis.text.x = element_blank(),
    axis.ticks.x = element_blank(),
    axis.text.y = element_blank(),
    axis.ticks.y = element_blank(),
    plot.title = element_text(size = 10),
    panel.border = element_rect(colour = "black", fill = NA, linewidth = 2)
  )

dataframe <- cbind.data.frame(c(1:100), c(seq(1, 80, 1), rep(0, 20)))
colnames(dataframe) <- c("mockpos", "mockcov")
plot4 <- ggplot(dataframe, aes(x = mockpos, y = mockcov)) +
  geom_line(linewidth = 1) +
  labs(x = NULL, y = NULL, title = "Pattern 4") +
  theme_classic() +
  ggplot2::theme(
    axis.text.x = element_blank(),
    axis.ticks.x = element_blank(),
    axis.text.y = element_blank(),
    axis.ticks.y = element_blank(),
    plot.title = element_text(size = 10),
    panel.border = element_rect(colour = "black", fill = NA, linewidth = 2)
  )

plot1 + plot2 + plot3 + plot4

## ----echo=FALSE, fig.width=4,fig.height=2-------------------------------------
dataframe <- cbind.data.frame(c(1:100), c(rep(0, 20), rep(100, 60), rep(0, 20)))
colnames(dataframe) <- c("mockpos", "mockcov")
plot1 <- ggplot(dataframe, aes(x = mockpos, y = mockcov)) +
  geom_line(linewidth = 1) +
  labs(x = NULL, y = NULL, title = "Pattern 2") +
  theme_classic() +
  ggplot2::theme(
    axis.text.x = element_blank(),
    axis.ticks.x = element_blank(),
    axis.text.y = element_blank(),
    axis.ticks.y = element_blank(),
    plot.title = element_text(size = 10),
    panel.border = element_rect(colour = "black", fill = NA, linewidth = 2)
  )

dataframe <- cbind.data.frame(c(1:100), c(rep(0, 60), rep(100, 40)))
colnames(dataframe) <- c("mockpos", "mockcov")
plot2 <- ggplot(dataframe, aes(x = mockpos, y = mockcov)) +
  geom_line(linewidth = 1) +
  labs(x = NULL, y = NULL, title = "Pattern 3") +
  theme_classic() +
  ggplot2::theme(
    axis.text.x = element_blank(),
    axis.ticks.x = element_blank(),
    axis.text.y = element_blank(),
    axis.ticks.y = element_blank(),
    plot.title = element_text(size = 10),
    panel.border = element_rect(colour = "black", fill = NA, linewidth = 2)
  )

dataframe <- cbind.data.frame(c(1:100), c(rep(100, 40), rep(0, 60)))
colnames(dataframe) <- c("mockpos", "mockcov")
plot3 <- ggplot(dataframe, aes(x = mockpos, y = mockcov)) +
  geom_line(linewidth = 1) +
  labs(x = NULL, y = NULL, title = "Pattern 1") +
  theme_classic() +
  ggplot2::theme(
    axis.text.x = element_blank(),
    axis.ticks.x = element_blank(),
    axis.text.y = element_blank(),
    axis.ticks.y = element_blank(),
    plot.title = element_text(size = 10),
    panel.border = element_rect(colour = "black", fill = NA, linewidth = 2)
  )

plot3 + plot1 + plot2

## ----echo=FALSE, fig.width=4,fig.height=4-------------------------------------
dataframe <- cbind.data.frame(c(1:100), rep(10, 100))
colnames(dataframe) <- c("mockpos", "mockcov")
plot1 <- ggplot(dataframe, aes(x = mockpos, y = mockcov)) +
  geom_line(linewidth = 1) +
  ylim(0, 100) +
  labs(x = NULL, y = NULL, title = "Pattern 1") +
  theme_classic() +
  ggplot2::theme(
    axis.text.x = element_blank(),
    axis.ticks.x = element_blank(),
    axis.text.y = element_blank(),
    axis.ticks.y = element_blank(),
    plot.title = element_text(size = 10),
    panel.border = element_rect(colour = "black", fill = NA, linewidth = 2)
  )
plot1

## -----------------------------------------------------------------------------
TrIdentOutput <- TrIdentClassifier(
  VLPpileup = VLPFractionSamplePileup,
  WCpileup = WholeCommunitySamplePileup
)

## ----eval=FALSE---------------------------------------------------------------
# TrIdentClassifier(VLPpileup, WCpileup,
#   windowSize = 1000, minBlockSize = 10000,
#   maxBlockSize = Inf, minContigLength = 30000, minSlope = 0.001,
#   verbose = TRUE, SaveFilesTo
# )

## -----------------------------------------------------------------------------
TrIdentSummaryTable <- TrIdentOutput$SummaryTable

## ----echo=FALSE---------------------------------------------------------------
kable(TrIdentSummaryTable) %>%
  kable_styling(latex_options = "HOLD_position")

## -----------------------------------------------------------------------------
TrIdentPlots <- plotTrIdentResults(
  VLPpileup = VLPFractionSamplePileup,
  WCpileup = WholeCommunitySamplePileup,
  TrIdentResults = TrIdentOutput
)

## ----eval=FALSE---------------------------------------------------------------
# plotTrIdentResults(
#   VLPpileup,
#   WCpileup,
#   TrIdentResults,
#   onlyPlot,
#   logScale = FALSE,
#   saveFilesTo
# )

## -----------------------------------------------------------------------------
TrIdentPlots$NODE_62
TrIdentPlots$NODE_368
TrIdentPlots$NODE_352

## -----------------------------------------------------------------------------
SpecTransduc <- specializedTransductionID(
  VLPpileup = VLPFractionSamplePileup,
  TrIdentResults = TrIdentOutput
)

## ----eval=FALSE---------------------------------------------------------------
# specializedTransductionID(VLPpileup,
#                           TrIdentResults,
#   noReadCov = 500, specTransLength = 2000,
#   logScale = FALSE, verbose = TRUE,
#   SaveFilesTo, specificContig
# )

## -----------------------------------------------------------------------------
SpecializedTransducSummaryTable <- SpecTransduc$summaryTable

## ----echo=FALSE---------------------------------------------------------------
kable(head(SpecializedTransducSummaryTable), format = "html") %>%
  kable_styling(latex_options = "HOLD_position")

## -----------------------------------------------------------------------------
SpecTransduc$Plots$NODE_62
SpecTransduc$Plots$NODE_135

## -----------------------------------------------------------------------------
FinalTrIdentSummaryTable <- merge(TrIdentSummaryTable,
  SpecializedTransducSummaryTable,
  by = "contigName", all.x = TRUE
)

## ----echo=FALSE---------------------------------------------------------------
kable(FinalTrIdentSummaryTable) %>%
  kable_styling(latex_options = "HOLD_position")

## -----------------------------------------------------------------------------
sessionInfo()

