/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.Channel;
import edu.rit.mp.Status;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;

public class IORequest {
    protected Channel myChannel;
    protected int myTagLb;
    protected int myTagUb;
    protected Buf myBuf;
    protected Status myStatus;
    IOException myIOException;
    RuntimeException myRuntimeException;
    Error myError;
    int myState = 0;
    static final int PENDING = 0;
    static final int SUCCEEDED = 1;
    static final int FAILED = 2;

    void initialize(Channel channel, int n, int n2, Buf buf) {
        this.myChannel = channel;
        this.myTagLb = n;
        this.myTagUb = n2;
        this.myBuf = buf;
        this.myStatus = null;
        this.myIOException = null;
        this.myRuntimeException = null;
        this.myError = null;
        this.myState = 0;
    }

    public synchronized boolean isFinished() throws IOException {
        if (this.myState == 0) {
            return false;
        }
        this.rethrow("IORequest: Exception during send or receive");
        return true;
    }

    public synchronized Status waitForFinish() throws IOException {
        try {
            while (this.myState == 0) {
                this.wait();
            }
            this.rethrow("IORequest: Exception during send or receive");
            return this.myStatus;
        }
        catch (InterruptedException interruptedException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("IORequest: waitForFinish() interrupted");
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IORequest(myChannel=");
        stringBuilder.append(this.myChannel);
        stringBuilder.append(",myTagLb=");
        stringBuilder.append(this.myTagLb);
        stringBuilder.append(",myTagUb=");
        stringBuilder.append(this.myTagUb);
        stringBuilder.append(",myBuf=");
        stringBuilder.append(this.myBuf);
        stringBuilder.append(",myState=");
        stringBuilder.append(this.myState);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    boolean match(IORequest iORequest) {
        return (this.myChannel == null || iORequest.myChannel == null || this.myChannel == iORequest.myChannel) && this.myTagLb <= iORequest.myTagLb && iORequest.myTagLb <= this.myTagUb && this.myBuf.myMessageType == iORequest.myBuf.myMessageType;
    }

    boolean match(Channel channel, int n, byte by) {
        return (this.myChannel == null || channel == null || this.myChannel == channel) && this.myTagLb <= n && n <= this.myTagUb && this.myBuf.myMessageType == by;
    }

    protected synchronized void reportSuccess() {
        this.myState = 1;
        this.notifyAll();
    }

    protected synchronized void reportFailure(IOException iOException) {
        this.myIOException = iOException;
        this.myState = 2;
        this.notifyAll();
    }

    synchronized void reportFailure(RuntimeException runtimeException) {
        this.myRuntimeException = runtimeException;
        this.myState = 2;
        this.notifyAll();
    }

    synchronized void reportFailure(Error error) {
        this.myError = error;
        this.myState = 2;
        this.notifyAll();
    }

    private void rethrow(String string) throws IOException {
        if (this.myIOException != null) {
            this.rethrowIOException(string);
        } else if (this.myRuntimeException != null) {
            this.rethrowRuntimeException(string);
        } else if (this.myError != null) {
            this.rethrowError(string);
        }
    }

    private void rethrowIOException(String string) throws IOException {
        IOException iOException = null;
        try {
            Class<?> clazz = this.myIOException.getClass();
            Constructor<?> constructor = clazz.getConstructor(String.class);
            iOException = (IOException)constructor.newInstance(string);
        }
        catch (Throwable throwable) {
            iOException = new IOException(string);
        }
        iOException.initCause(this.myIOException);
        throw iOException;
    }

    private void rethrowRuntimeException(String string) {
        RuntimeException runtimeException = null;
        try {
            Class<?> clazz = this.myRuntimeException.getClass();
            Constructor<?> constructor = clazz.getConstructor(String.class);
            runtimeException = (RuntimeException)constructor.newInstance(string);
        }
        catch (Throwable throwable) {
            runtimeException = new RuntimeException(string);
        }
        runtimeException.initCause(this.myRuntimeException);
        throw runtimeException;
    }

    private void rethrowError(String string) {
        Error error = null;
        try {
            Class<?> clazz = this.myError.getClass();
            Constructor<?> constructor = clazz.getConstructor(String.class);
            error = (Error)constructor.newInstance(string);
        }
        catch (Throwable throwable) {
            error = new Error(string);
        }
        error.initCause(this.myError);
        throw error;
    }
}

