/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.ArrayItemGenerator;
import edu.rit.pj.IteratorItemGenerator;
import edu.rit.pj.WorkerConstruct;
import edu.rit.pj.WorkerIntegerForLoop;
import edu.rit.pj.WorkerIntegerStrideForLoop;
import edu.rit.pj.WorkerIteration;
import edu.rit.pj.WorkerLongForLoop;
import edu.rit.pj.WorkerLongStrideForLoop;
import edu.rit.pj.WorkerTeamThread;
import edu.rit.util.LongRange;
import edu.rit.util.Range;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkerRegion
extends WorkerConstruct {
    public void start() throws Exception {
    }

    public abstract void run() throws Exception;

    public void finish() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(int n, int n2, WorkerIntegerForLoop workerIntegerForLoop) throws Exception {
        if (workerIntegerForLoop == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker for loop is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        try {
            workerIntegerForLoop.myTeam = this.myTeam;
            WorkerTeamThread workerTeamThread = this.getCurrentThread();
            int n3 = workerTeamThread.myIndex;
            Range range = new Range(n, n2);
            if (n3 == -1) {
                workerIntegerForLoop.masterExecute(range);
            } else {
                workerIntegerForLoop.workerExecute(n3, range);
            }
        }
        finally {
            workerIntegerForLoop.myTeam = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(int n, int n2, int n3, WorkerIntegerStrideForLoop workerIntegerStrideForLoop) throws Exception {
        if (n3 <= 0) {
            throw new IllegalArgumentException("WorkerRegion.execute(): Stride = " + n3 + " illegal");
        }
        if (workerIntegerStrideForLoop == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker for loop is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        try {
            workerIntegerStrideForLoop.myTeam = this.myTeam;
            WorkerTeamThread workerTeamThread = this.getCurrentThread();
            int n4 = workerTeamThread.myIndex;
            Range range = new Range(n, n2, n3);
            if (n4 == -1) {
                workerIntegerStrideForLoop.masterExecute(range);
            } else {
                workerIntegerStrideForLoop.workerExecute(n4, range);
            }
        }
        finally {
            workerIntegerStrideForLoop.myTeam = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(long l, long l2, WorkerLongForLoop workerLongForLoop) throws Exception {
        if (workerLongForLoop == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker for loop is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        try {
            workerLongForLoop.myTeam = this.myTeam;
            WorkerTeamThread workerTeamThread = this.getCurrentThread();
            int n = workerTeamThread.myIndex;
            LongRange longRange = new LongRange(l, l2);
            if (n == -1) {
                workerLongForLoop.masterExecute(longRange);
            } else {
                workerLongForLoop.workerExecute(n, longRange);
            }
        }
        finally {
            workerLongForLoop.myTeam = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(long l, long l2, long l3, WorkerLongStrideForLoop workerLongStrideForLoop) throws Exception {
        if (l3 <= 0L) {
            throw new IllegalArgumentException("WorkerRegion.execute(): Stride = " + l3 + " illegal");
        }
        if (workerLongStrideForLoop == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker for loop is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        try {
            workerLongStrideForLoop.myTeam = this.myTeam;
            WorkerTeamThread workerTeamThread = this.getCurrentThread();
            int n = workerTeamThread.myIndex;
            LongRange longRange = new LongRange(l, l2, l3);
            if (n == -1) {
                workerLongStrideForLoop.masterExecute(longRange);
            } else {
                workerLongStrideForLoop.workerExecute(n, longRange);
            }
        }
        finally {
            workerLongStrideForLoop.myTeam = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void execute(T[] TArray, WorkerIteration<T> workerIteration) throws Exception {
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        if (this.myTeam.rank == this.myTeam.masterRank() && TArray == null) {
            throw new NullPointerException("WorkerRegion.execute(): Array is null");
        }
        if (workerIteration == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker iteration is null");
        }
        try {
            workerIteration.myTeam = this.myTeam;
            WorkerTeamThread workerTeamThread = this.getCurrentThread();
            int n = workerTeamThread.myIndex;
            if (n == -1) {
                workerIteration.masterExecute(new ArrayItemGenerator<T>(TArray));
            } else {
                workerIteration.workerExecute(n);
            }
        }
        finally {
            workerIteration.myTeam = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void execute(Iterator<T> iterator, WorkerIteration<T> workerIteration) throws Exception {
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        if (this.myTeam.rank == this.myTeam.masterRank() && iterator == null) {
            throw new NullPointerException("WorkerRegion.execute(): Iterator is null");
        }
        if (workerIteration == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker iteration is null");
        }
        try {
            workerIteration.myTeam = this.myTeam;
            WorkerTeamThread workerTeamThread = this.getCurrentThread();
            int n = workerTeamThread.myIndex;
            if (n == -1) {
                workerIteration.masterExecute(new IteratorItemGenerator<T>(iterator));
            } else {
                workerIteration.workerExecute(n);
            }
        }
        finally {
            workerIteration.myTeam = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void execute(Iterable<T> iterable, WorkerIteration<T> workerIteration) throws Exception {
        if (this.myTeam == null) {
            throw new IllegalStateException("WorkerRegion.execute(): No parallel team executing");
        }
        if (this.myTeam.rank == this.myTeam.masterRank() && iterable == null) {
            throw new NullPointerException("WorkerRegion.execute(): Iterable collection is null");
        }
        if (workerIteration == null) {
            throw new NullPointerException("WorkerRegion.execute(): Worker iteration is null");
        }
        try {
            workerIteration.myTeam = this.myTeam;
            WorkerTeamThread workerTeamThread = this.getCurrentThread();
            int n = workerTeamThread.myIndex;
            if (n == -1) {
                workerIteration.masterExecute(new IteratorItemGenerator<T>(iterable.iterator()));
            } else {
                workerIteration.workerExecute(n);
            }
        }
        finally {
            workerIteration.myTeam = null;
        }
    }
}

