/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.program.search.FastaSearchBuilder;
import org.biojava.bio.program.search.SearchContentHandler;
import org.biojava.bio.program.search.SearchParser;
import org.biojava.utils.ParserException;

public class FastaSearchParser
implements SearchParser {
    private static final int NODATA = 0;
    private static final int INHEADER = 1;
    private static final int INHIT = 2;
    private static final int INQUERY = 3;
    private static final int INSUBJECT = 4;
    private static final int INALIGN = 5;
    private static HashSet resultAnnoTokens = (HashSet)FastaSearchParser.fillSet(new String[]{"mp_name", "mp_ver", "mp_argv", "mp_extrap", "mp_stats", "mp_KS", "pg_name", "pg_ver", "pg_optcut", "pg_cgap"}, new HashSet());
    private static HashSet resultSearchParmTokens = (HashSet)FastaSearchParser.fillSet(new String[]{"pg_matrix", "pg_ktup", "pg_gap-pen"}, new HashSet());
    private static HashSet hitAnnoTokens = (HashSet)FastaSearchParser.fillSet(new String[]{"fa_frame", "fa_initn", "fa_init1", "fa_opt", "fa_bits", "sw_score", "sw_ident", "sw_gident", "sw_overlap", "fa_ident", "fa_gident", "fa_overlap"}, new HashSet());
    private static HashSet hitDataTokens = (HashSet)FastaSearchParser.fillSet(new String[]{"fa_expect", "fa_z-score"}, new HashSet());
    private static HashSet toDouble = (HashSet)FastaSearchParser.fillSet(new String[]{"fa_expect", "fa_z-score", "fa_bits"}, new HashSet());
    private static HashSet toFloat = (HashSet)FastaSearchParser.fillSet(new String[]{"sw_ident", "fa_ident", "fa_gident"}, new HashSet());
    private static HashSet toInteger = (HashSet)FastaSearchParser.fillSet(new String[]{"fa_initn", "fa_init1", "fa_opt", "sw_score", "sw_overlap", "fa_overlap"}, new HashSet());
    private int searchStatus = 0;
    private boolean searchParsed = false;
    private boolean moreSearchesAvailable = false;
    private BufferedReader reader;
    private String line;
    private int lineNumber;
    Map resultPreAnnotation = new HashMap();
    Map resultSearchParm = new HashMap();
    Map hitPreAnnotation = new HashMap();
    Map hitData = new HashMap();
    StringBuffer querySeqTokens = new StringBuffer(1024);
    StringBuffer subjectSeqTokens = new StringBuffer(1024);

    private static Set fillSet(String[] stringArray, Set set) {
        int n = 0;
        while (n < stringArray.length) {
            set.add(stringArray[n]);
            ++n;
        }
        return set;
    }

    private Integer parseCoord(String string) {
        int n = string.lastIndexOf(":");
        String string2 = string.substring(n + 1);
        return Integer.valueOf(string2.trim());
    }

    private String parseDB(String string) throws ParserException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            if (string3 == null) {
                string3 = stringTokenizer.nextToken();
                continue;
            }
            string2 = string3;
            string3 = stringTokenizer.nextToken();
        }
        if (string2 == null) {
            throw new ParserException("Fasta parser failed to parse a database filename", null, this.lineNumber, string);
        }
        return string2;
    }

    private String parseID(String string) throws ParserException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ParserException("Fasta parser failed to parse a sequence ID", null, this.lineNumber, string);
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.startsWith(">>")) {
            return string2.substring(2);
        }
        if (string2 == ">") {
            throw new ParserException("Fasta parser encountered a sequence with no ID", null, this.lineNumber, string);
        }
        return string2.substring(1);
    }

    private boolean parseLine(String string, Set set, Map map) throws ParserException {
        int n = string.indexOf(";");
        int n2 = string.indexOf(":");
        String string2 = string.substring(n + 1, n2);
        string2 = string2.trim();
        String string3 = string.substring(n2 + 1);
        string3 = string3.trim();
        if (set.contains(string2)) {
            try {
                if (toDouble.contains(string2)) {
                    Double d = Double.valueOf(string3);
                    map.put(string2, d);
                    return true;
                }
                if (toFloat.contains(string2)) {
                    Float f = Float.valueOf(string3);
                    map.put(string2, f);
                    return true;
                }
                if (toInteger.contains(string2)) {
                    Integer n3 = Integer.valueOf(string3);
                    map.put(string2, n3);
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParserException("Fasta parser failed to parse a double value", null, this.lineNumber, string);
            }
            map.put(string2, string3);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parseSearch(BufferedReader bufferedReader, SearchContentHandler searchContentHandler) throws IOException, BioException, ParserException {
        boolean bl = false;
        this.lineNumber = 0;
        FastaSearchBuilder fastaSearchBuilder = (FastaSearchBuilder)searchContentHandler;
        while ((this.line = bufferedReader.readLine()) != null) {
            ++this.lineNumber;
            if (this.line.startsWith(">>><<<")) {
                this.searchStatus = 0;
                this.hitData.put("querySeqTokens", this.querySeqTokens.toString());
                this.hitData.put("subjectSeqTokens", this.subjectSeqTokens.toString());
                fastaSearchBuilder.endSubHit();
                fastaSearchBuilder.endSearch();
                this.searchParsed = true;
                this.moreSearchesAvailable = false;
                continue;
            }
            switch (this.searchStatus) {
                case 0: {
                    if (!this.line.startsWith(">>>")) break;
                    this.searchStatus = 1;
                    fastaSearchBuilder.setSubjectDB(this.parseDB(this.line));
                    fastaSearchBuilder.startSearch();
                    this.resultSearchParm.clear();
                    this.resultPreAnnotation.clear();
                    if (!this.searchParsed) break;
                    this.searchParsed = false;
                    this.moreSearchesAvailable = true;
                    return this.moreSearchesAvailable;
                }
                case 1: {
                    if (this.line.startsWith(">>")) {
                        this.searchStatus = 2;
                        fastaSearchBuilder.setSearchAnnotationData(this.resultPreAnnotation);
                        fastaSearchBuilder.endHeader();
                        fastaSearchBuilder.startHit();
                        this.hitData.clear();
                        this.hitPreAnnotation.clear();
                        this.querySeqTokens.setLength(0);
                        this.subjectSeqTokens.setLength(0);
                        this.hitData.put("id", this.parseID(this.line));
                        break;
                    }
                    if (this.parseLine(this.line, resultAnnoTokens, this.resultPreAnnotation) || this.parseLine(this.line, resultSearchParmTokens, this.resultSearchParm)) break;
                    throw new ParserException("Fasta parser failed to recognise line type", null, this.lineNumber, this.line);
                }
                case 2: {
                    if (this.line.startsWith(">")) {
                        this.searchStatus = 3;
                        if (!bl) {
                            fastaSearchBuilder.setQuerySeq(this.parseID(this.line));
                            bl = true;
                        }
                        fastaSearchBuilder.endHit();
                        fastaSearchBuilder.startSubHit();
                        break;
                    }
                    if (this.parseLine(this.line, hitAnnoTokens, this.hitPreAnnotation) || this.parseLine(this.line, hitDataTokens, this.hitData)) break;
                    throw new ParserException("Fasta parser failed to recognise line type", null, this.lineNumber, this.line);
                }
                case 3: {
                    if (this.line.startsWith(">")) {
                        this.searchStatus = 4;
                        break;
                    }
                    if (this.parseSequence(this.line, "query", this.hitData)) break;
                    throw new ParserException("Fasta parser failed to recognise line type", null, this.lineNumber, this.line);
                }
                case 4: {
                    if (this.line.startsWith("; al_cons:")) {
                        this.searchStatus = 5;
                        break;
                    }
                    if (this.line.startsWith(">>")) {
                        this.searchStatus = 2;
                        this.hitData.put("querySeqTokens", this.querySeqTokens.toString());
                        this.hitData.put("subjectSeqTokens", this.subjectSeqTokens.toString());
                        fastaSearchBuilder.setHitData(this.hitData);
                        fastaSearchBuilder.setHitAnnotationData(this.hitPreAnnotation);
                        fastaSearchBuilder.endSubHit();
                        fastaSearchBuilder.startHit();
                        this.hitData.clear();
                        this.hitPreAnnotation.clear();
                        this.querySeqTokens.setLength(0);
                        this.subjectSeqTokens.setLength(0);
                        this.hitData.put("id", this.parseID(this.line));
                        break;
                    }
                    if (this.parseSequence(this.line, "subject", this.hitData)) break;
                    throw new ParserException("Fasta parser failed to recognise line type", null, this.lineNumber, this.line);
                }
                case 5: {
                    if (this.line.startsWith(">>")) {
                        this.searchStatus = 2;
                        this.hitData.put("querySeqTokens", this.querySeqTokens.toString());
                        this.hitData.put("subjectSeqTokens", this.subjectSeqTokens.toString());
                        fastaSearchBuilder.setHitData(this.hitData);
                        fastaSearchBuilder.setHitAnnotationData(this.hitPreAnnotation);
                        fastaSearchBuilder.endSubHit();
                        fastaSearchBuilder.startHit();
                        this.hitData.clear();
                        this.hitPreAnnotation.clear();
                        this.querySeqTokens.setLength(0);
                        this.subjectSeqTokens.setLength(0);
                        this.hitData.put("id", this.parseID(this.line));
                        break;
                    }
                    if (!this.line.startsWith(">>><<<")) break;
                    this.searchStatus = 0;
                    this.hitData.put("querySeqTokens", this.querySeqTokens.toString());
                    this.hitData.put("subjectSeqTokens", this.subjectSeqTokens.toString());
                    fastaSearchBuilder.endSubHit();
                    fastaSearchBuilder.endSearch();
                    this.searchParsed = true;
                    this.moreSearchesAvailable = false;
                }
            }
        }
        return this.moreSearchesAvailable;
    }

    private boolean parseSequence(String string, String string2, Map map) {
        if (string.startsWith(";")) {
            if (string.equals("; sq_type: p")) {
                map.put(string2, "protein");
                return true;
            }
            if (string.equals("; sq_type: D")) {
                map.put(string2, "dna");
                return true;
            }
            if (string.startsWith("; al_start:")) {
                map.put(String.valueOf(string2) + "AlStart", this.parseCoord(string));
                return true;
            }
            if (string.startsWith("; al_stop:")) {
                map.put(String.valueOf(string2) + "AlStop", this.parseCoord(string));
                return true;
            }
            if (string.startsWith("; al_display_start:")) {
                map.put(String.valueOf(string2) + "AlDispStart", this.parseCoord(string));
                return true;
            }
            return !map.containsKey("query") || !map.containsKey("subject") || map.get("query").equals(map.get("subject"));
        }
        if (string2.equals("query")) {
            this.querySeqTokens.append(string);
        } else if (string2.equals("subject")) {
            this.subjectSeqTokens.append(string);
        }
        return true;
    }
}

