/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation;

import edu.msu.cme.rdp.classifier.train.LineageSequence;
import edu.msu.cme.rdp.classifier.train.validation.Taxonomy;
import edu.msu.cme.rdp.readseq.utils.orientation.GoodWordIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HierarchyTree {
    private String name;
    private int numOfLeaves;
    private HierarchyTree parent;
    private Map<String, HierarchyTree> subclasses = new HashMap<String, HierarchyTree>();
    private Map leaves = new HashMap();
    private short[] wordOccurrence;
    private boolean wordOccurDone = false;
    private int totalSeqs = 0;
    private int numTotalTestedseq = 0;
    private int missCount = 0;
    private Taxonomy taxon;

    public HierarchyTree(String n, HierarchyTree p, Taxonomy tax) {
        this.name = n;
        this.taxon = tax;
        this.numOfLeaves = -1;
        this.addParent(p);
    }

    private void addParent(HierarchyTree p) {
        this.parent = p;
        if (this.parent != null) {
            this.parent.addSubclass(this);
        }
    }

    private void addSubclass(HierarchyTree c) {
        this.subclasses.put(c.getName(), c);
    }

    public String getName() {
        return this.name;
    }

    public HierarchyTree getParent() {
        return this.parent;
    }

    public Collection<HierarchyTree> getSubclasses() {
        return this.subclasses.values();
    }

    public Collection getLeaves() {
        return this.leaves.values();
    }

    public HierarchyTree getSubclassbyName(String n) {
        return this.subclasses.get(n);
    }

    public int getSizeofChildren() {
        int size = this.subclasses.size();
        if (size > 0) {
            return size;
        }
        return this.getSizeofLeaves();
    }

    public int getSizeofSubclasses() {
        return this.subclasses.size();
    }

    public int getSizeofLeaves() {
        return this.numOfLeaves;
    }

    public void initWordOccurrence(LineageSequence pSeq, float[] wordPriorArr, boolean initWordOccurrence) throws IOException {
        this.numOfLeaves = this.numOfLeaves < 0 ? 1 : ++this.numOfLeaves;
        if (!initWordOccurrence) {
            return;
        }
        GoodWordIterator iterator = new GoodWordIterator(pSeq.getSeqString());
        if (this.wordOccurrence == null) {
            this.wordOccurrence = new short[iterator.getMask() + 1];
        }
        int[] wordList = new int[iterator.getNumofWords()];
        for (int i = 0; i < wordList.length; ++i) {
            wordList[i] = -1;
        }
        int numUniqueWords = 0;
        while (iterator.hasNext()) {
            int index = iterator.next();
            if (this.isWordExist(wordList, index)) continue;
            wordList[numUniqueWords] = index;
            int n = index;
            this.wordOccurrence[n] = (short)(this.wordOccurrence[n] + 1);
            ++numUniqueWords;
            int n2 = index;
            wordPriorArr[n2] = wordPriorArr[n2] + 1.0f;
        }
        this.wordOccurDone = true;
    }

    public void unhideSeq(GoodWordIterator iterator) throws IOException {
        this.numOfLeaves = this.numOfLeaves < 0 ? 1 : ++this.numOfLeaves;
        iterator.resetCurIndex();
        int[] wordList = new int[iterator.getNumofWords()];
        for (int i = 0; i < wordList.length; ++i) {
            wordList[i] = -1;
        }
        int numUniqueWords = 0;
        while (iterator.hasNext()) {
            int index = iterator.next();
            if (this.isWordExist(wordList, index)) continue;
            wordList[numUniqueWords] = index;
            int n = index;
            this.wordOccurrence[n] = (short)(this.wordOccurrence[n] + 1);
            ++numUniqueWords;
        }
        this.changeParentSeqCount(1);
    }

    public void hideSeq(GoodWordIterator iterator) throws IOException {
        if (this.wordOccurrence == null) {
            throw new IllegalStateException("unable to hide the sequence, the word occurrence is null ");
        }
        iterator.resetCurIndex();
        int[] wordList = new int[iterator.getNumofWords()];
        for (int i = 0; i < wordList.length; ++i) {
            wordList[i] = -1;
        }
        int num = 0;
        while (iterator.hasNext()) {
            int index = iterator.next();
            if (this.isWordExist(wordList, index)) continue;
            wordList[num] = index;
            int n = index;
            this.wordOccurrence[n] = (short)(this.wordOccurrence[n] - 1);
            ++num;
        }
        --this.numOfLeaves;
        this.changeParentSeqCount(-1);
    }

    public void changeParentSeqCount(int i) {
        if (this.parent != null) {
            this.parent.numOfLeaves += i;
            this.parent.changeParentSeqCount(i);
        }
    }

    private boolean isWordExist(int[] wordList, int wordIndex) {
        for (int i = 0; i < wordList.length; ++i) {
            if (wordList[i] == wordIndex) {
                return true;
            }
            if (wordList[i] != -1) continue;
            return false;
        }
        return false;
    }

    public boolean isWordOccurDone() {
        return this.wordOccurDone;
    }

    public int getWordOccurrenceSize() {
        return this.wordOccurrence.length;
    }

    public int getNumberofUniqueWords() {
        int count = 0;
        for (int i = 0; i < this.wordOccurrence.length; ++i) {
            if (this.wordOccurrence[i] <= 0) continue;
            ++count;
        }
        return count;
    }

    public void createWordOccurrenceFromSubclasses() {
        if (this.isWordOccurDone()) {
            return;
        }
        if (this.subclasses.size() > 0) {
            int len = 0;
            for (HierarchyTree child : this.subclasses.values()) {
                if (!child.isWordOccurDone()) {
                    child.createWordOccurrenceFromSubclasses();
                }
                len = child.getWordOccurrenceSize();
            }
            this.wordOccurrence = new short[len];
            for (int i = 0; i < len; ++i) {
                for (HierarchyTree child : this.subclasses.values()) {
                    int n = i;
                    this.wordOccurrence[n] = (short)(this.wordOccurrence[n] + child.getWordOccurrence(i));
                }
            }
        }
    }

    public int getWordOccurrence(int wordIndex) {
        return this.wordOccurrence[wordIndex];
    }

    public int getNumOfLeaves() {
        if (this.numOfLeaves >= 0) {
            return this.numOfLeaves;
        }
        if (this.getSizeofSubclasses() <= 0) {
            this.numOfLeaves = this.getSizeofLeaves();
            return this.numOfLeaves;
        }
        this.numOfLeaves = 0;
        for (HierarchyTree child : this.subclasses.values()) {
            this.numOfLeaves += child.getNumOfLeaves();
        }
        return this.numOfLeaves;
    }

    public void increTotalSeqs() {
        ++this.totalSeqs;
        if (this.parent != null) {
            this.parent.increTotalSeqs();
        }
    }

    public int getTotalSeqs() {
        return this.totalSeqs;
    }

    public int getMissCount() {
        return this.missCount;
    }

    public int getNumTotalTestedseq() {
        return this.numTotalTestedseq;
    }

    public void incNumTotalTestedseq() {
        ++this.numTotalTestedseq;
        if (this.parent != null) {
            this.parent.incNumTotalTestedseq();
        }
    }

    public void incMissCount() {
        ++this.missCount;
        if (this.parent != null) {
            this.parent.incMissCount();
        }
    }

    public Taxonomy getTaxonomy() {
        return this.taxon;
    }

    public boolean isSingleton() {
        return this.totalSeqs <= 1;
    }

    public void getNodeList(String level, List nodeList) {
        if (this.taxon.getHierLevel().equalsIgnoreCase(level)) {
            nodeList.add(this);
            return;
        }
        Collection<Object> al = new ArrayList();
        al = this.getSubclasses();
        if (al.isEmpty()) {
            return;
        }
        Iterator<Object> i = al.iterator();
        while (i.hasNext()) {
            ((HierarchyTree)i.next()).getNodeList(level, nodeList);
        }
    }

    public void getNodeMap(String level, HashMap<String, HierarchyTree> nodeMap) {
        if (this.taxon.getHierLevel().equalsIgnoreCase(level)) {
            nodeMap.put(this.name, this);
            return;
        }
        Collection<Object> al = new ArrayList();
        al = this.getSubclasses();
        if (al.isEmpty()) {
            return;
        }
        Iterator<Object> i = al.iterator();
        while (i.hasNext()) {
            ((HierarchyTree)i.next()).getNodeMap(level, nodeMap);
        }
    }
}

