/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.topology.merge;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Vector;
import usf.saav.common.HashDisjointSet;
import usf.saav.topology.TopoGraph;
import usf.saav.topology.merge.AbstractMergeTree;
import usf.saav.topology.merge.AbstractMergeTreeNode;

public class MergeTree
extends AbstractMergeTree
implements Runnable {
    protected Comparator<? super AbstractMergeTree.JNode> comparator;
    protected TopoGraph<? extends TopoGraph.Vertex> sf;
    protected boolean operationComplete = false;

    protected MergeTree() {
    }

    public MergeTree(TopoGraph<? extends TopoGraph.Vertex> topoGraph) {
        this(topoGraph, new AbstractMergeTreeNode.ComparatorValueAscending());
    }

    public MergeTree(TopoGraph<? extends TopoGraph.Vertex> topoGraph, Comparator<? super AbstractMergeTree.JNode> comparator) {
        this.sf = topoGraph;
        this.comparator = comparator;
    }

    @Override
    public void run() {
        if (this.operationComplete) {
            return;
        }
        int n = this.sf.size();
        PriorityQueue<? super AbstractMergeTree.JNode> priorityQueue = new PriorityQueue<AbstractMergeTree.JNode>(n, this.comparator);
        for (int i = 0; i < n; ++i) {
            this.grid.add(new AbstractMergeTree.JNode(((TopoGraph.Vertex)this.sf.get(i)).value(), i, this.sf.get(i)));
            priorityQueue.add((AbstractMergeTree.JNode)this.grid.get(i));
        }
        HashDisjointSet<AbstractMergeTree.JNode> hashDisjointSet = new HashDisjointSet<AbstractMergeTree.JNode>();
        while (priorityQueue.size() > 0) {
            AbstractMergeTree.JNode jNode = (AbstractMergeTree.JNode)priorityQueue.poll();
            for (TopoGraph.Vertex vertex : ((TopoGraph.Vertex)this.sf.get(jNode.getID())).neighbors()) {
                AbstractMergeTree.JNode jNode2;
                AbstractMergeTree.JNode jNode3 = (AbstractMergeTree.JNode)this.grid.get(vertex.getID());
                if (this.comparator.compare(jNode3, jNode) >= 0 || jNode == (jNode2 = hashDisjointSet.find(jNode3))) continue;
                hashDisjointSet.union(jNode, jNode2);
                jNode.addChild(jNode2);
            }
            this.head = jNode;
        }
        this.correctMonkeySaddles();
        this.setParents();
        this.operationComplete = true;
    }

    protected void correctMonkeySaddles() {
        LinkedList<AbstractMergeTreeNode> linkedList = new LinkedList<AbstractMergeTreeNode>();
        linkedList.add(this.head);
        while (!linkedList.isEmpty()) {
            AbstractMergeTreeNode abstractMergeTreeNode = (AbstractMergeTreeNode)linkedList.poll();
            if (abstractMergeTreeNode.childCount() > 2) {
                Vector<AbstractMergeTreeNode> vector = abstractMergeTreeNode.children;
                abstractMergeTreeNode.children = new Vector();
                AbstractMergeTree.JNode jNode = new AbstractMergeTree.JNode(abstractMergeTreeNode.getValue(), abstractMergeTreeNode.getID(), abstractMergeTreeNode.creator);
                abstractMergeTreeNode.children.add(vector.get(0));
                abstractMergeTreeNode.children.add(jNode);
                for (int i = 1; i < vector.size(); ++i) {
                    jNode.addChild(vector.get(i));
                }
                this.grid.add(jNode);
            }
            linkedList.addAll(abstractMergeTreeNode.getChildren());
        }
    }
}

