## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)

## ----define-------------------------------------------------------------------
tmpdr <- tempdir()
datdir <- file.path(gsub("\\","/",tmpdr,fixed=TRUE),"datdir")
fname <- system.file("formats", "formats.sas7bdat", package = "repfun")
dir.create(datdir,showWarnings=FALSE)
file.copy(from=fname,to=paste0(datdir,'/formats.sas7bdat'))
repfun::rs_setup(R_RFMTDIR=datdir)

## ----makelist-----------------------------------------------------------------
list <- repfun::ru_data2codelist(repfun:::rfenv$rfmtdata$formats())

## ----results------------------------------------------------------------------
message(paste0('First Code Value: ',list$SEXS$START[[1]])) # Code value 1
message(paste0('First Decode Value: ',list$SEXS$LABEL[[1]])) # Decode value 1
message(paste0('Second Code Value: ',list$SEXS$START[[2]])) # Code value 2
message(paste0('Second Decode Value: ',list$SEXS$LABEL[[2]])) # Decode value 2

