$!- TEXPRINT.COM ---------------------------------------------------------------
$!  ~~~~~~~~~~~~
$!  Command file to print a file to the laser printer queue designated by
$!  P1.
$!
$!  This command procedure is invoked by the user typing TEXPRINT followed
$!  by the name(s) of the file(s) to be printed.  The login procedures
$!  executed by users of TeX/LaTeX should arrange to define the DCL symbol
$!  TEXPRINT thus:
$!        $ TEXP*rint :== @TEX_COM:TEXPRINT devname
$!  where devname is the name of the output device's queue; as published,
$!  this procedure assumes that the full name of the queue is given by
$!  devname+"$LASER"
$!  
$!  Parameters:
$!
$!	P1	(required)  The name of the queue to be used for printing
$!	P2	(required)  Name of file(s) to be printed and/or optional
$!	                    qualifiers.  If this consists of qualifiers,
$!			    they are placed globally, and the filename must
$!			    follow in P3... Multiple file names should be
$!			    separated by commas
$!	P3-P8	(optional)  Further optional qualifiers, which will be
$!			    appended to the last filename used.
$!------------------------------------------------------------------------------
$!
$! Ensure printer queue specified
$! 
$ 	SAY := WRITE SYS$OUTPUT
$	IF P1 .EQS. ""
$	THEN
$	    SAY "%TEXPRINT-F-NOQUEUE, No laser printer queue specified"
$	    EXIT %X10000004
$	ENDIF
$	queue_name = P1 + "$LASER"
$	xxx = F$GETQUI("DISPLAY_QUEUE","QUEUE_STATUS",queue_name)
$	IF xxx .EQS. ""
$	THEN
$	    SAY "%TEXPRINT-F-BADQUEUE, No such queue ''queue_name'"
$	    EXIT %X10000004
$	ENDIF
$!
$! Ensure file name specified
$! 
$Get_Name:
$ 	IF P2 .EQS. ""
$	THEN 
$	    INQUIRE P2 "_File name"
$	    GOTO Get_Name
$	ENDIF
$!
$! Extract leading qualifier or single filename from P2...
$! 
$	param_ctr = 2
$	had_name = "FALSE"
$	global_qual = ""
$	file_list = ""
$	related_spec = ".LN3"
$	had_warning = "FALSE"
$Next_Param:
$	next_par = F$EDIT(P'param_ctr,"TRIM,UPCASE")
$ 	first_part = F$ELEMENT(0,",",next_par)
$	following = F$ELEMENT(1,",",next_par) .NES. ","
$!
$! If Pn starts with a "/", it must be a global qualifier, if we haven't
$! yet had any file names, or a trailing qualifier after the last file.
$! 
$	IF F$EXTRACT(0,1,first_part) .EQS. "/"
$	THEN
$	    IF had_name
$	    THEN
$		file_list = file_list + next_par
$		param_ctr = param_ctr + 1
$		IF param_ctr .GT. 8 THEN $ GOTO Print_It
$		GOTO Next_Param
$	    ENDIF
$	    global_qual = global_qual + next_par
$	    param_ctr = param_ctr + 1
$	    IF param_ctr .GT. 8
$	    THEN
$		SAY "%TEXPRINT-E-NOFILES, No files selected for printing"
$		EXIT %X10000002
$	    ENDIF
$	    GOTO Next_Param
$	ENDIF
$!
$! Otherwise, what's in first_part is a filename, with an optional trailing
$! qualifier (local to that file).
$!
$	IF had_name
$	THEN
$	    SAY "%TEXPRINT-W-PARAMS, Too many parameters \''next_par'\"
$	    had_warning = "TRUE"
$	    param_ctr = param_ctr + 1
$	    IF param_ctr .GT. 8 THEN $ GOTO Print_It
$	    GOTO Next_Param
$	ENDIF
$!
$! Extract file name preceding any local qualifiers, and default to .LN3
$!
$	elem_ctr = 1
$Next_Element:
$	file_name = F$ELEMENT(0,"/",first_part)
$	first_part = first_part - file_name
$	next_file = F$PARSE(file_name,,related_spec,,"SYNTAX_ONLY")
$	IF F$SEARCH(next_file) .EQS. ""
$	THEN 
$	    SAY "%TEXPRINT-W-NOSUCHFILE, Couldn't find file ''next_file'"
$	    had_warning = "TRUE"
$	ELSE
$	    had_name = "TRUE"
$	    IF file_list .NES. "" THEN $ file_list = file_list + ","
$	    file_list = file_list + next_file + first_part
$	    related_spec = next_file
$	ENDIF
$!
$! Now go back for next element of next_par, if applicable
$!
$	IF .NOT. following then $ GOTO Print_It
$ 	first_part = F$ELEMENT(elem_ctr,",",next_par)
$	elem_ctr = elem_ctr + 1
$	following = F$ELEMENT(elem_ctr,",",next_par) .NES. ","
$	GOTO Next_Element
$!
$! We've got everything required to execute the print command
$!
$Print_It:
$	IF .NOT. had_name
$	THEN
$	    SAY "%TEXPRINT-F-CREJOB, error creating job"
$	    SAY "-JBC-E-EMPTYJOB, no files specified in job request"
$	    EXIT %X10000004
$	ENDIF
$!
$! The queue itself decides whether we print a flag page or not
$!
$	PRINT/QUEUE='P1'$LASER/FORM=PLOT$FORM/NOHEADER/NOFEED -
	    'global_qual' 'file_list'
$	print_stat = $STATUS
$	IF .NOT. print_stat THEN $ EXIT print_stat
$	IF had_warning THEN $ EXIT %X10000000
$ 	EXIT %X10000001
$!
$!- END OF TEXPRINT.COM --------------------------------------------------------
