
package require Cpptcl
package require Iwidgets

class cpp::WindowTree {
    inherit cpp::Window 
    
    constructor {args} {
		eval cpp::Window::constructor $args
	} {
	   	itk_component add frame { 
    		frame $itk_interior.frame
    	}
		pack $itk_component(frame) -side top -fill both -expand yes
		
		addHierarchy
    }
    
    destructor {
    }

	public variable hierType "cpp::TreeHierarchy" {
		#catch { delete object $hierarchy }
	}
	
	method drawTree {} { myHierarchy draw }

    method configurationMenu { menu } {
		$menu add command -label "Flip layout" \
			-command [code $this toggleLayout]
		$menu add command -label "Zoom window" \
			-command [code $this zoomWindow]
    }
    
	public variable hierarchy ""
    method myHierarchy {args} {	eval $hierarchy $args }
    method myframe {} { return $itk_component(frame) }

    method addHierarchy {} {
		set hierarchy [$hierType $itk_component(frame).h]
		pack $hierarchy -fill both -expand yes
    }

    method toggleLayout {} {}    
    method standardMenuBar {} {}

}

body cpp::WindowTree::toggleLayout {} {
	if {[utilGetConfigValue [mytree] -layout] == "horizontal"} {
		[mytree] config -layout vertical
	} else {
		[mytree] config -layout horizontal
	}
	
	# change the layout of the nodes so that the bitmap is on top for
	# vertical trees and at left for horizontal trees
	foreach i [[mycanvas] find withtag text] {
		set obj [lindex [[mycanvas] gettags $i] 2]
		$obj layoutNode
		[mytree] nodeconfig $obj
	}
	
	[mytree] draw
	#tree_center [mytree]
}

body cpp::WindowTree::standardMenuBar {} {
	cpp::Window::standardMenuBar
	set mb $itk_component(mbar)
	
	$mb.file.menu add command -label "Save state..." \
		-command [code $this  cpxSaveState]
	$mb.file.menu add command -label "Restore state..." \
		-command [code $this  cpxRestoreState]
	$mb.file.menu add command -label "Flip layout" \
		-command [code $this toggleLayout]
	
	menubutton $mb.configure -text "Configure" -menu $mb.configure.menu
	pack $mb.configure -side right
	menu $mb.configure.menu
	configurationMenu $mb.configure.menu
	
	# obsolete command
	#tk_menuBar $mb $mb.file $mb.edit $mb.configure $mb.help
	
	focus $mb
	
}


