#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <bios.h>
#include <ctype.h>

int main(int argc, char *argv[])
{
  char buf[100], name[20];
  int key, tabs, c;
  FILE *f, *d;

  if (argc <= 0)
    return 1;

  f = fopen("key.h", "w");
  if (f == NULL) {
    fprintf(stderr, "%s: couldn't open key.h\n", argv[0]);
    return 2;
  }
  d = fopen("keyname.def", "r");
  if (d == NULL) {
    fprintf(stderr, "%s: couldn't open keyname.def\n", argv[0]);
    return 3;
  }
  clrscr();
  fprintf(f, "/* KEY.H -- Key macros (generated by %s) */\n"
	     "#if !(defined(KEY)||defined(AKEY)||defined(NKEY))\n"
	     "/* key definitions */\n"
	     "#define ctrl(C)\t((C)-'A'+1)\n", argv[0]);
  while (fgets(buf, sizeof buf, d) != NULL) {
    buf[strlen(buf)-1] = '\0';
    gotoxy(1,1);
    cprintf("Type %s             ", buf);
    tabs = strlen(buf)/8;
    key = bioskey(0);
    if (key & 0xff)
      key &= 0xff;
    fprintf(f, "#define %s", buf);
    while(tabs++ < 3)
      fprintf(f, "\t");
    fprintf(f, "%#04x\n", key);
  }
  fprintf(f, "#else\n"
	     "/* key table builder */\n"
	     "#ifdef KEY\n"
	     "#define AKEY KEY\n"
	     "#define NKEY KEY\n"
	     "#endif\n");
  for (c = 'a'; c <= 'z'; ++c)
    fprintf(f, "AKEY(%c,%c,0x%x,0x%x)\n", toupper(c), c, toupper(c), c);
  for (c = '0'; c <= '9'; ++c)
    fprintf(f, "NKEY(%c,%c,0x%x,0x%x)\n", toupper(c), c, toupper(c), c);
  fprintf(f, "#endif\n");
  fclose(f);
  fclose(d);
  return 0;
}
