/*
 * LaTeD Version 1.1
 * (c) Gene Ressler 1993, 94, 97
 *   de8827@trotter.usma.edu
 *
 * LaTeD is a graphical editor for drawings in the LaTeX "picture" 
 * environment.  It runs under MSDOS or in a Windows DOS box.  The
 * distribution includes full sources, including LaTeX source for 
 * its documentation.
 *
 * No warranty of this software is expressed or implied by the author.
 *
 * Copy and use this program freely for any purpose except for sale
 * of the program (including the source code) itself.  That is, 
 * no one can copy this program for the purpose of providing it to 
 * another person in exchange for money or other compensation, even 
 * if this program is only part of the exchange.
 *
 * All copies of computer source code in this distribution, whether
 * copies in whole or in part, must have this notice attached.
 */

/* WINDOW.H --- Declarations for window subsystem. */

#ifdef NDEBUG
#define QUICK pascal near
#else
#define QUICK
#endif
#define LOCAL(T) static T QUICK
#define TYPEDEF_LOCAL(T) typedef T QUICK

#define bit(B) (1 << (B))
#define notbit(B) (~bit(B))
#define set_bit(Mask, Bit, BoolVal)     \
	if (BoolVal) (Mask) |= bit(Bit); else (Mask) &= notbit(Bit)
/* Safe and tracing malloc. */
#define malloc(N) safe_malloc(N)
#define realloc(P, N) safe_realloc(P, N)
#define free(P)   safe_free(P)
#define fclose(P) safe_fclose(P)
void *safe_malloc(unsigned n);
void *safe_realloc(void *p, unsigned n);
void safe_free(void *p);
void safe_fclose(void *p);
char *dtg(void);
int strpcmp(const void *v1, const void *v2);
/* Search a string table for the token in the given buffer. */
#define str_search(B,T) bsearch(B,T,sizeof T/sizeof T[0],sizeof T[0],strpcmp)

/* Keys. */

typedef struct {
  char *str;
  signed char hot_char;
} HOT_TEXT_REC, *HOT_TEXT;

char *key2str(int ch, char *str);
int hot_p(int key, int ch);
int key_hot_p(int key, HOT_TEXT text);
int key_match_p(int key, HOT_TEXT text);

#define NO_HOT_KEY      0
#define SUBMENU_MARK    (-1)

/* Mouse. */

extern int x_min, y_min, x_max, y_max;
void set_mouse_speed(int speed);
int get_mouse_speed(void);
void get_mouse_status(int *x, int *y, unsigned *mask);
void set_mouse_cursor(unsigned far *bits, int hot_x, int hot_y);
void set_wait_cursor(int p);
void show_mouse_cursor(int p);
void push_mouse_cursor_state(int p);
void pop_mouse_cursor_state(void);
void protect_mouse_cursor(int x0, int y0, int x1, int y1);
void unprotect_mouse_cursor(void);
int set_mouse_arena(int x0, int y0, int x1, int y1);

/* Events */

typedef enum event_type {
  eMOUSE_MOTION,
  eBUTTON_PRESS,
  eBUTTON_RELEASE,
  eHOTKEY,
  eVISIBLE_HOTKEY,
  eKEYSTROKE,
  eGAIN_FOCUS,
  eLOSE_FOCUS,
  eENTRY,
  eDEPARTURE,
  eMAP,
  eUNMAP,
#define eN_PER_WINDOW_EVENT_TYPES eCTRL_KEY_PRESS
  eCTRL_KEY_PRESS,
  eCTRL_KEY_RELEASE,
  eTICK0,
  eTICK1,
  eTICK2,
  eTICK3,
  eN
} EVENT_TYPE;

#define MOUSE_EVENTS    (bit(eMOUSE_MOTION)|bit(eBUTTON_PRESS)|bit(eBUTTON_RELEASE)|bit(eENTRY)|bit(eDEPARTURE))

typedef enum button {
  bNONE = -1,
  bLEFT,
  bMIDDLE,
  bRIGHT,
  bN
} MOUSE_BUTTON;

typedef enum ctrl_key {
  ckRIGHT_SHIFT,
  ckLEFT_SHIFT,
  ckCTRL,
  ckALT,
  ckSCROLL_LOCK,
  ckNUM_LOCK,
  ckCAPS_LOCK,
  ckINSERT,
  ckN
} CTRL_KEY;

typedef union event {

  EVENT_TYPE type;

  struct map_event {
    EVENT_TYPE type;
    struct window *window;
  } map;

  struct mouse_event {
    EVENT_TYPE type;            /* press or release */
    struct window *window;      /* window where event occurred. */
    int x, y;                   /* mouse location at event */
    MOUSE_BUTTON button;        /* button affected by event */
    unsigned mask;              /* status of all buttons */
  } mouse;

  struct hotkey_event {
    EVENT_TYPE type;
    struct window *window;
    int key;
  } hotkey;

  struct keystroke_event {
    EVENT_TYPE type;
    struct window *window;
    int key;                    /* extended code for key stroked */
    unsigned mask;
  } keystroke;

  struct focus_event {
    EVENT_TYPE type;
    struct window *window;
    struct window *other_window;
  } focus;

  struct ctrl_key_event {
    EVENT_TYPE type;
    int key,                    /* key affected by event */
	mask;                   /* status of all control keys */
  } ctrl_key;

  struct tick_event {
    EVENT_TYPE type;
    int timer;                  /* index of timer triggering event */
  } tick;

} EVENT_REC, *EVENT;

#define delta(S)                ((unsigned long)((S)*CLK_TCK))
#define ctrl_keystroke_p(E)     ((E)->keystroke.key & 0xff00)

/* Handlers. */
typedef void *ENV;
typedef void (*HANDLER_CODE)(EVENT);

typedef void (*ACTION_CODE)(ENV);
typedef struct action_closure {
  ENV env;
  ACTION_CODE code;
} ACTION_CLOSURE_REC, *ACTION_CLOSURE;

typedef void (*POSITION_ACTION_CODE)(int, ENV);
typedef struct {
  ENV env;
  POSITION_ACTION_CODE code;
} POSITION_ACTION_CLOSURE_REC, *POSITION_ACTION_CLOSURE;

typedef void (*NAME_ACTION_CODE)(char*, ENV);
typedef struct {
  ENV env;
  NAME_ACTION_CODE code;
} NAME_ACTION_CLOSURE_REC, *NAME_ACTION_CLOSURE;

/* Timer allocation. */
#define N_TIMERS (eN - eTICK0)
enum { tDOUBLE_CLICK, tREPEAT, tCURSOR, tUSER0 };
#define eTICK(T) (eTICK0 + T)

extern int ptr_x, ptr_y;
#define pointer_x(W)    (ptr_x - (W)->x)
#define pointer_y(W)    (ptr_y - (W)->y)
extern unsigned button_mask, ctrl_key_mask;
extern HANDLER_CODE global_event_handler[eN];
void stop_timer (int n);
void start_timer (int n, unsigned long delta, short reset_p);
#ifdef NO_ASM
int run(void);
#else
int _run(int dummy);
#define run()   _run(0)
#endif
void stop(int rtn);
void stopall(void);
int init_events(int x0, int y0, int x1, int y1);
int generalized_press_p(EVENT e, int button);
int generalized_release_p(EVENT e, int button);
void ungrab_mouse(void);
void begin_repeat(ACTION_CODE code, ENV env);
void end_repeat(void);
extern int double_click_delta;
#define set_double_click_delta(D)       (double_click_delta = (D))
#define get_double_click_delta()        double_click_delta
int double_click_p(void *p);
void stop_action_code(ENV env);
void refuse_keystroke(EVENT e);

void do_nothing(void);
extern struct closure {
  ENV env;
  void (*code)(void);
} null_closure[1];

#define null_handler_code ((HANDLER_CODE)do_nothing)
#define null_action_code  ((ACTION_CODE)do_nothing)
#define null_position_action_code ((POSITION_ACTION_CODE)do_nothing)
#define null_name_action_code ((NAME_ACTION_CODE)do_nothing)

/* Windows */

typedef enum window_status {
 wsMAPPED,
 wsVISIBLE,
 wsSAVE_UNDER,
 wsDYNAMIC,
 wsSTOP_ROOT,
} WINDOW_STATUS;

#define w_status_p(W,S) ((W)->status_mask & bit(S))
#define NO_COLOR -1
#define TRANSPARENT -2
#define colorless_p(C)  ((C)<0)

typedef struct { int x0, y0; } SAVE_HEADER;
typedef struct { int x0, y0; char bits[1]; } SAVE_REC, *SAVE;

typedef struct window {
  unsigned id, event_mask, status_mask;
  struct window *parent, *next, *prev, *kids;
  int x, y, width, height;
  signed char bg_color, border_color, border_width;
  SAVE save;
  HANDLER_CODE handler;
} WINDOW_REC, *WINDOW;

#define _W_ {0xffff,0,0,NULL,NULL,NULL,NULL,0,0,0,0,0,0,NULL,NULL}
#define static_WINDOW(N)        static WINDOW_REC N[1] = _W_;
#define window_x_wrt(W,A)       ((W)->x - (A)->x)
#define window_y_wrt(W,A)       ((W)->y - (A)->y)
#define window_x(W)             window_x_wrt(W, (W)->parent)
#define window_y(W)             window_y_wrt(W, (W)->parent)
#define CENTER_WINDOW   -32768

#define event_enabled_p(W, E)   ((W)->event_mask & bit(E))
#define handler_env(W)          ((W)->handler.env)
#define handler_code(W)         ((W)->handler.code)

#define BeginDefDispatch(N) \
  static void N ## _dispatch(EVENT e) { switch (e->type) {
#define DispatchAction(E, Code) case E: Code; break;
#define Dispatch(E, P) DispatchAction(E, P(e))
#define And : case
#define EndDefDispatch(N) } }
#define SetDispatch(W, N) ((W)->handler = N ## _dispatch)


extern WINDOW focus_window, root_window, ptr_window;
void protect_cursor(WINDOW w);
void unprotect_cursor(void);
void walloc(void *p, unsigned n);
WINDOW open_window(WINDOW w, WINDOW parent, int x, int y, int width, int height, 
		   int border_width, int border_color, int bg_color, 
		   unsigned event_mask);
#define make_window(P,X,Y,W,H,BW,C,E)  open_window(NULL,P,X,Y,W,H,BW,C,E)
#define static_resource_opened_p(R)     (((WINDOW)(R))->id != 0xffff)
void set_window_border_color(WINDOW w, int color);
void clear_window(WINDOW w, int map_event_p);
void map_window(WINDOW w);
void unmap_window(WINDOW w);
void destroy_window(WINDOW w);
void locate_window(WINDOW w, int x, int y, int protect_border_p);
int set_window_bg_color(WINDOW w, int color, int map_event_p);
void set_window_save_under(WINDOW w);
void set_focus(WINDOW w);
void unset_focus(WINDOW w);
void protect_focus(void);
void unprotect_focus(void);

/* Supplemented graphics. */
int init_graphics(void);
int close_graphics(void);
void push_graphics_state(WINDOW w, int clip_p);
void pop_graphics_state(void);
void *make_subdued_bitmap(void *void_bits, int width, int height);
void *make_image(void *void_bits, int width, int height, int fg, int bg);
void out_hot_textxy(int x, int y, HOT_TEXT text);
void far arrowhead(int x0, int y0, int x1, int y1);
void arcs(int x0, int y0, int r, unsigned char mask);
void far oval(int x0, int y0, int x1, int y1, int r, unsigned mask);
int scale_int(int x, int num, int den);
int signed_scale_int(int x, int num, int den);

/* Colors of default palette */
typedef enum {
  cBLACK, cBLUE, cGREEN, cCYAN, 
  cRED, cMAGENTA, cBROWN, cLIGHTGRAY,
  cDARKGRAY, cLIGHTBLUE, cLIGHTGREEN, cLIGHTCYAN, 
  cLIGHTRED, cLIGHTMAGENTA, cYELLOW, cWHITE, 
} DEFAULT_COLOR;

int isqrt(long x);
long sum_sqr(int x, int y);
#undef min
#undef max
int min(int x, int y);
int max(int x, int y);
long sqr(int x);
int pt_seg_dist(int x, int y, int x0, int y0, int x1, int y1);
int pt_box_dist(int x, int y, int x0, int y0, int x1, int y1);
int pt_oval_dist(int x, int y, int x0, int y0, int x1, int y1, int r, unsigned mask);
int in_box_p(int x, int y, int x0, int y0, int x1, int y1);
int in_circle_p(int x, int y, int x0, int y0, int r);

/* Event roots. */

void push_root_window(WINDOW w, int stop_p);
void pop_root_window(void);
void push_hotkey_root(WINDOW w);
void pop_hotkey_root(void);

/* Menus */

enum {
  meENABLED,
  meRULED,
  meREVERSED,
  meSUBMENU,
  meHOT_HOT_CHAR,
  meACT_ON_PRESS,
};

enum {
  mBAR,
  mSAVE_UNDER,
};

typedef struct menu {
  WINDOW_REC window;
  struct menu_entry *entries;
  int n_entries, width;
  unsigned status;
  struct menu *super;
  struct menu_entry *cursor;
} MENU_REC, *MENU, PULLDOWN_REC, *PULLDOWN;

#define m_status_p(M, S)    ((M)->status & bit(S))

typedef struct menu_entry {
  WINDOW_REC window;
  HOT_TEXT_REC text;
  int hot_key;
  unsigned char status;
  ACTION_CLOSURE_REC action;
} MENU_ENTRY_REC, *MENU_ENTRY;

#define me_status_p(M, S)       ((M)->status & bit(S))
#define NO_HOT_CHAR             (-128)
#define HOT_SPACE               (-127)

void open_menu(MENU m, WINDOW parent);
#define open_pulldown_bar(B, P) open_menu(B, P)
void popup_menu(WINDOW m);
void locate_menu(WINDOW m, int x, int y);
void activate_submenu(ENV env);
#define enable_menu_entry(E)    ((E)->status |= bit(meENABLED))
#define disable_menu_entry(E)   ((E)->status &= notbit(meENABLED))

/* Dumb text windows. */

typedef struct text {
  WINDOW_REC window;
  char **lines;
  int n_lines, justify;
} TEXT_REC, *TEXT;

#if !defined(__GRAPHX_DEF_) && !defined(__GRAPHICS_H)
struct pointtype { int x, y; };
#endif
struct pointtype text_size(TEXT td);
void open_text(TEXT td, int x, int y, WINDOW parent);

/* Message popups. */
typedef enum {
  mYES,
  mNO,
  mOK,
  mCANCEL,
  mN
} MESSAGE_BUTTON;

MESSAGE_BUTTON message(unsigned buttons, WINDOW parent, char *fmt, ... );

#define TAB_ESC "\xff"
#define TAB_ESC_CHAR '\xff'

/* Buttons. */

typedef enum {
  bENABLED,
  bBITMAP,
  bTOGGLE,
  bSELECTOR,
  bON,
  bREPEAT,
  bHAVE_FOCUS,
} BUTTON_STATUS;

typedef struct button_desc {
  WINDOW_REC window;
  void *icon;
  int width, height, hot_key;
  signed char shadow_width,
	      border_width,
	      fg_color,
	      bg_color;
  unsigned status;
  ACTION_CLOSURE_REC action;
} BUTTON_REC, *BUTTON;

#define b_status_p(B, S)        (bit(S) & (B)->status)
#define set_button_action(B, Code, Env) \
  ((B)->action.code = (ACTION_CODE)(Code), (B)->action.env = (ENV)(Env))

typedef enum {
  sENABLED,
  sVERTICAL,
} SELECTOR_STATUS;

typedef struct toggle_set {
  WINDOW_REC window;
  BUTTON buttons;
  int n_buttons;
  unsigned status;
  int focus;
} SELECTOR_REC, *SELECTOR;

#define s_status_p(T,S) ((T)->status & bit(S))

void open_button(BUTTON bd, int x, int y, WINDOW parent);
int button_width(BUTTON bd);
int button_height(BUTTON bd);
void enable_button(BUTTON w);
void disable_button(BUTTON w);
void set_button_toggle(BUTTON b, unsigned mask);
void open_selector(SELECTOR sd, int x, int y, WINDOW parent);
void feign_button_press(BUTTON b);

/* Edit boxes. */

typedef enum {
  ebENABLED,
  ebUNEDITED,
} EDIT_BOX_STATUS;

typedef struct key_action {
  int key;
  NAME_ACTION_CLOSURE_REC action;
} KEY_NAME_ACTION_REC, *KEY_NAME_ACTION;

typedef struct edit_box {
  WINDOW_REC window;
  HOT_TEXT_REC title;           /* name over edit box */
  int box_len,                  /* number visible chars */
      buf_len;                  /* max length of edited string */
  KEY_NAME_ACTION key_actions;  /* key actions */
  int n_key_actions;
  unsigned status;              /* flags */
  int x_left,                   /* pixel x of leftmost char */
      ch_width, ch_height,      /* char dimensions at creation */
      str_len,                  /* current edited string len */
      cursor_pos,               /* current cursor char index */
      left_pos;                 /* char index of leftmost visible char */
  char *buf;                    /* edit buffer (length buf_len+1) */
  BUTTON_REC larrow,            /* arrows */
	     rarrow;
} EDIT_BOX_REC, *EDIT_BOX;

#define eb_status_p(B, S)       (bit(S) & (B)->status)

void open_edit_box(EDIT_BOX ebd, int x, int y, WINDOW parent);
void set_edit_text(EDIT_BOX eb, char *str);
char *get_edit_text(EDIT_BOX eb);
void enable_edit_box(EDIT_BOX eb);
void disable_edit_box(EDIT_BOX eb);

/* Scroll bars. */

typedef struct scrollbar_desc {
  WINDOW_REC window;
  HOT_TEXT_REC title;   /* name over scrollbar */
  int length,           /* length in pixels */
      n_pos,            /* number of valid positions */
      n_inc_pos,        /* number of positions in an increment */
      n_step_pos,       /* number of positions in a step */
      pos;              /* current position */
  unsigned status;
  POSITION_ACTION_CLOSURE_REC action;
  BUTTON_REC arrow0, arrow1, slider;
} SCROLLBAR_REC, *SCROLLBAR;

typedef enum {
  sbENABLED,
  sbVERTICAL,
  sb1OF2,       /* Allow space at corner for untouched area. */
  sbREVERSE,    /* Use reversed coordinate scale. */
} SCROLLBAR_STATUS;

#define sb_status_p(SB, S)      (bit(S) & (SB)->status)
#define DEFAULT -32768
#define FULL_LENGTH -32768

void open_scrollbar(SCROLLBAR sbd, int x, int y, WINDOW parent);
void enable_scrollbar(SCROLLBAR sb);
void disable_scrollbar(SCROLLBAR sb);
int scrollbar_thickness(int n_borders);
void position_scrollbar(SCROLLBAR sb, int pos);
int position_scrollbar_by_key(SCROLLBAR sb, int key, unsigned mask);

/* Tables. */

typedef enum {
  tENABLED,
  tHAVE_FOCUS,
} TABLE_STATUS;

typedef struct table {
  WINDOW_REC window;
  HOT_TEXT_REC title;           /* name over table */
  char **entries;               /* entries in table */
  int n_entries,                /* number of entries in table */
      entry_len,                /* char width of an entry */
      wrap,                     /* number of entries where wrap occurs */
      n_vis_rows,               /* number entries visible on vertical */
      n_vis_cols;               /* number entries visible on horizontal */
  unsigned status;
  KEY_NAME_ACTION key_actions;
  int n_key_actions;
  int row, col,                 /* top, left visible corner */
      pos,                      /* current position, -1 if none */
      ch_width, ch_height;      /* pixel dimensions of chars */
  SCROLLBAR hor_scrollbar,
	    ver_scrollbar;
} TABLE_REC, *TABLE;

#define t_status_p(T, S)        ((T)->status & bit(S))
#define NO_WRAP 32767

void locate_table_cursor(int pos, TABLE tbl);
void set_table_entries(TABLE tbl, char **entries, int n_entries);
void open_table(TABLE tbl, int x, int y, WINDOW parent);
void enable_table(TABLE tbl);
void disable_table(TABLE tbl);
char *selected_table_entry(TABLE tbl);

/* Graphic cursors. */

typedef enum {
  cHAIRS,       /* cross-hairs */
  cRECT,        /* constant size rectangle */
  cBOX,         /* box with one fixed corner */
  cLINE,        /* line with one fixed end point */
  cVECTOR,      /* vector "   "    "    "    "   */
  cCIRCLE_RAD,  /* circle with center fixed */
  cCIRCLE_DIAM, /* circle with one end of diameter fixed */
  cOVAL,        /* full oval */
  cOVAL2H,      /* C-shaped half-oval */
  cOVAL2V,      /* U-shaped half-oval */
  cOVAL4H,      /* L-shaped quarter-oval */
  cOVAL4V,      /* _|-shaped quarter-oval */
  cMOUSE,       /* mouse cursor */
  cVARIANT,     /* symmetric variant of non-symmetric cursor */
  cIN           /* set iff mouse is inside cursor window */
} CURSOR_STATUS;

#define OVAL_CURSORS \
  (bit(cOVAL)|\
   bit(cOVAL2H)|\
   bit(cOVAL2V)|\
   bit(cOVAL4H)|\
   bit(cOVAL4V))

#define RECTILIN_CURSORS \
  (bit(cBOX)|\
   bit(cLINE)|\
   bit(cVECTOR)|\
   OVAL_CURSORS)

#define CIRCLE_CURSORS \
  (bit(cCIRCLE_RAD)|\
   bit(cCIRCLE_DIAM))


#define TWO_PT_CURSORS    (RECTILIN_CURSORS|CIRCLE_CURSORS)
#define GRAPHIC_CURSORS   (TWO_PT_CURSORS|bit(cHAIRS))
#define EDIT_INFO_CURSORS (bit(cVARIANT)|RECTILIN_CURSORS|bit(cCIRCLE_RAD))


typedef struct cursor *CURSOR;
typedef void (*CURSOR_CONSTRAINT)(CURSOR);
typedef struct cursor {
  WINDOW_REC window;
  unsigned status;
  int color, level,
      x, y, x0, y0, width, height, oval_rad;
  HANDLER_CODE press, release;
  CURSOR_CONSTRAINT constraint;
  ENV constraint_env;
  unsigned oval_mask;
} CURSOR_REC;


#define c_status_p(C, S) (((CURSOR)C)->status & bit(S))

void set_cursor(CURSOR c, unsigned mask, ...);
#ifdef va_start
void vset_cursor(CURSOR c, unsigned mask, va_list ap);
#endif
void set_cursor_constraint(CURSOR c, CURSOR_CONSTRAINT fun, ENV env);
ENV unset_cursor_constraint(CURSOR c);
void set_cursor_color(CURSOR c, int color);
unsigned get_cursor(CURSOR c, int *x_rtn, int *y_rtn, ...);
#define get_cursor_mask(C)      ((C)->status)
void open_cursor(CURSOR c, int x, int y, int width, int height, int color, WINDOW parent);
void show_cursor(CURSOR c, int p);
#define set_cursor_handlers(C, Press, Release) \
  { (C)->press = (Press); (C)->release = (Release); }

/* Radios. */

typedef enum {
  rENABLED,
  rHAVE_FOCUS,
} RADIO_STATUS;

typedef struct {
  WINDOW_REC window;
  HOT_TEXT_REC text;
  int pos;
} RADIO_ENTRY_REC, *RADIO_ENTRY;

typedef struct {
  WINDOW_REC window;
  char *title;
  RADIO_ENTRY entries;
  int n_entries;
  int pos;
  unsigned status;
  POSITION_ACTION_CLOSURE_REC action;
} RADIO_REC, *RADIO;

#define r_status_p(R, S)        ((R)->status & bit(S))
void open_radio(RADIO r, int x, int y, WINDOW parent);
void set_radio_pos(RADIO r, int pos);
#define radio_pos(R)    ((R)->pos)

/* Checks. */
typedef enum {
  ckENABLED,
  ckHAVE_FOCUS,
} CHECKS_STATUS;

typedef struct {
  WINDOW_REC window;
  HOT_TEXT_REC text;
  int pos;
} CHECKS_ENTRY_REC, *CHECKS_ENTRY;

typedef struct {
  WINDOW_REC window;
  char *title;
  CHECKS_ENTRY entries;
  int n_entries;
  unsigned long on;
  unsigned status;
  POSITION_ACTION_CLOSURE_REC action;
  int focus;
} CHECKS_REC, *CHECKS;

#define ck_status_p(C, S)       ((C)->status & bit(S))
#define checked_p(C, N)         ((C)->on & bit(N))
#define check_rtn_pos(I)        ((I) & 0x7fff)
#define check_rtn_set(I)        ((I) & 0x8000)
#define checks_on_mask(C)       ((C)->on)
void set_checks_on_mask(CHECKS ck, unsigned long on);
void open_checks(CHECKS cd, int x, int y, WINDOW parent);

/* Header panels. */

typedef struct {
  WINDOW_REC window;
  char **title;
} HEADER_REC, *HEADER;

HEADER make_header_bar(char **title, WINDOW parent);
int header_bar_height(void);

/* Dialog panels. */

typedef enum {
  diBUTTON,
  diCHECKS,
  diEDIT_BOX,
  diRADIO,
  diSCROLLBAR,
  diSELECTOR,
  diTABLE,
  diTEXT,
  diN
} DIALOG_ITEM_TYPE;

typedef enum {
  diENABLED,
} DIALOG_ITEM_STATUS;

typedef struct {
  char type; 
  WINDOW item;
  int x, y;
  unsigned char status;
} DIALOG_ITEM_REC, *DIALOG_ITEM;

#define di_status_p(D, S)       ((D)->status & bit(S))

typedef enum {
  dENABLED,
  dMODAL
} DIALOG_STATUS;

typedef struct {
  WINDOW_REC window;
  char *title;
  DIALOG_ITEM items;
  int n_items;
  unsigned status;
} DIALOG_REC, *DIALOG;

#define d_status_p(D, S)        ((D)->status & bit(S))
#define dialog_item(D,N,T)      ((T)(D)->items[N].item)

void open_dialog(DIALOG dd, int x, int y, WINDOW parent);
int run_modal_dialog(DIALOG d);
void stop_modal_dialog(DIALOG d, int rtn);
void surrender_focus_action(char *unused, ENV env);
extern int bool_val[];
#define val_zero        (&bool_val[0])
#define val_one         (&bool_val[1])

/* Standard bitmaps. */

#define EXTERN_BITMAP_DECL
#include "bitmap\ok.c"
#include "bitmap\yes.c"
#include "bitmap\no.c"
#include "bitmap\cancel.c"
#include "bitmap\larrow.c"
#include "bitmap\rarrow.c"
#include "bitmap\uarrow.c"
#include "bitmap\darrow.c"
#include "bitmap\slider.c"
#include "bitmap\color.c"
#undef EXTERN_BITMAP_DECL

/* File dialog. */

int get_path(char *title, char *path, char *ext);
char *change_suffix(const char *path, char *sfx, char *result);

#ifdef TRACE
#include <conio.h>
#define DEBUG_TRACE(S) printf("debug trace: %s. Type <space>.\n", #S); getch()
#else
#define DEBUG_TRACE(S) 
#endif

