# frozen_string_literal: true

class AddIndexToVulnerabilityFindingsOnUuidAgain < Gitlab::Database::Migration[2.1]
  INDEX_NAME = 'index_vuln_findings_on_uuid_including_vuln_id'

  def up
    Gitlab::Database::AsyncIndexes::PostgresAsyncIndex.where(name: INDEX_NAME).find_each do |record|
      record.definition = record.definition.strip
      record.save!
    end
  end

  def down
    # no-op
  end
end
