# frozen_string_literal: true

class CreateIndexVulnerabilityFindingsOnUuidSync < Gitlab::Database::Migration[2.1]
  INDEX_NAME = 'index_vuln_findings_on_uuid_including_vuln_id'

  disable_ddl_transaction!

  def up
    return if index_exists_by_name?(:vulnerability_occurrences, INDEX_NAME)

    disable_statement_timeout do
      execute <<~SQL
        CREATE UNIQUE INDEX CONCURRENTLY #{INDEX_NAME} ON vulnerability_occurrences (uuid) include (vulnerability_id);
      SQL
    end
  end

  def down
    remove_concurrent_index_by_name(:vulnerability_occurrences, INDEX_NAME)
  end
end
