# frozen_string_literal: true

class AddIndexOwaspTop10WithProjectIdOnVulnerabilityReads < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!

  milestone '16.8'

  INDEX_NAME = 'index_vuln_reads_on_project_id_owasp_top_10'

  def up
    add_concurrent_index :vulnerability_reads, [:project_id, :owasp_top_10], name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME
  end
end
