# frozen_string_literal: true

class BackfillVulnerabilityOccurrencePipelinesPipelineIdBigint < Gitlab::Database::Migration[2.2]
  restrict_gitlab_migration gitlab_schema: :gitlab_main
  milestone '16.11'

  TABLE = :vulnerability_occurrence_pipelines
  COLUMN = :pipeline_id
  SUB_BATCH_SIZE = 500
  BATCH_SIZE = 200_000
  PAUSE_MS = 0

  def up
    backfill_conversion_of_integer_to_bigint(
      TABLE, COLUMN,
      sub_batch_size: SUB_BATCH_SIZE, batch_size: BATCH_SIZE, pause_ms: PAUSE_MS
    )
  end

  def down
    revert_backfill_conversion_of_integer_to_bigint(TABLE, COLUMN)
  end
end
