---
stage: Secure
group: Composition Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# License scanning of CycloneDX files

DETAILS:
**Tier:** Ultimate
**Offering:** GitLab.com, Self-managed, GitLab Dedicated

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/384932) in GitLab 15.9 for GitLab SaaS [with two flags](../../../administration/feature_flags.md) named `license_scanning_sbom_scanner` and `package_metadata_synchronization`. Both flags disabled by default.
> - [Generally available](https://gitlab.com/gitlab-org/gitlab/-/issues/385176) in GitLab 16.4. Feature flags `license_scanning_sbom_scanner` and `package_metadata_synchronization` removed.

NOTE:
The legacy License Compliance analyzer was deprecated in GitLab 15.9 and removed in GitLab 16.3.
To continue using GitLab for License Compliance, remove the License Compliance template from your
CI/CD pipeline and add the [Dependency Scanning template](../../application_security/dependency_scanning/index.md#configuration).
The Dependency Scanning template is now capable of gathering the required license information so it
is no longer necessary to run a separate License Compliance job. The License Compliance CI/CD
template should not be removed prior to verifying that the instance has been upgraded to a version
that supports the new method of license scanning. To begin using the Dependency Scanner quickly at
scale, you may set up a [scan execution policy](../../application_security/policies/scan-execution-policies.md)
at the group level to enforce the SBOM-based license scan for all projects in the group.
Then, you may remove the inclusion of the `Jobs/License-Scanning.gitlab-ci.yml` template from your
CI/CD configuration. If you wish to continue using the legacy License Compliance feature, you can do
so by setting the `LICENSE_MANAGEMENT_VERSION CI` variable to `4`. This variable can be set at the
[project](../../../ci/variables/index.md#for-a-project), [group](../../../ci/variables/index.md#for-a-group)
or [instance](../../../ci/variables/index.md#for-an-instance) level.

To detect the licenses in use, License Compliance relies on running the
[Dependency Scanning CI Jobs](../../application_security/dependency_scanning/index.md),
and analyzing the [CycloneDX](https://cyclonedx.org/) Software Bill of Materials (SBOM) generated by those jobs.
This method of scanning is capable of parsing and identifying over 500 different types of licenses, as defined in [the SPDX list](https://spdx.org/licenses/).
Third-party scanners may be used to generate the list of dependencies, as long as they produce a CycloneDX report artifact for [one of our supported languages](#supported-languages-and-package-managers) and follow the [GitLab CycloneDX property taxonomy](../../../development/sec/cyclonedx_property_taxonomy.md). Note that it is not yet possible to use a CI report artifact as a source of data for license information, and licenses that are not in the SPDX list are reported as "Unknown".
The ability to provide other licenses is tracked in [epic 10861](https://gitlab.com/groups/gitlab-org/-/epics/10861).

NOTE:
The License Scanning feature relies on publicly available package metadata collected in an
external database and synced with the GitLab instance automatically. This database is a multi-region Google Cloud Storage bucket hosted in the United States.
The scan is executed exclusively within the GitLab instance.
No contextual information (for example, a list of project dependencies) is sent to the external service.

## Configuration

To enable License scanning of CycloneDX files:

- Enable [Dependency Scanning](../../application_security/dependency_scanning/index.md#enabling-the-analyzer)
  and ensure that its prerequisites are met.
- On GitLab self-managed only, you can [choose package registry metadata to synchronize](../../../administration/settings/security_and_compliance.md#choose-package-registry-metadata-to-sync) in the Admin Area for the GitLab instance. For this data synchronization to work, you must allow outbound network traffic from your GitLab instance to the domain `storage.googleapis.com`. If you have limited or no network connectivity then refer to the documentation section [running in an offline environment](#running-in-an-offline-environment) for further guidance.

## Supported languages and package managers

License scanning is supported for the following languages and package managers:

<!-- markdownlint-disable MD044 -->
<table class="supported-languages">
  <thead>
    <tr>
      <th>Language</th>
      <th>Package Manager</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>.NET</td>
      <td rowspan="2"><a href="https://www.nuget.org/">NuGet</a></td>
    </tr>
    <tr>
      <td>C#</td>
    </tr>
    <tr>
      <td>C</td>
      <td rowspan="2"><a href="https://conan.io/">Conan</a></td>
    </tr>
    <tr>
      <td>C++</td>
    </tr>
    <tr>
      <td>Go</td>
      <td><a href="https://go.dev/">Go</a></td>
    </tr>
    <tr>
      <td rowspan="2">Java</td>
      <td><a href="https://gradle.org/">Gradle</a></td>
    </tr>
    <tr>
      <td><a href="https://maven.apache.org/">Maven</a></td>
    </tr>
    <tr>
      <td rowspan="3">JavaScript and TypeScript</td>
      <td><a href="https://www.npmjs.com/">npm</a></td>
    </tr>
    <tr>
      <td><a href="https://pnpm.io/">pnpm</a></td>
    </tr>
    <tr>
      <td><a href="https://classic.yarnpkg.com/en/">yarn</a></td>
    </tr>
    <tr>
      <td>PHP</td>
      <td><a href="https://getcomposer.org/">Composer</a></td>
    </tr>
    <tr>
      <td rowspan="4">Python</td>
      <td><a href="https://setuptools.readthedocs.io/en/latest/">setuptools</a></td>
    </tr>
    <tr>
      <td><a href="https://pip.pypa.io/en/stable/">pip</a></td>
    </tr>
    <tr>
      <td><a href="https://pipenv.pypa.io/en/latest/">Pipenv</a></td>
    </tr>
    <tr>
      <td><a href="https://python-poetry.org/">Poetry</a></td>
    </tr>
    <tr>
      <td>Ruby</td>
      <td><a href="https://bundler.io/">Bundler</a></td>
    </tr>
    <tr>
      <td>Scala</td>
      <td><a href="https://www.scala-sbt.org/">sbt</a></td>
    </tr>
  </tbody>
</table>
<!-- markdownlint-disable MD044 -->

The supported files and versions are the ones supported by
[Dependency Scanning](../../application_security/dependency_scanning/index.md#supported-languages-and-package-managers).

## License expressions

The License Scanning of CycloneDX files does not support [composite licenses](https://spdx.github.io/spdx-spec/v2-draft/SPDX-license-expressions/).
Adding this capability is tracked in issue [336878](https://gitlab.com/gitlab-org/gitlab/-/issues/336878).

## Blocking merge requests based on detected licenses

Users can require approval for merge requests based on the licenses that are detected by configuring a [license approval policy](../license_approval_policies.md).

## Running in an offline environment

For self-managed GitLab instances in an environment with limited, restricted, or intermittent access to external resources through the internet, some adjustments are required to successfully scan
CycloneDX reports for licenses. For more information, see the offline [quick start guide](../../../topics/offline/quick_start_guide.md#enabling-the-package-metadata-database).

## Troubleshooting

### A CycloneDX file is not being scanned and appears to provide no results

Ensure that the CycloneDX file adheres to the [CycloneDX JSON specification](https://cyclonedx.org/docs/latest/json). This specification does [not permit duplicate entries](https://cyclonedx.org/docs/latest/json/#components). Projects that contain multiple SBOM files should either report each SBOM file up as individual CI report artifacts or they should ensure that duplicates are removed if the SBOMs are merged as part of the CI pipeline.

You can validate CycloneDX SBOM files against the `CycloneDX JSON specification` as follows:

```shell
$ docker run -it --rm -v "$PWD:/my-cyclonedx-sboms" -w /my-cyclonedx-sboms cyclonedx/cyclonedx-cli:latest cyclonedx validate --input-version v1_4 --input-file gl-sbom-all.cdx.json

Validating JSON BOM...
BOM validated successfully.
```

If the JSON BOM fails validation, for example, because there are duplicate components:

```shell
Validation failed: Found duplicates at the following index pairs: "(A, B), (C, D)"
#/properties/components/uniqueItems
```

This issue can be fixed by updating the CI template to use [jq](https://jqlang.github.io/jq/) to remove the duplicate components from the `gl-sbom-*.cdx.json` report by overriding the job definition that produces the duplicate components. For example, the following removes duplicate components from the `gl-sbom-gem-bundler.cdx.json` report file produced by the `gemnasium-dependency_scanning` job:

```yaml
include:
  - template: Jobs/Dependency-Scanning.gitlab-ci.yml

gemnasium-dependency_scanning:
  after_script:
    - apk update && apk add jq
    - jq '.components |= unique' gl-sbom-gem-bundler.cdx.json > tmp.json && mv tmp.json gl-sbom-gem-bundler.cdx.json
```

### Remove unused license data

License scanning changes (released in GitLab 15.9) required a significant amount of additional disk space to be available on the instances. This issue was resolved in GitLab 16.3 by the [Reduce package metadata table on-disk footprint](https://gitlab.com/groups/gitlab-org/-/epics/10415) epic. But if your instance was running license scanning between GitLab 15.9 and 16.3, you may want to remove the unneeded data.

To remove the unneeded data:

1. Check if the [package_metadata_synchronization](https://about.gitlab.com/releases/2023/02/22/gitlab-15-9-released/#new-license-compliance-scanner) feature flag is currently, or was previously enabled, and if so, disable it. Use [Rails console](../../../administration/operations/rails_console.md) to execute the following commands.

   ```ruby
   Feature.enabled?(:package_metadata_synchronization) && Feature.disable(:package_metadata_synchronization)
   ```

1. Check if there is deprecated data in the database:

   ```ruby
   PackageMetadata::PackageVersionLicense.count
   PackageMetadata::PackageVersion.count
   ```

1. If there is deprecated data in the database, remove it by running the following commands in order:

   ```ruby
   ActiveRecord::Base.connection.execute('SET statement_timeout TO 0')
   PackageMetadata::PackageVersionLicense.delete_all
   PackageMetadata::PackageVersion.delete_all
   ```
