---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Manage group's SSH certificates

DETAILS:
**Tier:** Premium, Ultimate
**Offering:** GitLab.com

Manage Git access to the projects by sharing public Certified Authority (`CA`) files in your organization's top-level group.

Git access control options on GitLab SaaS (SSH, HTTPS) rely on credentials (such as access tokens and SSH keys)
setup in the user profile and are out of control of the organization.
To temporarily grant Git access to your projects, you can use SSH certificates.

## Add a CA certificate to a top-level group

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/421915) in GitLab 16.4 [with a flag](../feature_flags.md) named `ssh_certificates_rest_endpoints`. Disabled by default.
> - [Enabled on GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/issues/424501) in GitLab 16.9.

FLAG:
On GitLab.com, this feature is available. On GitLab Dedicated, this feature is not available.

Prerequisites:

- You must have the Owner role for the group.
- The group must be a top-level group, not a subgroup.

To add a CA certificate to a group:

1. Generate an SSH key pair to be used as a Certified Authority file:

   ```plaintext
   ssh-keygen -f CA
   ```

1. Add the public key to the top-level group using [Group SSH certificates API](../../api/group_ssh_certificates.md#create-ssh-certificate)
   to grant access to the projects of the group and its subgroups.

## Issue CA certificates for users

Prerequisites:

- You must have the Owner role for the group.
- The user certificates can only be used to access the projects within the top-level group and its subgroups.
- A user's username or primary email (`user` or `user@example.com`) must be specified to associate a
  GitLab user with the user certificate.
- The user must be an [Enterprise User](../enterprise_user/index.md).

To issue user certificates, use the private key from the pair you [created earlier](#add-a-ca-certificate-to-a-top-level-group):

```shell
ssh-keygen -s CA -I user@example.com -V +1d user-key.pub
```

The (`user-key.pub`) key is the public key from an SSH key pair that is used by a user for SSH authentication.
The SSH key pair is either generated by a user or provisioned by the group owner infrastructure along with the SSH certificate.

The expiration date (`+1d`) identifies how long the SSH certificate can be used to access the group projects.

The user certificates can only be used to access the projects within the top-level group.

## Enforce SSH certificates

> - [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/421915) in GitLab 16.7 [with a flag](../feature_flags.md) named `enforce_ssh_certificates_via_settings`. Disabled by default.
> - [Enabled on GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/issues/426235) in GitLab 16.9.

FLAG:
On GitLab.com, this feature is available. On GitLab Dedicated, this feature is not available.

You can enforce usage of SSH certificates and forbid users from authenticating using SSH
keys and access tokens.

When SSH certificates are enforced, only individual user accounts are affected.
It does not apply to service accounts, deploy keys, and other types of internal accounts.

Prerequisites:

- You must have the Owner role for the group.

To enforce using SSH certificates:

1. On the left sidebar, select **Search or go to** and find your group.
1. Select **Settings > General**.
1. Expand the **Permissions and group features** section.
1. Select the **Enforce SSH Certificates** checkbox.
1. Select **Save changes**.
