<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_authz_dbd - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_authz_dbd</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authz_dbd.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authz_dbd.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Autorisation en groupe et reconnaissance d'identit avec base
SQL</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>authz_dbd_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_authz_dbd.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible dans les versions 2.4 et suprieures
d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module fournit des fonctionnalits d'autorisation permettant
    d'accorder ou de refuser aux utilisateurs authentifis l'accs 
    certaines zones du site web en fonction de leur appartenance  tel
    ou tel groupe. Les modules <code class="module"><a href="../mod/mod_authz_groupfile.html">mod_authz_groupfile</a></code> et
    <code class="module"><a href="../mod/mod_authz_dbm.html">mod_authz_dbm</a></code> fournissent une fonctionnalit
    similaire, mais ici le module interroge une base de donnes SQL pour
    dterminer si un utilisateur appartient ou non  tel ou tel groupe.</p>
    <p>Ce module propose galement des fonctionnalits de connexion
    utilisateur s'appuyant sur une base de donnes, ce qui peut se rvler
    particulirement utile lorsque le module est utilis conjointement avec
    <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code>.</p>
    <p>Ce module s'appuie sur <code class="module"><a href="../mod/mod_dbd.html">mod_dbd</a></code> pour spcifier le
    pilote de la base de donnes sous-jacente et les paramtres de
    connexion, et grer les connexions  la base de donnes.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#authzdbdlogintoreferer">AuthzDBDLoginToReferer</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authzdbdquery">AuthzDBDQuery</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authzdbdredirectquery">AuthzDBDRedirectQuery</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#requiredirectives">Les directives Require</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#login">Reconnaissance d'identit s'appuyant sur une base de donnes</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#client">Reconnaissance d'identit ct client</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#example">Exemple de configuration</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code></li>
<li>
  <code class="directive"><a href="../mod/mod_authn_dbd.html#authdbduserpwquery">AuthDBDUserPWQuery</a></code>
</li>
<li><code class="directive"><a href="../mod/mod_dbd.html#dbdriver">DBDriver</a></code></li>
<li><code class="directive"><a href="../mod/mod_dbd.html#dbdparams">DBDParams</a></code></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="requiredirectives" id="requiredirectives">Les directives Require</a></h2>

    <p>Les directives <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> d'Apache permettent,
    au cours de la phase d'autorisation, de s'assurer qu'un utilisateur
    est bien autoris  accder  une ressource. mod_authz_dbd ajoute
    les types d'autorisation <code>dbd-group</code>,
    <code>dbd-login</code> et <code>dbd-logout</code>.</p>

    <p>A partir de la version 2.5.0, les directives require DBD
    supportent les <a href="../expr.html">expressions</a>.</p>

<h3><a name="reqgroup" id="reqgroup">Require dbd-group</a></h3>

    <p>Cette directive permet de spcifier  quel groupe un utilisateur
    doit appartenir pour obtenir l'autorisation d'accs.</p>

    <pre class="prettyprint lang-config">      Require dbd-group team
      AuthzDBDQuery "SELECT group FROM authz WHERE user = %s"</pre>




<h3><a name="reqlogin" id="reqlogin">Require dbd-login</a></h3>

    <p>Cette directive permet de spcifier une requte  excuter pour
    indiquer que l'utilisateur s'est authentifi.</p>

    <pre class="prettyprint lang-config">      Require dbd-login
      AuthzDBDQuery "UPDATE authn SET login = 'true' WHERE user = %s"</pre>




<h3><a name="reqlogout" id="reqlogout">Require dbd-logout</a></h3>

    <p>Cette directive permet de spcifier une requte  excuter pour
    indiquer que l'utilisateur s'est dconnect.</p>

    <pre class="prettyprint lang-config">      Require dbd-logout
      AuthzDBDQuery "UPDATE authn SET login = 'false' WHERE user = %s"</pre>




</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="login" id="login">Reconnaissance d'identit s'appuyant sur une base de donnes</a></h2>

<p>
Outre sa fonction d'autorisation standard consistant  vrifier
l'appartenance  des groupes, ce module permet aussi de grer des
sessions utilisateur ct serveur grce  sa fonctionnalit de connexion utilisateur
en s'appuyant sur une base de donnes. En particulier, il peut mettre 
jour le statut de session de l'utilisateur dans la base de donnes
chaque fois que celui-ci visite certaines URLs (sous rserve bien
entendu que l'utilisateur fournissent les informations de connexion
ncessaires).</p>
<p>Pour cela, il faut definir deux directives <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> spciales : <code>Require
dbd-login</code> et <code>Require dbd-logout</code>. Pour les dtails de
leur utilisation, voir l'exemple de configuration ci-dessous.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="client" id="client">Reconnaissance d'identit ct client</a></h2>

<p>Certains administrateurs peuvent vouloir implmenter une gestion de
session ct client fonctionnant de concert avec les fonctionnalits de
connexion/dconnexion des utilisateurs ct serveur offertes par ce module, en
dfinissant ou en annulant par exemple un cookie HTTP ou un jeton
similaire lorsqu'un utilisateur se connecte ou se dconnecte. Pour
supporter une telle intgration, <code class="module"><a href="../mod/mod_authz_dbd.html">mod_authz_dbd</a></code> exporte
un programme  dclenchement optionnel (hook) qui sera lanc chaque fois
que le statut d'un utilisateur sera mis  jour dans la base de donnes.
D'autres modules de gestion de session pourront alors utiliser ce
programme pour implmenter des fonctions permettant d'ouvrir et de
fermer des sessions ct client.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="example" id="example">Exemple de configuration</a></h2>

<pre class="prettyprint lang-config"># configuration de mod_dbd
DBDriver pgsql
DBDParams "dbname=apacheauth user=apache pass=xxxxxx"

DBDMin  4
DBDKeep 8
DBDMax  20
DBDExptime 300

&lt;Directory /usr/www/mon.site/team-private/&gt;
  # configuration de mod_authn_core et mod_auth_basic
  # pour mod_authn_dbd
  AuthType Basic
  AuthName Team
  AuthBasicProvider dbd

  # requte SQL de mod_authn_dbd pour authentifier un utilisateur qui se
  # connecte
  AuthDBDUserPWQuery \
    "SELECT password FROM authn WHERE user = %s AND login = 'true'"

  # configuration de mod_authz_core pour mod_authz_dbd
  Require dbd-group team

  # configuration de mod_authz_dbd
  AuthzDBDQuery "SELECT group FROM authz WHERE user = %s"

  # lorsqu'un utilisateur choue dans sa tentative d'authentification ou
  # d'autorisation, on l'invite  se connecter ; cette page doit
  # contenir un lien vers /team-private/login.html
  ErrorDocument 401 /login-info.html

  &lt;Files login.html&gt;
    # il n'est pas ncessaire que l'utilisateur soit dj connect !
    AuthDBDUserPWQuery "SELECT password FROM authn WHERE user = %s"

    # le processus de connexion dbd excute une requte pour enregistrer
    # la connexion de l'utilisateur
    Require dbd-login
    AuthzDBDQuery "UPDATE authn SET login = 'true' WHERE user = %s"

    # redirige l'utilisateur vers la page d'origine (si elle existe)
    # aprs une connexion russie
    AuthzDBDLoginToReferer On
  &lt;/Files&gt;

  &lt;Files logout.html&gt;
    # le processus de dconnexion dbd excute une requte pour
    # enregistrer la dconnexion de l'utilisateur
    Require dbd-logout
    AuthzDBDQuery "UPDATE authn SET login = 'false' WHERE user = %s"
  &lt;/Files&gt;
&lt;/Directory&gt;</pre>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthzDBDLoginToReferer" id="AuthzDBDLoginToReferer">AuthzDBDLoginToReferer</a> <a name="authzdbdlogintoreferer" id="authzdbdlogintoreferer">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit si le client doit tre redirig vers la page
d'origine en cas de connexion ou de dconnexion russie si un en-tte
de requte <code>Referer</code> est prsent</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthzDBDLoginToReferer On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthzDBDLoginToReferer Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authz_dbd</td></tr>
</table>
    <p>Utilise en conjonction avec <code>Require dbd-login</code> ou
    <code>Require dbd-logout</code>, cette directive permet de rediriger
    le client vers la page d'origine (l'URL contenue dans l'en-tte
    de requte HTTP <code>Referer</code>, s'il est prsent). En
    l'absence d'en-tte <code>Referer</code>, la dfinition
    <code>AuthzDBDLoginToReferer On</code> sera ignore.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthzDBDQuery" id="AuthzDBDQuery">AuthzDBDQuery</a> <a name="authzdbdquery" id="authzdbdquery">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la requte SQL pour l'opration requise</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthzDBDQuery <var>requte</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authz_dbd</td></tr>
</table>
    <p>La directive <code class="directive">AuthzDBDQuery</code> permet de
    spcifier une requte SQL  excuter. Le but de cette requte dpend
    de la directive <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> en cours de
    traitement.</p>
    <ul>
    <li>Avec la directive <code>Require dbd-group</code>, elle spcifie
    une requte permettant de rechercher les groupes d'appartenance de
    l'utilisateur courant. Ceci correspond  la fonctionnalit standard
    d'autres modules d'autorisation comme
    <code class="module"><a href="../mod/mod_authz_groupfile.html">mod_authz_groupfile</a></code> et
    <code class="module"><a href="../mod/mod_authz_dbm.html">mod_authz_dbm</a></code>.
    La premire colonne de chaque enregistrement renvoy par la requte
    doit contenir une chane de caractres correspondant  un nom de
    groupe. La requte peut renvoyer zro, un ou plusieurs
    enregistrements.
    <pre class="prettyprint lang-config">Require dbd-group
AuthzDBDQuery "SELECT group FROM groups WHERE user = %s"</pre>

    </li>
    <li>Avec la directive <code>Require dbd-login</code> ou
    <code>Require dbd-logout</code>, elle ne refusera jamais l'accs,
    mais au contraire excutera une requte SQL permettant d'enregistrer
    la connexion ou la dconnexion de l'utilisateur. Ce dernier doit
    tre dj authentifi avec <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code>.
    <pre class="prettyprint lang-config">Require dbd-login
AuthzDBDQuery "UPDATE authn SET login = 'true' WHERE user = %s"</pre>

    </li>
    </ul>
    <p>Dans tous les cas, l'identifiant utilisateur sera transmis comme
    paramtre sous la forme d'une simple chane lorsque la requte SQL
    sera excute. Il y sera fait rfrence dans la requte en utilisant
    le spcificateur de format <code>%s</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthzDBDRedirectQuery" id="AuthzDBDRedirectQuery">AuthzDBDRedirectQuery</a> <a name="authzdbdredirectquery" id="authzdbdredirectquery">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit une requte pour rechercher une page vers laquelle
rediriger l'utilisateur aprs une connexion russie</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthzDBDRedirectQuery <var>requte</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authz_dbd</td></tr>
</table>
    <p>Spcifie une requte SQL optionnelle  utiliser aprs une
    connexion (ou une dconnexion) russie pour rediriger l'utilisateur
    vers une URL, qui peut tre spcifique  l'utilisateur.
    L'identifiant utilisateur sera transmis comme paramtre sous la
    forme d'une simple chane lorsque la requte SQL sera excute. Il y
    sera fait rfrence dans la requte en utilisant le spcificateur de
    format <code>%s</code>.</p>
    <pre class="prettyprint lang-config">AuthzDBDRedirectQuery "SELECT userpage FROM userpages WHERE user = %s"</pre>

    <p>La premire colonne du premier enregistrement renvoy par la
    requte doit contenir une chane de caractres correspondant  une
    URL vers laquelle rediriger le client. Les enregistrements suivants
    sont ignors. Si aucun enregistrement n'est renvoy, le client ne
    sera pas redirig.</p>
    <p>Notez que <code class="directive">AuthzDBDLoginToReferer</code> l'emporte
    sur cette directive si les deux sont dfinies.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authz_dbd.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authz_dbd.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_authz_dbd.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2014 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>