/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.DomainViewpoint;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.Viewpoint;
import org.eclipse.egf.model.types.Type;
import org.eclipse.egf.model.types.TypeString;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.polarsys.kitalpha.doc.gen.business.core.scope.GenerationGlobalScope;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeException;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeReferencesStrategy;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;
import org.polarsys.kitalpha.doc.gen.business.core.ui.helper.InvokeActivityHelper;
import org.polarsys.kitalpha.doc.gen.business.core.ui.wizards.HTMLDocumentationBrandingWizardPage;
import org.polarsys.kitalpha.doc.gen.business.core.ui.wizards.HTMLDocumentationGenerationWizardPage;
import org.polarsys.kitalpha.doc.gen.business.core.util.LabelProviderHelper;

public abstract class HTMLDocumentationGenerationWizard
extends Wizard
implements INewWizard {
    private HTMLDocumentationGenerationWizardPage page;
    private HTMLDocumentationBrandingWizardPage brandingPage;
    private ISelection selection;
    public static final String DEFAULT_LAUNCHER_LABEL = "Default Launcher";
    protected List<EObject> selectedModelElements = new ArrayList<EObject>();
    private boolean scopedGeneration = false;

    protected abstract Map<String, URI> getLaunchersURI();

    public HTMLDocumentationGenerationWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public HTMLDocumentationGenerationWizard(IStructuredSelection structuredSelection) {
        this.setNeedsProgressMonitor(true);
        this.selection = this.handleSelection((ISelection)structuredSelection);
    }

    public void addPages() {
        this.page = new HTMLDocumentationGenerationWizardPage(this.selection);
        this.page.setLauncherUris(this.getLaunchersURI());
        this.page.setScopedGeneration(this.scopedGeneration);
        this.addPage((IWizardPage)this.page);
        this.brandingPage = new HTMLDocumentationBrandingWizardPage();
        this.addPage((IWizardPage)this.brandingPage);
    }

    protected final ISelection handleSelection(ISelection selection_p) {
        TreeSelection treeSelection;
        Object firstSelection;
        if (selection_p instanceof TreeSelection && !((firstSelection = (treeSelection = (TreeSelection)selection_p).getFirstElement()) instanceof IFile)) {
            Object[] array;
            Object[] objectArray = array = treeSelection.toArray();
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (!(object instanceof EObject)) {
                    throw new IllegalArgumentException("Documetation generation bad input :" + object.toString());
                }
                this.selectedModelElements.add((EObject)object);
                ++n2;
            }
            this.scopedGeneration = true;
            TreePath treePath = new TreePath(new Object[]{treeSelection.getPaths()[0].getSegment(0), treeSelection.getPaths()[0].getSegment(1)});
            selection_p = new TreeSelection(treePath);
        }
        return selection_p;
    }

    private void initializeScope(ScopeReferencesStrategy referencesStrategy) {
        GenerationGlobalScope.getInstance().cleanScope();
        GenerationGlobalScope.getInstance().setReferencesStrategy(referencesStrategy);
        if (this.selectedModelElements != null && !this.selectedModelElements.isEmpty()) {
            for (EObject eObject : this.selectedModelElements) {
                try {
                    GenerationGlobalScope.getInstance().addToScope(eObject);
                }
                catch (ScopeException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean performFinish() {
        this.brandingPage.askUserForUpdatingBrandingDataPreferences();
        String modelURI = this.page.getModelURI();
        String containerName = this.page.getContainerName();
        String selectedLauncher = this.page.getSelectedLauncher();
        ScopeReferencesStrategy referencesStrategy = this.page.getReferencesStrategy();
        String copyright = this.brandingPage.getCopyright();
        String logoAlt = this.brandingPage.getLogoAlt();
        String logoPath = this.brandingPage.getLogoPath();
        this.initializeScope(referencesStrategy);
        LabelProviderHelper.initImageRegistry();
        List<URI> modelURIList = this.getURIList(modelURI);
        String projectName = this.getProjectName(containerName);
        String outputFolder = this.getOutputFolder(containerName);
        Activity melodyLauncher = InvokeActivityHelper.getActivity(this.getLaunchersURI().get(selectedLauncher));
        Iterator<URI> iterator = modelURIList.iterator();
        while (iterator.hasNext()) {
            URI uri;
            URI semanticResourceURI = uri = iterator.next();
            if (uri.lastSegment().endsWith(".aird")) {
                DiagramSessionHelper.setAirdUri((URI)uri);
                Session session = DiagramSessionHelper.initSession();
                Collection resources = session.getSemanticResources();
                if (!resources.isEmpty()) {
                    for (Resource next : resources) {
                        URI uri2 = next.getURI();
                        if (uri2.lastSegment().endsWith(".afm")) continue;
                        semanticResourceURI = uri2 == null ? semanticResourceURI : uri2;
                        break;
                    }
                }
            }
            this.execute(melodyLauncher, projectName, outputFolder, semanticResourceURI, copyright, logoAlt, logoPath);
        }
        return true;
    }

    private List<URI> getURIList(String modelURI) {
        HashSet<URI> uriSet = new HashSet<URI>();
        StringTokenizer tokenizer = new StringTokenizer(modelURI);
        while (tokenizer.hasMoreElements()) {
            String nextURI = tokenizer.nextElement().toString();
            uriSet.add(URI.createURI((String)nextURI));
        }
        return new ArrayList<URI>(uriSet);
    }

    private void execute(Activity melodyLauncher, String projectName, String outputFolder, URI uri, String copyright, String logoAlt, String logoPath) {
        Path path = new Path(String.valueOf(projectName) + "/" + outputFolder);
        path = path.append("output");
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                EGFPatternPlugin.getDefault().logError((Throwable)e);
            }
        }
        if (melodyLauncher instanceof FactoryComponent) {
            FactoryComponent factoryComponent = (FactoryComponent)melodyLauncher;
            this.setContract(factoryComponent, "projectName", projectName, true);
            this.setContract(factoryComponent, "outputFolder", String.valueOf(outputFolder) + "/output", true);
            this.setDomain(factoryComponent, uri);
            this.setContract(factoryComponent, "copyright", copyright, false);
            this.setContract(factoryComponent, "logo.alt", logoAlt, false);
            this.setContract(factoryComponent, "logo.path", logoPath, false);
            try {
                InvokeActivityHelper.invoke((Activity)factoryComponent);
            }
            catch (Exception e) {
                EGFPatternPlugin.getDefault().logError((Throwable)e);
            }
        }
    }

    private void setDomain(FactoryComponent factoryComponent, URI uri) {
        DomainViewpoint domainViewpoint;
        Domain domain;
        Viewpoint viewpoint = factoryComponent.getViewpointContainer().getViewpoint(DomainViewpoint.class);
        if (viewpoint instanceof DomainViewpoint && (domain = (Domain)(domainViewpoint = (DomainViewpoint)viewpoint).getDomains().get(0)) instanceof EMFDomain) {
            EMFDomain domainURI = (EMFDomain)domain;
            domainURI.setUri(uri);
        }
    }

    private void setContract(FactoryComponent factoryComponent, String contractName, String value, boolean mandatory) {
        Contract invokedContract = factoryComponent.getContract(contractName);
        if (invokedContract != null) {
            Type type = invokedContract.getType();
            if (type instanceof TypeString) {
                TypeString typeString = (TypeString)type;
                typeString.setValue(value);
            }
        } else if (mandatory) {
            throw new IllegalArgumentException("Can't find the mandatory contract " + contractName + " in the factory component " + factoryComponent.getName());
        }
    }

    private String getOutputFolder(String containerName) {
        String projectName = this.getProjectName(containerName);
        Path outputFolderPath = new Path(containerName);
        outputFolderPath = outputFolderPath.makeRelativeTo((IPath)new Path(projectName));
        return outputFolderPath.toString();
    }

    private String getProjectName(String containerName) {
        IFolder container = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(containerName));
        return container.getProject().getName();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

