/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.core.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.ArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.handlers.AnnotationException;
import org.eclipse.capra.core.handlers.IAnnotateArtifact;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class TraceHelper {
    private EObject traceModel;
    private TraceMetaModelAdapter traceAdapter = ExtensionPointHelper.getTraceMetamodelAdapter().get();
    private ArtifactMetaModelAdapter artifactAdapter = ExtensionPointHelper.getArtifactWrapperMetaModelAdapter().get();

    public TraceHelper(EObject traceModel) {
        this.traceModel = traceModel;
    }

    public EObject createTrace(List<EObject> wrappers, EClass traceType) {
        return this.traceAdapter.createTrace(traceType, this.traceModel, wrappers);
    }

    public void deleteTraces(List<Connection> toDelete) {
        this.traceAdapter.deleteTrace(toDelete, this.traceModel);
    }

    public void annotateTrace(List<EObject> wrappers) {
        for (EObject wrapper : wrappers) {
            IArtifactHandler<?> handler = this.artifactAdapter.getArtifactHandlerInstance(wrapper);
            if (!(handler instanceof IAnnotateArtifact)) continue;
            IAnnotateArtifact h = (IAnnotateArtifact)((Object)handler);
            try {
                HashSet connectedElements = new HashSet();
                StringBuilder annotation = new StringBuilder();
                List<Connection> connections = this.traceAdapter.getConnectedElements(wrapper, this.traceModel);
                connections.forEach(c -> c.getTargets().forEach(t -> {
                    if (t != wrapper) {
                        connectedElements.add(t);
                    }
                }));
                connectedElements.forEach(e -> {
                    if (annotation.length() > 0) {
                        annotation.append(", ");
                    }
                    String name = this.artifactAdapter.getArtifactName((EObject)e);
                    annotation.append(name);
                });
                h.annotateArtifact(wrapper, annotation.toString());
            }
            catch (AnnotationException annotationException) {
                // empty catch block
            }
        }
    }

    public List<EObject> getTracedElements(Connection connection) {
        ArrayList<EObject> tracedElements = new ArrayList<EObject>();
        tracedElements.add(connection.getOrigin());
        tracedElements.addAll(connection.getTargets());
        return tracedElements;
    }

    public boolean traceExists(List<EObject> selection, EClass traceType) {
        return !this.getTraces(selection, traceType).isEmpty();
    }

    public List<Connection> getTraces(List<EObject> selection, EClass traceType) {
        TraceMetaModelAdapter traceAdapter = ExtensionPointHelper.getTraceMetamodelAdapter().get();
        ArrayList<EObject> allElements = new ArrayList<EObject>(selection);
        EObject source = (EObject)allElements.get(0);
        allElements.remove(0);
        ArrayList<EObject> targets = allElements;
        EObject tempTraceModel = ExtensionPointHelper.getTracePersistenceAdapter().get().getTraceModel((ResourceSet)new ResourceSetImpl());
        EObject tempTlink = traceAdapter.createTrace(traceType, tempTraceModel, selection);
        Connection connection = new Connection(source, targets, tempTlink);
        return traceAdapter.getAllTraceLinks(this.traceModel).stream().filter(c -> c.equals(connection)).collect(Collectors.toCollection(ArrayList::new));
    }
}

