/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.job;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.ext.db.AbstractDataUpdater;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.job.CronJob;
import org.eclipse.dirigible.runtime.job.JobParser;
import org.eclipse.dirigible.runtime.job.JobsException;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class JobsUpdater
extends AbstractDataUpdater {
    public static final String EXTENSION_JOB = ".job";
    public static final String REGISTRY_INTEGRATION_DEFAULT = "/db/dirigible/registry/public/IntegrationServices";
    private static final Logger logger = Logger.getLogger(JobsUpdater.class);
    private IRepository repository;
    private DataSource dataSource;
    private String location;
    private Scheduler scheduler;
    public static List<String> activeJobs = Collections.synchronizedList(new ArrayList());

    public JobsUpdater(IRepository repository, DataSource dataSource, String location) throws JobsException {
        this.repository = repository;
        this.dataSource = dataSource;
        this.location = location;
        InputStream schedulerConfig = ((Object)((Object)this)).getClass().getResourceAsStream("/scheduler.properties");
        try {
            try {
                StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
                schedulerFactory.initialize(schedulerConfig);
                logger.debug("Creating quartz scheduler...");
                this.scheduler = schedulerFactory.getScheduler();
                logger.debug("Quartz scheduler created.");
                logger.debug("Starting quartz scheduler...");
                this.scheduler.start();
                logger.debug("Quartz scheduler started.");
            }
            catch (SchedulerException e) {
                throw new JobsException(e);
            }
        }
        finally {
            if (schedulerConfig != null) {
                try {
                    schedulerConfig.close();
                }
                catch (IOException ioException) {
                    logger.error("Cannot close the scheduler configuration stream.", (Throwable)ioException);
                }
            }
        }
    }

    public void executeUpdate(List<String> knownFiles, HttpServletRequest request, List<String> errors) throws Exception {
        if (knownFiles.size() == 0) {
            return;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                for (String jobDefinition : knownFiles) {
                    try {
                        if (!jobDefinition.endsWith(EXTENSION_JOB)) continue;
                        this.executeJobUpdate(connection, jobDefinition, request);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        errors.add(e.getMessage());
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void executeJobUpdate(Connection connection, String jobDefinition, HttpServletRequest request) throws SQLException, IOException, JobsException {
        JobDetail jobDetail;
        IRepository repository = this.repository;
        String resourcePath = jobDefinition;
        IResource resource = repository.getResource(resourcePath);
        String content = new String(resource.getContent());
        JsonObject jobDefinitionObject = JobParser.parseJob(content);
        String jobName = jobDefinitionObject.get("name").getAsString();
        String jobDescription = jobDefinitionObject.get("description").getAsString();
        String jobExpression = jobDefinitionObject.get("expression").getAsString();
        String jobType = jobDefinitionObject.get("type").getAsString();
        String jobModule = jobDefinitionObject.get("module").getAsString();
        if (activeJobs.contains(resource.getPath())) {
            try {
                jobDetail = this.scheduler.getJobDetail(resourcePath, null);
                if (jobDetail.getJobDataMap().get((Object)"type") != null && jobDetail.getJobDataMap().get((Object)"type").equals(jobType) && jobDetail.getJobDataMap().get((Object)"module") != null && jobDetail.getJobDataMap().get((Object)"module").equals(jobModule) && jobDetail.getJobDataMap().get((Object)"expression") != null && jobDetail.getJobDataMap().get((Object)"expression").equals(jobExpression)) {
                    logger.debug(String.format("Job name: %s, description: %s, expression: %s, type: %s, module: %s already exists.", jobName, jobDescription, jobExpression, jobType, jobModule));
                    return;
                }
                this.scheduler.deleteJob(resourcePath, null);
                activeJobs.remove(resourcePath);
                logger.debug(String.format("Delete job name: %s, description: %s, expression: %s, type: %s, module: %s for re-scheduling", jobName, jobDescription, jobExpression, jobType, jobModule));
            }
            catch (SchedulerException e) {
                logger.error("Error while getting the registered job: " + jobName, (Throwable)e);
            }
        }
        logger.debug(String.format("Creating quartz job name: %s, description: %s, expression: %s, type: %s, module: %s ...", jobName, jobDescription, jobExpression, jobType, jobModule));
        jobDetail = new JobDetail(resourcePath, null, CronJob.class);
        jobDetail.getJobDataMap().put("name", jobName);
        jobDetail.getJobDataMap().put("description", jobDescription);
        jobDetail.getJobDataMap().put("type", jobType);
        jobDetail.getJobDataMap().put("module", jobModule);
        jobDetail.getJobDataMap().put("expression", jobExpression);
        try {
            CronTrigger trigger = new CronTrigger(jobName, null, jobExpression);
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            activeJobs.add(resourcePath);
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            activeJobs.add(resourcePath);
        }
        catch (ParseException e) {
            throw new JobsException(e);
        }
        catch (SchedulerException e) {
            throw new JobsException(e);
        }
    }

    public void cleanDeletedJobs() {
        IRepository repository = this.repository;
        for (String jobPath : activeJobs) {
            try {
                IResource resource = repository.getResource(jobPath);
                if (resource.exists()) continue;
                this.scheduler.deleteJob(jobPath, null);
                activeJobs.remove(jobPath);
                logger.debug(String.format("Delete job: %s", jobPath));
            }
            catch (Exception e) {
                logger.error(String.format("Error while deleting a job: %s", jobPath), (Throwable)e);
            }
        }
    }

    public void enumerateKnownFiles(ICollection collection, List<String> dsDefinitions) throws IOException {
        if (collection.exists()) {
            List resources = collection.getResources();
            for (IResource resource : resources) {
                if (resource == null || resource.getName() == null || !resource.getName().endsWith(EXTENSION_JOB)) continue;
                String fullPath = resource.getPath();
                dsDefinitions.add(fullPath);
            }
            List collections = collection.getCollections();
            for (ICollection subCollection : collections) {
                this.enumerateKnownFiles(subCollection, dsDefinitions);
            }
        }
    }

    public void applyUpdates() throws IOException, Exception {
        ArrayList<String> knownFiles = new ArrayList<String>();
        ICollection srcContainer = this.repository.getCollection(this.location);
        if (srcContainer.exists()) {
            this.enumerateKnownFiles(srcContainer, knownFiles);
            this.executeUpdate(knownFiles, null);
        }
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public String getLocation() {
        return this.location;
    }

    public void executeUpdate(List<String> knownFiles, List<String> errors) throws Exception {
        this.executeUpdate(knownFiles, null, errors);
    }
}

