/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.ide.view.segments;

import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class ToolingModeUtil {
    public static final String ENABLE_SEGMENT_TOOLING = "-enableSegmentTooling";
    private static Boolean isSegmentToolingEnabled;

    private ToolingModeUtil() {
    }

    public static boolean isSegmentToolingEnabled() {
        if (isSegmentToolingEnabled == null) {
            String[] applicationArgs = Platform.getApplicationArgs();
            isSegmentToolingEnabled = false;
            Arrays.stream(applicationArgs).filter(ENABLE_SEGMENT_TOOLING::equals).findFirst().ifPresent(s -> {
                Boolean bl = isSegmentToolingEnabled = Boolean.valueOf(true);
            });
            if (isSegmentToolingEnabled.booleanValue()) {
                ToolingModeUtil.report(new AbstractReport("Segment based view model tooling is enabled.", 1));
            }
        }
        return isSegmentToolingEnabled;
    }

    private static void report(AbstractReport report) {
        BundleContext bundleContext = FrameworkUtil.getBundle(ToolingModeUtil.class).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(ReportService.class);
        ReportService reportService = (ReportService)bundleContext.getService(serviceReference);
        reportService.report(report);
        bundleContext.ungetService(serviceReference);
    }
}

