/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.spi;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IChildCreationExtender;

public class ChildrenDescriptorCollector {
    private EditingDomain domain;
    private EObject eObject;
    private Set<String> alreadyReadNameSpaces;
    private Collection<?> descriptors;

    public Collection<?> getDescriptors(EObject eObject) {
        this.eObject = eObject;
        this.domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
        this.descriptors = this.domain.getNewChildDescriptors((Object)eObject, null);
        this.alreadyReadNameSpaces = new LinkedHashSet<String>();
        this.alreadyReadNameSpaces.add(eObject.eClass().getEPackage().getNsURI());
        this.iterateThroughSuperTypes();
        return this.descriptors;
    }

    private void iterateThroughSuperTypes() {
        for (EClass eClass : this.eObject.eClass().getEAllSuperTypes()) {
            String namespace = eClass.getEPackage().getNsURI();
            if (this.alreadyReadNameSpaces.contains(namespace)) continue;
            this.iterateThroughExtenderDescriptors(namespace);
            this.alreadyReadNameSpaces.add(namespace);
        }
    }

    private void iterateThroughExtenderDescriptors(String namespace) {
        for (IChildCreationExtender.Descriptor descriptor : EMFEditPlugin.getChildCreationExtenderDescriptorRegistry().getDescriptors(namespace)) {
            IChildCreationExtender createChildCreationExtender;
            block6: {
                createChildCreationExtender = descriptor.createChildCreationExtender();
                try {
                    Field declaredField = descriptor.getClass().getDeclaredField("contributor");
                    AccessibleObject.setAccessible(new AccessibleObject[]{declaredField}, true);
                    String value = (String)declaredField.get(descriptor);
                    if (value.startsWith(this.eObject.eClass().getEPackage().getNsPrefix())) {
                    }
                    break block6;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            Collection newChildDescriptors = createChildCreationExtender.getNewChildDescriptors((Object)this.eObject, this.domain);
            this.descriptors.addAll(newChildDescriptors);
        }
    }
}

