/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.inheritance;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.declaration.inheritance.PullFeature;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="extractSuperClass2", label="Extract Super Class", description="In the metamodel, a super class is extracted from a number of sub classes. In the model, nothing is changed.")
public class ExtractSuperClass2
extends OperationImplementation {
    @EdaptParameter(main=true, description="The classes from which the super class is extracted")
    public List<EClass> subClasses;
    @EdaptParameter(optional=true, description="The features to be extracted")
    public List<EStructuralFeature> toExtract = new ArrayList<EStructuralFeature>();
    @EdaptParameter(description="The package in which the super class is created")
    public EPackage ePackage;
    @EdaptParameter(description="The name of the super class")
    public String superClassName;
    @EdaptParameter(description="Whether the super class is abstract")
    public Boolean abstr = true;
    @EdaptParameter(optional=true, description="The super classes of the sub class which become super classes of the super class")
    public List<EClass> superSuperClasses = new ArrayList<EClass>();

    @EdaptConstraint(restricts="superSuperClasses", description="The sub classes must have the super classes as common super classes")
    public boolean checkSuperSuperClasses(EClass superSuperClass) {
        for (EClass subClass : this.subClasses) {
            if (subClass.getESuperTypes().contains((Object)superSuperClass)) continue;
            return false;
        }
        return true;
    }

    @EdaptConstraint(description="The features must not have opposite references")
    public boolean checkReferencesOpposite() {
        if (this.toExtract.size() > 1) {
            return !this.isOfType(this.toExtract, EcorePackage.eINSTANCE.getEReference()) || this.hasValue(this.toExtract, (EStructuralFeature)EcorePackage.eINSTANCE.getEReference_EOpposite(), null);
        }
        return true;
    }

    @EdaptConstraint(description="The features have to be all containment references or not")
    public boolean checkSameContainment() {
        return !this.isOfType(this.toExtract, EcorePackage.eINSTANCE.getEReference()) || this.hasSameValue(this.toExtract, (EStructuralFeature)EcorePackage.eINSTANCE.getEReference_Containment());
    }

    @EdaptConstraint(description="The features have to be all attributes or references")
    public boolean checkSameClass() {
        return this.isOfSameType(this.toExtract);
    }

    @EdaptConstraint(description="The features' multiplicities have to be the same")
    public boolean checkSameMultiplicity() {
        EcorePackage mmm = EcorePackage.eINSTANCE;
        return this.hasSameValue(this.toExtract, (EStructuralFeature)mmm.getETypedElement_LowerBound()) && this.hasSameValue(this.toExtract, (EStructuralFeature)mmm.getETypedElement_UpperBound());
    }

    @EdaptConstraint(description="The features' types have to be the same")
    public boolean checkSameType() {
        return this.hasSameValue(this.toExtract, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_EType());
    }

    public void initialize(Metamodel metamodel) {
        if (this.ePackage == null) {
            this.ePackage = this.subClasses.get(0).getEPackage();
        }
    }

    public void execute(Metamodel metamodel, Model model) throws MigrationException {
        EClass superClass = MetamodelFactory.newEClass((EPackage)this.ePackage, (String)this.superClassName, this.superSuperClasses, (boolean)this.abstr);
        for (EClass subClass : this.subClasses) {
            subClass.getESuperTypes().add((Object)superClass);
            subClass.getESuperTypes().removeAll(this.superSuperClasses);
        }
        if (!this.toExtract.isEmpty()) {
            PullFeature operation = new PullFeature();
            operation.features = this.toExtract;
            operation.targetClass = superClass;
            operation.checkAndExecute(metamodel, model);
        }
    }
}

