/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.migration.execution;

import org.eclipse.emf.edapt.common.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MigratorCommandLineOption {
    MODELS(' '),
    HISTORY('h'),
    SOURCE_RELEASE('s'),
    TARGET_RELEASE('t'),
    VALIDATION_LEVEL('v'),
    BACKUP('b'),
    OPERATION('o'),
    LIBRARY('l'),
    VM_ARGUMENTS(' ');

    private char character;
    private String id;

    private MigratorCommandLineOption(char c) {
        this.character = c;
        this.init();
    }

    private void init() {
        String string = this.name();
        string = StringUtils.upperToLowerCamelCase((String)string);
        this.id = "org.eclipse.emf.edapt.migration." + string;
    }

    public static MigratorCommandLineOption getOption(char character) {
        MigratorCommandLineOption[] migratorCommandLineOptionArray = MigratorCommandLineOption.values();
        int n = migratorCommandLineOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            MigratorCommandLineOption option = migratorCommandLineOptionArray[n2];
            if (option.character == character) {
                return option;
            }
            ++n2;
        }
        return null;
    }

    public String toOptionPrefix() {
        return "-" + this.character + " ";
    }

    public String id() {
        return this.id;
    }
}

