/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation.event;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.event.Observes;
import jakarta.servlet.ServletRequest;
import java.util.concurrent.atomic.AtomicBoolean;

@ApplicationScoped
public class ApplicationScopedObserver {
    private final AtomicBoolean destroyedCalled = new AtomicBoolean();
    private final AtomicBoolean beforeDestroyedCalled = new AtomicBoolean();

    void observeBeforeDestroyed(@Observes @BeforeDestroyed(value=ConversationScoped.class) ServletRequest event) {
        if (event.getAttribute("foo") != null) {
            this.beforeDestroyedCalled.set(true);
        }
    }

    void observeRequestDestroyed(@Observes @Destroyed(value=ConversationScoped.class) ServletRequest event) {
        if (event.getAttribute("foo") != null) {
            this.destroyedCalled.set(true);
        }
    }

    boolean isBeforeDestroyedCalled() {
        return this.beforeDestroyedCalled.get();
    }

    boolean isDestroyedCalled() {
        return this.destroyedCalled.get();
    }

    public void reset() {
        this.beforeDestroyedCalled.set(false);
        this.destroyedCalled.set(false);
    }
}

