/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;

final class HeaderTable {
    private static final HeaderField[] staticTable = new HeaderField[]{null, new HeaderField(":authority"), new HeaderField(":method", "GET"), new HeaderField(":method", "POST"), new HeaderField(":path", "/"), new HeaderField(":path", "/index.html"), new HeaderField(":scheme", "http"), new HeaderField(":scheme", "https"), new HeaderField(":status", "200"), new HeaderField(":status", "204"), new HeaderField(":status", "206"), new HeaderField(":status", "304"), new HeaderField(":status", "400"), new HeaderField(":status", "404"), new HeaderField(":status", "500"), new HeaderField("accept-charset"), new HeaderField("accept-encoding", "gzip, deflate"), new HeaderField("accept-language"), new HeaderField("accept-ranges"), new HeaderField("accept"), new HeaderField("access-control-allow-origin"), new HeaderField("age"), new HeaderField("allow"), new HeaderField("authorization"), new HeaderField("cache-control"), new HeaderField("content-disposition"), new HeaderField("content-encoding"), new HeaderField("content-language"), new HeaderField("content-length"), new HeaderField("content-location"), new HeaderField("content-range"), new HeaderField("content-type"), new HeaderField("cookie"), new HeaderField("date"), new HeaderField("etag"), new HeaderField("expect"), new HeaderField("expires"), new HeaderField("from"), new HeaderField("host"), new HeaderField("if-match"), new HeaderField("if-modified-since"), new HeaderField("if-none-match"), new HeaderField("if-range"), new HeaderField("if-unmodified-since"), new HeaderField("last-modified"), new HeaderField("link"), new HeaderField("location"), new HeaderField("max-forwards"), new HeaderField("proxy-authenticate"), new HeaderField("proxy-authorization"), new HeaderField("range"), new HeaderField("referer"), new HeaderField("refresh"), new HeaderField("retry-after"), new HeaderField("server"), new HeaderField("set-cookie"), new HeaderField("strict-transport-security"), new HeaderField("transfer-encoding"), new HeaderField("user-agent"), new HeaderField("vary"), new HeaderField("via"), new HeaderField("www-authenticate")};
    private static final int STATIC_TABLE_LENGTH = staticTable.length - 1;
    private static final int ENTRY_SIZE = 32;
    private static final Map<String, LinkedHashMap<String, Integer>> staticIndexes = new HashMap<String, LinkedHashMap<String, Integer>>(STATIC_TABLE_LENGTH);
    private final Table dynamicTable = new Table(0);
    private int maxSize;
    private int size;

    public HeaderTable(int maxSize) {
        this.setMaxSize(maxSize);
    }

    public int indexOf(CharSequence name, CharSequence value) {
        Integer idx;
        String n = name.toString();
        String v = value.toString();
        Map values = staticIndexes.get(n);
        if (values != null && (idx = (Integer)values.get(v)) != null) {
            return idx;
        }
        int didx = this.dynamicTable.indexOf(n, v);
        if (didx > 0) {
            return STATIC_TABLE_LENGTH + didx;
        }
        if (didx < 0) {
            if (values != null) {
                return -((Integer)values.values().iterator().next()).intValue();
            }
            return -STATIC_TABLE_LENGTH + didx;
        }
        if (values != null) {
            return -((Integer)values.values().iterator().next()).intValue();
        }
        return 0;
    }

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int length() {
        return STATIC_TABLE_LENGTH + this.dynamicTable.size();
    }

    HeaderField get(int index) {
        this.checkIndex(index);
        if (index <= STATIC_TABLE_LENGTH) {
            return staticTable[index];
        }
        return this.dynamicTable.get(index - STATIC_TABLE_LENGTH);
    }

    void put(CharSequence name, CharSequence value) {
        this.put(new HeaderField(name.toString(), value.toString()));
    }

    private void put(HeaderField h) {
        int entrySize = this.sizeOf(h);
        while (entrySize > this.maxSize - this.size && this.size != 0) {
            this.evictEntry();
        }
        if (entrySize > this.maxSize - this.size) {
            return;
        }
        this.size += entrySize;
        this.dynamicTable.add(h);
    }

    void setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize >= 0: maxSize=" + maxSize);
        }
        while (maxSize < this.size && this.size != 0) {
            this.evictEntry();
        }
        this.maxSize = maxSize;
        int upperBound = maxSize / 32 + 1;
        this.dynamicTable.setCapacity(upperBound);
    }

    HeaderField evictEntry() {
        HeaderField f = this.dynamicTable.remove();
        this.size -= this.sizeOf(f);
        return f;
    }

    public String toString() {
        double used = this.maxSize == 0 ? 0.0 : 100.0 * ((double)this.size / (double)this.maxSize);
        return String.format("entries: %d; used %s/%s (%.1f%%)", this.dynamicTable.size(), this.size, this.maxSize, used);
    }

    int checkIndex(int index) {
        if (index < 1 || index > STATIC_TABLE_LENGTH + this.dynamicTable.size()) {
            throw new IllegalArgumentException(String.format("1 <= index <= length(): index=%s, length()=%s", index, this.length()));
        }
        return index;
    }

    int sizeOf(HeaderField f) {
        return f.name.length() + f.value.length() + 32;
    }

    String getStateString() {
        if (this.size == 0) {
            return "empty.";
        }
        StringBuilder b = new StringBuilder();
        int size = this.dynamicTable.size();
        for (int i = 1; i <= size; ++i) {
            HeaderField e = this.dynamicTable.get(i);
            b.append(String.format("[%3d] (s = %3d) %s: %s%n", i, this.sizeOf(e), e.name, e.value));
        }
        b.append(String.format("      Table size:%4s", this.size));
        return b.toString();
    }

    static {
        for (int i = 1; i <= STATIC_TABLE_LENGTH; ++i) {
            HeaderField f = staticTable[i];
            LinkedHashMap<String, Integer> values = staticIndexes.get(f.name);
            if (values == null) {
                values = new LinkedHashMap();
                values.put(f.value, i);
            }
            staticIndexes.put(f.name, values);
        }
    }

    private static final class Table {
        private final Map<String, Map<String, Long>> map;
        private final CircularBuffer<HeaderField> buffer;
        private long counter = 1L;

        Table(int capacity) {
            this.buffer = new CircularBuffer(capacity);
            this.map = new HashMap<String, Map<String, Long>>(capacity);
        }

        void add(HeaderField f) {
            this.buffer.add(f);
            Map<String, Long> values = this.map.get(f.name);
            if (values == null) {
                values = new HashMap<String, Long>();
                values.put(f.value, this.counter++);
            }
            this.map.put(f.name, values);
        }

        HeaderField get(int index) {
            return this.buffer.get(index - 1);
        }

        int indexOf(String name, String value) {
            Map<String, Long> values = this.map.get(name);
            if (values == null) {
                return 0;
            }
            Long index = values.get(value);
            if (index != null) {
                return (int)(this.counter - index);
            }
            assert (!values.isEmpty());
            Long any = values.values().iterator().next();
            return -((int)(this.counter - any));
        }

        HeaderField remove() {
            HeaderField f = this.buffer.remove();
            Map<String, Long> values = this.map.get(f.name);
            Long index = values.remove(f.value);
            assert (index != null);
            if (values.isEmpty()) {
                this.map.remove(f.name);
            }
            return f;
        }

        int size() {
            return this.buffer.size;
        }

        public void setCapacity(int capacity) {
            this.buffer.resize(capacity);
        }
    }

    static final class HeaderField {
        final String name;
        final String value;

        public HeaderField(String name) {
            this(name, "");
        }

        public HeaderField(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.value.isEmpty() ? this.name : this.name + ": " + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HeaderField that = (HeaderField)o;
            return this.name.equals(that.name) && this.value.equals(that.value);
        }

        public int hashCode() {
            return 31 * this.name.hashCode() + this.value.hashCode();
        }
    }

    static final class CircularBuffer<E> {
        int tail;
        int head;
        int size;
        int capacity;
        Object[] elements;

        CircularBuffer(int capacity) {
            this.capacity = capacity;
            this.elements = new Object[capacity];
        }

        void add(E elem) {
            if (this.size == this.capacity) {
                throw new IllegalStateException(String.format("No room for '%s': capacity=%s", elem, this.capacity));
            }
            this.elements[this.head] = elem;
            this.head = (this.head + 1) % this.capacity;
            ++this.size;
        }

        E remove() {
            if (this.size == 0) {
                throw new NoSuchElementException("Empty");
            }
            Object elem = this.elements[this.tail];
            this.elements[this.tail] = null;
            this.tail = (this.tail + 1) % this.capacity;
            --this.size;
            return (E)elem;
        }

        E get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException(String.format("0 <= index <= capacity: index=%s, capacity=%s", index, this.capacity));
            }
            int idx = (this.tail + this.size - index - 1) % this.capacity;
            return (E)this.elements[idx];
        }

        public void resize(int newCapacity) {
            if (newCapacity < this.size) {
                throw new IllegalStateException(String.format("newCapacity >= size: newCapacity=%s, size=%s", newCapacity, this.size));
            }
            Object[] newElements = new Object[newCapacity];
            if (this.tail < this.head || this.size == 0) {
                System.arraycopy(this.elements, this.tail, newElements, 0, this.size);
            } else {
                System.arraycopy(this.elements, this.tail, newElements, 0, this.elements.length - this.tail);
                System.arraycopy(this.elements, 0, newElements, this.elements.length - this.tail, this.head);
            }
            this.elements = newElements;
            this.tail = 0;
            this.head = this.size;
            this.capacity = newCapacity;
        }
    }
}

