/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.http2.AplnExtensionCompatibility;
import org.glassfish.grizzly.npn.AlpnClientNegotiator;
import org.glassfish.grizzly.npn.AlpnServerNegotiator;
import org.glassfish.grizzly.npn.NegotiationSupport;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLUtils;

public class AlpnSupport {
    private static final Logger LOGGER = Grizzly.logger(AlpnSupport.class);
    private static final Map<SSLEngine, Connection<?>> SSL_TO_CONNECTION_MAP = new WeakHashMap();
    private static final AlpnSupport INSTANCE;
    private static final AplnExtensionCompatibility COMPATIBILITY;
    private final Map<Object, AlpnServerNegotiator> serverSideNegotiators = new WeakHashMap<Object, AlpnServerNegotiator>();
    private final ReadWriteLock serverSideLock = new ReentrantReadWriteLock();
    private final Map<Object, AlpnClientNegotiator> clientSideNegotiators = new WeakHashMap<Object, AlpnClientNegotiator>();
    private final ReadWriteLock clientSideLock = new ReentrantReadWriteLock();
    private final SSLBaseFilter.HandshakeListener handshakeListener = new SSLBaseFilter.HandshakeListener(){

        @Override
        public void onInit(Connection<?> connection, SSLEngine sslEngine) {
            assert (sslEngine != null);
            if (sslEngine.getUseClientMode()) {
                return;
            }
            if (!COMPATIBILITY.isProtocolSelectorSetterInImpl()) {
                return;
            }
            AlpnServerNegotiator negotiator = AlpnSupport.this.getServerNegotiator(connection);
            if (negotiator == null) {
                return;
            }
            Method setter = COMPATIBILITY.getProtocolSelectorSetter(sslEngine);
            try {
                setter.invoke((Object)sslEngine, negotiator);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Couldn't execute " + String.valueOf(setter), ex);
            }
        }

        @Override
        public void onStart(Connection<?> connection) {
            final SSLEngine sslEngine = SSLUtils.getSSLEngine(connection);
            assert (sslEngine != null);
            if (sslEngine.getUseClientMode()) {
                AlpnClientNegotiator negotiator = AlpnSupport.this.getClientNegotiator(connection);
                if (negotiator != null) {
                    connection.addCloseListener(new CloseListener<Closeable, CloseType>(){

                        @Override
                        public void onClosed(Closeable closeable, CloseType type) throws IOException {
                            NegotiationSupport.removeAlpnClientNegotiator(sslEngine);
                            SSL_TO_CONNECTION_MAP.remove(sslEngine);
                        }
                    });
                    AlpnSupport.setConnection(sslEngine, connection);
                    NegotiationSupport.addNegotiator(sslEngine, negotiator);
                }
            } else {
                AlpnServerNegotiator negotiator = AlpnSupport.this.getServerNegotiator(connection);
                if (negotiator != null) {
                    connection.addCloseListener(new CloseListener<Closeable, CloseType>(){

                        @Override
                        public void onClosed(Closeable closeable, CloseType type) throws IOException {
                            NegotiationSupport.removeAlpnServerNegotiator(sslEngine);
                            SSL_TO_CONNECTION_MAP.remove(sslEngine);
                        }
                    });
                    AlpnSupport.setConnection(sslEngine, connection);
                    NegotiationSupport.addNegotiator(sslEngine, negotiator);
                }
            }
        }

        @Override
        public void onComplete(Connection<?> connection) {
        }

        @Override
        public void onFailure(Connection<?> connection, Throwable t) {
        }
    };

    public static boolean isEnabled() {
        return INSTANCE != null;
    }

    public static AlpnSupport getInstance() {
        if (!AlpnSupport.isEnabled()) {
            throw new IllegalStateException("TLS ALPN is disabled");
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection<?> getConnection(SSLEngine engine) {
        Map<SSLEngine, Connection<?>> map = SSL_TO_CONNECTION_MAP;
        synchronized (map) {
            return SSL_TO_CONNECTION_MAP.get(engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setConnection(SSLEngine engine, Connection<?> connection) {
        Map<SSLEngine, Connection<?>> map = SSL_TO_CONNECTION_MAP;
        synchronized (map) {
            SSL_TO_CONNECTION_MAP.put(engine, connection);
        }
    }

    private AlpnSupport() {
    }

    public void configure(SSLBaseFilter sslFilter) {
        sslFilter.addHandshakeListener(this.handshakeListener);
    }

    public void setServerSideNegotiator(Transport transport, AlpnServerNegotiator negotiator) {
        this.putServerSideNegotiator(transport, negotiator);
    }

    public void setServerSideNegotiator(Connection<?> connection, AlpnServerNegotiator negotiator) {
        this.putServerSideNegotiator(connection, negotiator);
    }

    public void setClientSideNegotiator(Transport transport, AlpnClientNegotiator negotiator) {
        this.putClientSideNegotiator(transport, negotiator);
    }

    public void setClientSideNegotiator(Connection<?> connection, AlpnClientNegotiator negotiator) {
        this.putClientSideNegotiator(connection, negotiator);
    }

    private void putServerSideNegotiator(Object object, AlpnServerNegotiator negotiator) {
        this.serverSideLock.writeLock().lock();
        try {
            this.serverSideNegotiators.put(object, negotiator);
        }
        finally {
            this.serverSideLock.writeLock().unlock();
        }
    }

    private void putClientSideNegotiator(Object object, AlpnClientNegotiator negotiator) {
        this.clientSideLock.writeLock().lock();
        try {
            this.clientSideNegotiators.put(object, negotiator);
        }
        finally {
            this.clientSideLock.writeLock().unlock();
        }
    }

    private AlpnClientNegotiator getClientNegotiator(Connection<?> connection) {
        AlpnClientNegotiator negotiator;
        this.clientSideLock.readLock().lock();
        try {
            negotiator = this.clientSideNegotiators.get(connection);
            if (negotiator == null) {
                negotiator = this.clientSideNegotiators.get(connection.getTransport());
            }
        }
        finally {
            this.clientSideLock.readLock().unlock();
        }
        return negotiator;
    }

    private AlpnServerNegotiator getServerNegotiator(Connection<?> connection) {
        AlpnServerNegotiator negotiator;
        this.serverSideLock.readLock().lock();
        try {
            negotiator = this.serverSideNegotiators.get(connection);
            if (negotiator == null) {
                negotiator = this.serverSideNegotiators.get(connection.getTransport());
            }
        }
        finally {
            this.serverSideLock.readLock().unlock();
        }
        return negotiator;
    }

    static {
        COMPATIBILITY = AplnExtensionCompatibility.getInstance();
        LOGGER.config(() -> "Detected ALPN compatibility info: " + String.valueOf(COMPATIBILITY));
        INSTANCE = COMPATIBILITY.isAlpnExtensionAvailable() ? new AlpnSupport() : null;
    }
}

