/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jnosql.nosql.metadata.reflection;

import jakarta.nosql.AttributeConverter;
import jakarta.nosql.Embeddable;
import jakarta.nosql.Entity;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.mapping.metadata.MapParameterMetaData;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.glassfish.main.jnosql.nosql.metadata.reflection.DefaultParameterMetaData;

class DefaultMapParameterMetaData
extends DefaultParameterMetaData
implements MapParameterMetaData {
    private final TypeSupplier<?> typeSupplier;
    private final Class<?> keyType;
    private final Class<?> valueType;
    private final boolean embeddableField;

    DefaultMapParameterMetaData(String name, Class<?> type, boolean id, Class<? extends AttributeConverter<?, ?>> converter, MappingType mappingType, TypeSupplier<?> typeSupplier) {
        super(name, type, id, converter, mappingType);
        this.typeSupplier = typeSupplier;
        this.keyType = (Class)((ParameterizedType)typeSupplier.get()).getActualTypeArguments()[0];
        this.valueType = (Class)((ParameterizedType)typeSupplier.get()).getActualTypeArguments()[1];
        this.embeddableField = this.hasFieldAnnotation(Embeddable.class) || this.hasFieldAnnotation(Entity.class);
    }

    public boolean isEmbeddable() {
        return this.embeddableField;
    }

    public Class<?> keyType() {
        return this.keyType;
    }

    public Class<?> valueType() {
        return this.valueType;
    }

    public Object value(Value value) {
        return value.get(this.typeSupplier);
    }

    private boolean hasFieldAnnotation(Class<? extends Annotation> annotation) {
        return this.valueType.getAnnotation(annotation) != null;
    }
}

