/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.webclient.TestFailureException;
import com.sun.ts.tests.common.webclient.WebTestCase;
import com.sun.ts.tests.common.webclient.http.HttpRequest;
import com.sun.ts.tests.common.webclient.http.HttpResponse;
import com.sun.ts.tests.common.webclient.validation.CheckOneOfStatusesTokenizedValidator;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.stream.Collectors;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpState;
import org.junit.jupiter.api.Assertions;

public abstract class JAXRSCommonClient {
    private static final long serialVersionUID = 1L;
    protected static final String SERVLETHOSTPROP = "webServerHost";
    protected static final String SERVLETPORTPROP = "webServerPort";
    protected static final String TSHOME = "ts_home";
    protected static final Hashtable<Property, String> TEST_PROPS = new Hashtable();
    protected static final String STATUS_CODE = "STATUS_CODE";
    protected static final String REQUEST = "REQUEST";
    protected static final String REQUEST_HEADERS = "REQUEST_HEADERS";
    protected static final String GOLDENFILE = "goldenfile";
    protected static final String SEARCH_STRING = "SEARCH_STRING";
    protected String TESTDIR = null;
    protected String GOLDENFILEDIR = "/src/web";
    protected static final String GET = "GET ";
    protected static final String HTTP10 = " HTTP/1.0";
    protected static final String HTTP11 = " HTTP/1.1";
    protected static final String SL = "/";
    protected static final String GF_SUFFIX = ".gf";
    protected String _testName = null;
    protected String _tsHome = null;
    public String _contextRoot = null;
    protected String _generalURI = null;
    protected String _hostname = null;
    protected int _port = 0;
    protected HttpState _state = null;
    protected WebTestCase _testCase = null;
    protected boolean _useSavedState = false;
    protected boolean _saveState = false;
    protected boolean _redirect = false;
    public static final String newline = System.getProperty("line.separator");
    public static final String servletAdaptor = System.getProperty("servlet_adaptor", "org.glassfish.jersey.servlet.ServletContainer");
    public static final String indent = "    ";
    private InetAddress[] _addrs = null;
    protected String _servlet = null;

    public void setTestDir(String testDir) {
        TestUtil.logTrace((String)"[JAXRSCommonClient] setTestDir");
        this.TESTDIR = testDir;
    }

    public void setContextRoot(String root) {
        TestUtil.logTrace((String)("[JAXRSCommonClient] Contextroot set at " + root));
        this._contextRoot = root;
    }

    public String getContextRoot() {
        TestUtil.logTrace((String)"[JAXRSCommonClient]getContextRoot");
        return this._contextRoot;
    }

    public void setup() {
        TestUtil.logTrace((String)"setup method JAXRSCommonClient");
        String hostname = System.getProperty(SERVLETHOSTPROP);
        String portnum = System.getProperty(SERVLETPORTPROP);
        Assertions.assertTrue((!this.isNullOrEmpty(hostname) ? 1 : 0) != 0, (String)"[JAXRSCommonClient] 'webServerHost' was not set.");
        this._hostname = hostname.trim();
        Assertions.assertTrue((!this.isNullOrEmpty(portnum) ? 1 : 0) != 0, (String)"[JAXRSCommonClient] 'webServerPort' was not set.");
        this._port = Integer.parseInt(portnum.trim());
        TestUtil.logMsg((String)"[JAXRSCommonClient] Test setup OK");
    }

    public void cleanup() throws Fault {
        TestUtil.logMsg((String)"[JAXRSCommonClient] Test cleanup OK");
    }

    protected void invoke() throws Fault {
        TestUtil.logTrace((String)"[JAXRSCommonClient] invoke");
        try {
            this._testCase = new WebTestCase();
            this.setTestProperties(this._testCase);
            TestUtil.logTrace((String)"[JAXRSCommonClient] EXECUTING");
            if (this._useSavedState && this._state != null) {
                this._testCase.getRequest().setState(this._state);
            }
            if (this._redirect) {
                TestUtil.logTrace((String)"##########Call setFollowRedirects");
                this._testCase.getRequest().setFollowRedirects(this._redirect);
            }
            this._testCase.execute();
            if (this._saveState) {
                this._state = this._testCase.getResponse().getState();
            }
        }
        catch (TestFailureException tfe) {
            Throwable t = tfe.getRootCause();
            if (t != null) {
                TestUtil.logErr((String)("Root cause of Failure: " + t.getMessage()), (Throwable)t);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
            throw new Fault("[JAXRSCommonClient] " + this._testName + " failed!  Check output for cause of failure.", tfe);
        }
        finally {
            this._useSavedState = false;
            this._saveState = false;
            this._redirect = false;
            this.clearTestProperties();
        }
    }

    protected void setTestProperties(WebTestCase testCase) {
        HttpRequest req;
        TestUtil.logTrace((String)"[JAXRSCommonClient] setTestProperties");
        this.setStandardProperties(TEST_PROPS.get((Object)Property.STANDARD), testCase);
        this.setApiTestProperties(TEST_PROPS.get((Object)Property.APITEST), testCase);
        if (TEST_PROPS.get((Object)Property.STATUS_CODE) == null) {
            this.setProperty(Property.STATUS_CODE, JAXRSCommonClient.getStatusCode(Response.Status.OK));
        }
        if ((req = testCase.getRequest()) == null) {
            req = this.setWebTestCaseRequest(testCase, null);
        }
        this.setWebTestCaseProperties(testCase, req);
    }

    protected HttpRequest setWebTestCaseRequest(WebTestCase testCase, HttpRequest req) {
        String request = TEST_PROPS.get((Object)Property.REQUEST);
        boolean isRequest = false;
        for (Request r : Request.values()) {
            if (!request.startsWith(r.name())) continue;
            isRequest = true;
        }
        if (request.endsWith(HTTP10) || request.endsWith(HTTP11)) {
            isRequest = true;
        }
        if (isRequest) {
            req = this.createHttpRequest(request, this._hostname, this._port);
            testCase.setRequest(req);
        } else {
            req = this.createHttpRequest(this.getTSRequest(request), this._hostname, this._port);
            testCase.setRequest(req);
        }
        return req;
    }

    protected void setWebTestCaseProperties(WebTestCase testCase, HttpRequest req) {
        Property key = null;
        String value = null;
        Enumeration<Property> e = TEST_PROPS.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            value = TEST_PROPS.get((Object)key);
            switch (key.ordinal()) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    String user = TEST_PROPS.get((Object)Property.BASIC_AUTH_USER);
                    String password = TEST_PROPS.get((Object)Property.BASIC_AUTH_PASSWD);
                    String realm = TEST_PROPS.get((Object)Property.BASIC_AUTH_REALM);
                    req.setAuthenticationCredentials(user, password, 1, realm);
                    break;
                }
                case 4: {
                    req.setContent(value);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    testCase.addExpectedHeader(value);
                    break;
                }
                case 8: {
                    TestUtil.logTrace((String)"##########Found redirect Property");
                    this._redirect = true;
                    break;
                }
                case 9: {
                    StringBuffer sb = new StringBuffer(50);
                    sb.append(this._tsHome).append(this.GOLDENFILEDIR);
                    sb.append(this._generalURI).append(SL);
                    sb.append(value);
                    testCase.setGoldenFilePath(sb.toString());
                    break;
                }
                case 10: {
                    testCase.setGoldenFilePath(null);
                    break;
                }
                case 11: {
                    testCase.setExpectedStatusCode("-1");
                    break;
                }
                case 12: {
                    testCase.setExpectedReasonPhrase(value);
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    req.addRequestHeader(value);
                    break;
                }
                case 15: {
                    break;
                }
                case 16: {
                    this._saveState = true;
                    break;
                }
                case 17: {
                    testCase.setResponseSearchString(value);
                    break;
                }
                case 18: {
                    testCase.setResponseSearchStringIgnoreCase(value);
                    break;
                }
                case 19: {
                    break;
                }
                case 20: {
                    if (value.contains("|")) {
                        testCase.setStrategy(CheckOneOfStatusesTokenizedValidator.class.getName());
                    }
                    testCase.setExpectedStatusCode(value);
                    break;
                }
                case 21: {
                    testCase.setStrategy(value);
                    break;
                }
                case 22: {
                    break;
                }
                case 23: {
                    testCase.addUnexpectedHeader(value);
                    break;
                }
                case 24: {
                    testCase.setUnexpectedResponseSearchString(value);
                    break;
                }
                case 25: {
                    testCase.setUnorderedSearchString(value);
                    break;
                }
                case 26: {
                    this._useSavedState = true;
                }
            }
        }
    }

    protected String buildRequest(String type, String ... path) {
        StringBuilder sb = new StringBuilder();
        sb.append(type).append(" ").append(this._contextRoot).append(SL);
        for (String segment : path) {
            sb.append(segment);
        }
        sb.append(HTTP11);
        return sb.toString();
    }

    protected String buildRequest(Request type, String ... path) {
        return this.buildRequest(type.name(), path);
    }

    protected String buildRequest10(Request type, String ... path) {
        return this.buildRequest(type, path).replace(HTTP11, HTTP10);
    }

    protected static String buildAccept(MediaType type) {
        return JAXRSCommonClient.buildHeaderMediaType("Accept", type);
    }

    protected static String buildContentType(MediaType type) {
        return JAXRSCommonClient.buildHeaderMediaType("Content-Type", type);
    }

    protected static String buildHeaderMediaType(String header, MediaType type) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(":").append(type.getType()).append(SL);
        sb.append(type.getSubtype());
        return sb.toString();
    }

    public static String toString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream) throws IOException {
        return JAXRSCommonClient.toString(inStream).replaceAll("servlet_adaptor", servletAdaptor);
    }

    protected String getResponseBody() throws Fault {
        try {
            HttpResponse response = this._testCase.getResponse();
            boolean isNull = response.getResponseBodyAsRawStream() == null;
            return isNull ? null : response.getResponseBodyAsString();
        }
        catch (IOException e) {
            throw new Fault(e);
        }
    }

    protected String[] getResponseHeaders() throws Fault {
        Header[] headerEntities = this._testCase.getResponse().getResponseHeaders();
        String[] headers = new String[headerEntities.length];
        for (int i = 0; i != headerEntities.length; ++i) {
            headers[i] = headerEntities[i].toString();
        }
        return headers;
    }

    protected void assertResponseHeadersContain(String s) throws Fault {
        boolean found = false;
        for (String header : this.getResponseHeaders()) {
            if (!header.contains(s)) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found, (String)("Response headers do not contain" + s));
    }

    protected void assertResponseBodyContain(String s) throws Fault {
        boolean found = this.getResponseBody().contains(s);
        Assertions.assertTrue((boolean)found, (String)("Response body does not contain" + s));
    }

    protected Response.Status getResponseStatusCode() {
        String status = this._testCase.getResponse().getStatusCode();
        return Response.Status.fromStatusCode((int)Integer.parseInt(status));
    }

    protected void setProperty(String key, String value) {
        Property property = Property.valueOf(key);
        this.setProperty(property, value);
    }

    protected void setProperty(Property key, String ... value) {
        this.setProperty(key, JAXRSCommonClient.objectsToString("", (Object[])value));
    }

    protected void setProperty(Property key, String value) {
        String oldValue = TEST_PROPS.get((Object)key);
        if (oldValue == null) {
            TEST_PROPS.put(key, value);
        } else {
            int len = value.length() + oldValue.length() + 1;
            StringBuilder combinedValue = new StringBuilder(len);
            combinedValue.append(oldValue).append("|").append(value);
            TEST_PROPS.put(key, combinedValue.toString());
        }
    }

    protected void clearProperty(Property key) {
        TEST_PROPS.remove((Object)key);
    }

    public static <T> void assertEquals(T first, T second, Object ... message) {
        if (first == null && second == null) {
            return;
        }
        Assertions.assertFalse((first == null && second != null ? 1 : 0) != 0, (String)message.toString());
        Assertions.assertFalse((first != null && second == null ? 1 : 0) != 0, (String)message.toString());
        if (first instanceof Comparable) {
            Assertions.assertTrue((((Comparable)first).compareTo(second) == 0 ? 1 : 0) != 0, (String)message.toString());
        } else {
            Assertions.assertTrue((boolean)first.equals(second), (String)message.toString());
        }
    }

    public static <T> void assertEqualsInt(int first, int second, Object ... message) {
        Assertions.assertTrue((first == second ? 1 : 0) != 0, (String)message.toString());
    }

    public static <T> void assertEqualsLong(long first, long second, Object ... message) {
        Assertions.assertTrue((first == second ? 1 : 0) != 0, (String)message.toString());
    }

    public static <T> void assertEqualsBool(boolean first, boolean second, Object ... message) {
        Assertions.assertTrue((first == second ? 1 : 0) != 0, (String)message.toString());
    }

    public static void assertNull(Object object, Object ... message) {
        Assertions.assertTrue((object == null ? 1 : 0) != 0, (String)message.toString());
    }

    public static void assertNotNull(Object object, Object ... message) {
        Assertions.assertTrue((object != null ? 1 : 0) != 0, (String)message.toString());
    }

    public static void fault(Object ... objects) throws Fault {
        throw new Fault(JAXRSCommonClient.objectsToString(objects));
    }

    public static void assertContains(String string, String substring, Object ... message) {
        Assertions.assertTrue((boolean)string.contains(substring), (String)message.toString());
    }

    public static void assertContainsIgnoreCase(String string, String substring, Object ... message) {
        Assertions.assertTrue((boolean)string.toLowerCase().contains(substring.toLowerCase()), (String)message.toString());
    }

    public static <T> void assertContains(T text, T subtext, Object ... message) {
        JAXRSCommonClient.assertContains(text.toString(), subtext.toString(), new Object[]{message.toString()});
    }

    public static <T> void assertContainsIgnoreCase(T text, T subtext, Object ... message) {
        JAXRSCommonClient.assertContainsIgnoreCase(text.toString(), subtext.toString(), new Object[]{message.toString()});
    }

    protected static <T extends Throwable> T assertCause(Throwable parent, Class<T> wrapped, Object ... msg) {
        T t = JAXRSCommonClient.hasCause(parent, wrapped);
        JAXRSCommonClient.assertNotNull(t, msg);
        return t;
    }

    private static <T extends Throwable> T hasCause(Throwable parent, Class<? extends Throwable> cause) {
        while (parent != null) {
            if (cause.isInstance(parent)) {
                return (T)parent;
            }
            parent = parent.getCause();
        }
        return null;
    }

    public static String getStatusCode(Response.Status status) {
        return String.valueOf(status.getStatusCode());
    }

    public static void logMsg(Object ... msg) {
        TestUtil.logMsg((String)JAXRSCommonClient.objectsToString(msg));
    }

    public static void logTrace(Object ... msg) {
        TestUtil.logTrace((String)JAXRSCommonClient.objectsToString(msg));
    }

    protected static String objectsToString(Object ... objects) {
        return JAXRSCommonClient.objectsToString(" ", objects);
    }

    protected static String objectsToString(String delimiter, Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object o : objects) {
            sb.append(o).append(delimiter);
        }
        return sb.toString().trim();
    }

    private String getTSRequest(String request) {
        TestUtil.logTrace((String)"[JAXRSCommonClient] getTSRequest");
        StringBuffer finReq = new StringBuffer(50);
        finReq.append(GET).append(this._contextRoot).append(SL).append(this._generalURI);
        finReq.append(SL).append(request).append(HTTP11);
        return finReq.toString();
    }

    protected void clearTestProperties() {
        TEST_PROPS.clear();
    }

    protected boolean isNullOrEmpty(String val) {
        return val == null || val.trim().equals("");
    }

    private void setApiTestProperties(String testValue, WebTestCase testCase) {
        TestUtil.logTrace((String)"[JAXRSCommonClient] setApiTestProperties");
        if (testValue == null) {
            return;
        }
        this._testName = testValue;
        StringBuffer sb = new StringBuffer(50);
        if (this._servlet != null && TEST_PROPS.get((Object)Property.DONOTUSEServletName) == null) {
            sb.append(GET).append(this._contextRoot).append(SL);
            sb.append(this._servlet).append("?testname=").append(testValue);
            sb.append(HTTP11);
        } else {
            sb.append(GET).append(this._contextRoot).append(SL);
            sb.append(testValue).append(HTTP10);
        }
        System.out.println("REQUEST LINE: " + sb.toString());
        HttpRequest req = this.createHttpRequest(sb.toString(), this._hostname, this._port);
        testCase.setRequest(req);
        String value = TEST_PROPS.get((Object)Property.SEARCH_STRING);
        if (this.isNullOrEmpty(value)) {
            testCase.setResponseSearchString("Test PASSED");
            testCase.setUnexpectedResponseSearchString("Test FAILED");
        }
    }

    protected HttpRequest createHttpRequest(String requestLine, String host, int port) {
        return new HttpRequest(requestLine, host, port);
    }

    private void setStandardProperties(String testValue, WebTestCase testCase) {
        TestUtil.logTrace((String)"[JAXRSCommonClient] setStandardProperties");
        if (testValue == null) {
            return;
        }
        this._testName = testValue;
        String req = this._servlet != null ? this.buildRequest(Request.GET, this._servlet, "?testname=", testValue) : this.buildRequest10(Request.GET, testValue);
        System.out.println("REQUEST LINE: " + req);
        System.out.println("_hostname=" + this._hostname);
        HttpRequest httpReq = this.createHttpRequest(req, this._hostname, this._port);
        testCase.setRequest(httpReq);
        StringBuffer sb = new StringBuffer(50);
        sb.append(this._tsHome).append(this.GOLDENFILEDIR);
        sb.append(this._generalURI).append(SL);
        sb.append(testValue).append(GF_SUFFIX);
        testCase.setGoldenFilePath(sb.toString());
    }

    protected void setServletName(String servlet) {
        TestUtil.logTrace((String)"[JAXRSCommonClient] setServletName");
        this._servlet = servlet;
    }

    protected String getServletName() {
        return this._servlet;
    }

    protected String getLocalInterfaceInfo(boolean returnAddresses) {
        String result = null;
        this.initInetAddress();
        if (this._addrs.length != 0) {
            StringBuffer sb = new StringBuffer(32);
            if (!returnAddresses) {
                sb.append("localhost,");
            } else {
                sb.append("127.0.0.1,");
            }
            for (int i = 0; i < this._addrs.length; ++i) {
                if (returnAddresses) {
                    String ip = this._addrs[i].getHostAddress();
                    if (!ip.equals("127.0.0.1")) {
                        if (ip.contains("%")) {
                            int scope_id = ip.indexOf("%");
                            ip = ip.substring(0, scope_id);
                        }
                        sb.append(ip);
                    }
                } else {
                    String host = this._addrs[i].getCanonicalHostName();
                    if (!host.equals("localhost")) {
                        sb.append(host);
                    }
                }
                if (i + 1 == this._addrs.length) continue;
                sb.append(",");
            }
            result = sb.toString();
            TestUtil.logTrace((String)("[AbstractUrlClient] Interface info: " + result));
        }
        return result;
    }

    private void initInetAddress() {
        if (this._addrs == null) {
            try {
                this._addrs = InetAddress.getAllByName(InetAddress.getLocalHost().getCanonicalHostName());
            }
            catch (UnknownHostException uhe) {
                TestUtil.logMsg((String)"[AbstractUrlClient][WARNING] Unable to obtain local host information.");
            }
        }
    }

    protected String getAbsoluteUrl() {
        return this.getAbsoluteUrl(null);
    }

    protected String getAbsoluteUrl(String method) {
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(this._hostname).append(":").append(this._port).append(this.getContextRoot());
        if (method != null) {
            sb.append(SL).append(method);
        }
        return sb.toString();
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = -1574745208867827913L;
        public Throwable t;

        public Fault(String msg) {
            super(msg);
            TestUtil.logErr((String)msg);
        }

        public Fault(String msg, Throwable t) {
            super(msg);
            this.t = t;
            TestUtil.logErr((String)msg, (Throwable)t);
        }

        public Fault(Throwable t) {
            super(t);
            this.t = t;
        }

        @Override
        public void printStackTrace() {
            if (this.t != null) {
                this.t.printStackTrace();
            } else {
                super.printStackTrace();
            }
        }

        @Override
        public void printStackTrace(PrintStream s) {
            if (this.t != null) {
                this.t.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            if (this.t != null) {
                this.t.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public Throwable getCause() {
            return this.t;
        }

        @Override
        public synchronized Throwable initCause(Throwable cause) {
            if (this.t != null) {
                throw new IllegalStateException("Can't overwrite cause");
            }
            if (!Exception.class.isInstance(cause)) {
                throw new IllegalArgumentException("Cause not permitted");
            }
            this.t = cause;
            return this;
        }
    }

    protected static enum Property {
        APITEST,
        BASIC_AUTH_PASSWD,
        BASIC_AUTH_REALM,
        BASIC_AUTH_USER,
        CONTENT,
        DONOTUSEServletName,
        EXPECT_RESPONSE_BODY,
        EXPECTED_HEADERS,
        FOLLOW_REDIRECT,
        GOLDENFILE,
        IGNORE_BODY,
        IGNORE_STATUS_CODE,
        REASON_PHRASE,
        REQUEST,
        REQUEST_HEADERS,
        RESPONSE_MATCH,
        SAVE_STATE,
        SEARCH_STRING,
        SEARCH_STRING_IGNORE_CASE,
        STANDARD,
        STATUS_CODE,
        STRATEGY,
        TEST_NAME,
        UNEXPECTED_HEADERS,
        UNEXPECTED_RESPONSE_MATCH,
        UNORDERED_SEARCH_STRING,
        USE_SAVED_STATE;

    }

    protected static enum Request {
        GET,
        PUT,
        POST,
        HEAD,
        OPTIONS,
        DELETE,
        TRACE;

    }
}

