/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.prepStmt.prepStmt5;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class prepStmtClient5
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.prepStmt.prepStmt5";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private PreparedStatement pstmt = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private Properties props = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        prepStmtClient5 theTests = new prepStmtClient5();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                this.props = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.rsSch = new rsSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception: : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull12() throws Exception {
        String rStringVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Varchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, 12);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getString(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("set Null Method does not set the designated parameter to a SQL Null ", "Call to setNull Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull13() throws Exception {
        String rStringVal = null;
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Longvarchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, -1);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getString(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("set Null Method does not set the designated parameter to a SQL Null ", "Call to setNull Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull14() throws Exception {
        float rFloatVal = 0.0f;
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Real_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, 7);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Real_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rFloatVal = this.rs.getFloat(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("set Null Method does not set the designated parameter to a SQL Null ", "Call to setNull Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull15() throws Exception {
        BigDecimal rBigDecimalVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Decimal_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, 3);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Decimal_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rBigDecimalVal = this.rs.getBigDecimal(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("set Null Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull16() throws Exception {
        byte[] retByteArr = null;
        String binarySize = null;
        try {
            this.rsSch.createTab("Binary_Tab", this.sqlp, this.conn);
            binarySize = this.props.getProperty("binarySize");
            this.msg.setMsg("Binary Table Size : " + binarySize);
            String sPrepStmt = this.sqlp.getProperty("Binary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            int bytearrsize = Integer.parseInt(binarySize);
            this.msg.setMsg("Binary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setBytes(1, bytearr);
            this.pstmt.executeUpdate();
            this.pstmt.setNull(1, -2);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Binary_Val_Query = this.sqlp.getProperty("Binary_Query_Val", "");
            this.msg.setMsg(Binary_Val_Query);
            this.rs = this.stmt.executeQuery(Binary_Val_Query);
            this.rs.next();
            retByteArr = this.rs.getBytes(1);
            if (retByteArr == null) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null ");
            } else {
                this.msg.printTestError("set Null Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Binary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull17() throws Exception {
        byte[] retByteArr = null;
        String varbinarySize = null;
        try {
            this.rsSch.createTab("Varbinary_Tab", this.sqlp, this.conn);
            varbinarySize = this.props.getProperty("varbinarySize");
            this.msg.setMsg("Varbinary Table Size : " + varbinarySize);
            String sPrepStmt = this.sqlp.getProperty("Varbinary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            int bytearrsize = Integer.parseInt(varbinarySize);
            this.msg.setMsg("Varbinary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setBytes(1, bytearr);
            this.pstmt.executeUpdate();
            this.pstmt.setNull(1, -3);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Varbinary_Val_Query = this.sqlp.getProperty("Varbinary_Query_Val", "");
            this.msg.setMsg(Varbinary_Val_Query);
            this.rs = this.stmt.executeQuery(Varbinary_Val_Query);
            this.rs.next();
            retByteArr = this.rs.getBytes(1);
            if (retByteArr == null) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null ");
            } else {
                this.msg.printTestError("set Null Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Varbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull18() throws Exception {
        byte[] retByteArr = null;
        boolean byteArrFlag = false;
        try {
            this.rsSch.createTab("Longvarbinary_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Longvarbinary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            String binsize = this.props.getProperty("longvarbinarySize");
            int bytearrsize = Integer.parseInt(binsize);
            this.msg.setMsg("Longvarbinary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setBytes(1, bytearr);
            this.pstmt.executeUpdate();
            this.pstmt.setNull(1, -4);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Longvarbinary_Val_Query = this.sqlp.getProperty("Longvarbinary_Query_Val", "");
            this.msg.setMsg(Longvarbinary_Val_Query);
            this.rs = this.stmt.executeQuery(Longvarbinary_Val_Query);
            this.rs.next();
            retByteArr = this.rs.getBytes(1);
            if (retByteArr == null) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null ");
            } else {
                this.msg.printTestError("set Null Method does not set the designated parameter to a SQL Null ", "Call to setNull Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Longvarbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject30() throws Exception {
        Integer maxTinyintVal = null;
        String maxStringVal = null;
        Object rTinyintVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Tinyint_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Tinyint to be Updated");
            smaxStringVal = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            maxStringVal = new String(smaxStringVal);
            maxTinyintVal = new Integer(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxStringVal, -6);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Tinyint_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orTinyintVal = this.rs.getObject(1);
            this.msg.addOutputMsg(smaxStringVal, orTinyintVal.toString());
            if (orTinyintVal.toString().trim().equals(smaxStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("set Object Method does not set the designated parameter with the Object", "Call to setObject Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject31() throws Exception {
        Integer minTinyintVal = null;
        String minStringVal = null;
        Object rTinyintVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Tinyint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Tinyint to be Updated ");
            sminStringVal = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            minStringVal = new String(sminStringVal);
            minTinyintVal = new Integer(minStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minStringVal, -6);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Tinyint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orTinyintVal = this.rs.getObject(1);
            this.msg.addOutputMsg(sminStringVal, orTinyintVal.toString());
            if (orTinyintVal.toString().trim().equals(sminStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("set Object Method does not set the designated parameter with the Object", "Call to setObject Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject32() throws Exception {
        Integer maxSmallintVal = null;
        String maxStringVal = null;
        Object rSmallintVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Smallint_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Smallint to be Updated");
            smaxStringVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            maxStringVal = new String(smaxStringVal);
            maxSmallintVal = new Integer(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxStringVal, 5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Smallint_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orSmallintVal = this.rs.getObject(1);
            this.msg.addOutputMsg(smaxStringVal, orSmallintVal.toString());
            if (orSmallintVal.toString().trim().equals(smaxStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("set Object Method does not set the designated parameter with the Object", "Call to setObject Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject33() throws Exception {
        Integer minSmallintVal = null;
        String minStringVal = null;
        Object rSmallintVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Smallint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Smallint to be Updated ");
            sminStringVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            minStringVal = new String(sminStringVal);
            minSmallintVal = new Integer(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minStringVal, 5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Smallint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orSmallintVal = this.rs.getObject(1);
            this.msg.addOutputMsg(sminStringVal, orSmallintVal.toString());
            if (orSmallintVal.toString().trim().equals(sminStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("set Object Method does not set the designated parameter with the Object", "Call to setObject Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject34() throws Exception {
        Integer maxIntegerVal = null;
        String maxStringVal = null;
        Object rIntegerVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Integer_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Integer to be Updated");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxStringVal = new String(smaxStringVal);
            maxIntegerVal = new Integer(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxStringVal, 4);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Integer_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orIntegerVal = this.rs.getObject(1);
            this.msg.addOutputMsg(smaxStringVal, orIntegerVal.toString());
            if (orIntegerVal.toString().trim().equals(smaxStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("set Object Method does not set the designated parameter with the Object", "Call to setObject Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject35() throws Exception {
        Integer minIntegerVal = null;
        String minStringVal = null;
        Object rIntegerVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Integer_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Integer to be Updated");
            sminStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minStringVal = new String(sminStringVal);
            minIntegerVal = new Integer(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minStringVal, 4);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Integer_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orIntegerVal = this.rs.getObject(1);
            this.msg.addOutputMsg(sminStringVal, orIntegerVal.toString());
            if (orIntegerVal.toString().trim().equals(sminStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("set Object Method does not set the designated parameter", "Call to setObject Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject36() throws Exception {
        Long maxBigintVal = null;
        String maxStringVal = null;
        Object rBigintVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Bigint_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Bigint to be Updated");
            smaxStringVal = this.rsSch.extractVal("Bigint_Tab", 1, this.sqlp, this.conn);
            maxStringVal = new String(smaxStringVal);
            maxBigintVal = new Long(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxStringVal, -5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Bigint_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orBigintVal = this.rs.getObject(1);
            this.msg.addOutputMsg(smaxStringVal, orBigintVal.toString());
            if (orBigintVal.toString().trim().equals(smaxStringVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("set Object Method does not set the designated parameter with the Object", "Call to setObject Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject37() throws Exception {
        Long minBigintVal = null;
        String minStringVal = null;
        Object rBigintVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Bigint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Bigint to be Updated ");
            sminStringVal = this.rsSch.extractVal("Bigint_Tab", 2, this.sqlp, this.conn);
            minStringVal = new String(sminStringVal);
            minBigintVal = new Long(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minStringVal, -5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Bigint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orBigintVal = this.rs.getObject(1);
            this.msg.addOutputMsg(sminStringVal, orBigintVal.toString());
            if (orBigintVal.toString().trim().equals(sminStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("set Object Method does not set the designated parameter with the Object", "Call to setObject Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject38() throws Exception {
        Float maxRealVal = null;
        String maxStringVal = null;
        Float rRealVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Real_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Real to be Updated ");
            smaxStringVal = this.rsSch.extractVal("Real_Tab", 1, this.sqlp, this.conn);
            maxStringVal = new String(smaxStringVal);
            maxRealVal = new Float(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxStringVal, 7);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Real_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orRealVal = this.rs.getObject(1);
            rRealVal = new Float(orRealVal.toString());
            this.msg.addOutputMsg("" + maxRealVal, "" + rRealVal);
            if (rRealVal.equals(maxRealVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("set Object Method does not set the designated parameter with the Object", "Call to setObject Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject39() throws Exception {
        Float minRealVal = null;
        String minStringVal = null;
        Float rRealVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Real_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Real to be Updated ");
            sminStringVal = this.rsSch.extractVal("Real_Tab", 2, this.sqlp, this.conn);
            minStringVal = new String(sminStringVal);
            minRealVal = new Float(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minStringVal, 7);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Real_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orRealVal = this.rs.getObject(1);
            rRealVal = new Float(orRealVal.toString());
            this.msg.addOutputMsg("" + minRealVal, "" + rRealVal);
            if (rRealVal.equals(minRealVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("set Object Method does not set the designated parameter with the Object", "Call to setObject Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject40() throws Exception {
        Double maxFloatVal = null;
        String maxStringVal = null;
        Double rFloatVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Float_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Float to be Updated ");
            smaxStringVal = this.rsSch.extractVal("Float_Tab", 1, this.sqlp, this.conn);
            maxStringVal = new String(smaxStringVal);
            maxFloatVal = new Double(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxStringVal, 6);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Float_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orFloatVal = this.rs.getObject(1);
            rFloatVal = new Double(orFloatVal.toString());
            this.msg.addOutputMsg("" + maxFloatVal, "" + rFloatVal);
            if (rFloatVal.equals(maxFloatVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("set Object Method does not set the designated parameter with the Object", "Call to setObject Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject41() throws Exception {
        Double minFloatVal = null;
        String minStringVal = null;
        Double rFloatVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Float_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Float to be Updated ");
            sminStringVal = this.rsSch.extractVal("Float_Tab", 2, this.sqlp, this.conn);
            minStringVal = new String(sminStringVal);
            minFloatVal = new Double(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minStringVal, 6);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Float_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rFloatVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minFloatVal, "" + rFloatVal);
            if (rFloatVal.equals(minFloatVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("set Object Method does not set the designated parameter with the Object", "Call to setObject Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject42() throws Exception {
        Double maxDoubleVal = null;
        String maxStringVal = null;
        Double rDoubleVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Double_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Double to be Updated");
            smaxStringVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            maxStringVal = new String(smaxStringVal);
            maxDoubleVal = new Double(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxStringVal, 8);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Double_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            rDoubleVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(maxDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("set Object Method does not set the designated parameter with the Object", "Call to setObject Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

