/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.websocketmessage;

import com.sun.ts.tests.websocket.common.client.EndpointCallback;
import com.sun.ts.tests.websocket.common.client.SendMessageCallback;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.StringPongMessage;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Session;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 932557106496525508L;
    static final String ECHO = "Echo message to be sent to server endpoint";
    static final String[] TEXT_PRIMITIVE_SEQUENCE = new String[]{"byte", "short", "int", "long", "double", "float"};
    static final String[] TEXT_TYPE_SEQUENCE = new String[]{"string", "reader", "textdecoder", "textstreamdecoder"};
    static final String[] BINARY_SEQUENCE = new String[]{"bytearray", "bytebuffer", "inputstream", "binarydecoder", "binarystreamdecoder"};

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ws_ee_websocketmessage_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.websocketmessage"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public static int getIndex(String item) {
        for (int i = 0; i != TEXT_PRIMITIVE_SEQUENCE.length; ++i) {
            if (!TEXT_PRIMITIVE_SEQUENCE[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("ws_ee_websocketmessage_web");
    }

    @Test
    public void echoStringTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"string"}));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.invoke();
    }

    @Test
    public void echoIntTest() throws Exception {
        int entity = Integer.MIN_VALUE;
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"primitiveint"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoByteTest() throws Exception {
        byte entity = 123;
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"primitivebyte"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoCharTest() throws Exception {
        char entity = 'E';
        this.setEntity(new Object[]{Character.valueOf(entity)});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"primitivechar"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity) + "char");
        this.invoke();
    }

    @Test
    public void echoBooleanTest() throws Exception {
        boolean entity = true;
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"primitiveboolean"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoShortTest() throws Exception {
        short entity = -32100;
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"primitiveshort"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoDoubleTest() throws Exception {
        double entity = -1.234567888E7;
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"primitivedouble"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoFloatTest() throws Exception {
        float entity = -1.2345679E7f;
        this.setEntity(new Object[]{Float.valueOf(entity)});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"primitivefloat"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoLongTest() throws Exception {
        long entity = Long.MIN_VALUE;
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"primitivelong"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoFullIntTest() throws Exception {
        Integer entity = Integer.MIN_VALUE;
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"fullint"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoFullByteTest() throws Exception {
        Byte entity = -128;
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"fullbyte"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoFullCharTest() throws Exception {
        Character entity = Character.valueOf('E');
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"fullchar"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoFullBooleanTest() throws Exception {
        Boolean entity = true;
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"fullboolean"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoFullShortTest() throws Exception {
        Short entity = Short.MAX_VALUE;
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"fullshort"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoFullDoubleTest() throws Exception {
        Double entity = Double.MIN_VALUE;
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"fulldouble"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoFullFloatTest() throws Exception {
        Float entity = Float.valueOf(Float.MAX_VALUE);
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"fullfloat"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void echoFullLongTest() throws Exception {
        Long entity = Long.MAX_VALUE;
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"fulllong"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, String.valueOf(entity));
        this.invoke();
    }

    @Test
    public void byteToTextsTest() throws Exception {
        byte entity = 123;
        this.setEntity(new Object[]{entity});
        int index = WSClientIT.getIndex("byte");
        this.invokeTextSequences(index + 1, String.valueOf(entity));
        this.invokeTextSequencesWithPathParam(index, String.valueOf(entity), "101");
    }

    @Test
    public void shortToTextsTest() throws Exception {
        short entity = Short.MAX_VALUE;
        this.setEntity(new Object[]{entity});
        int index = WSClientIT.getIndex("short");
        this.invokeTextSequences(index + 1, String.valueOf(entity));
        this.invokeTextSequencesWithPathParam(index, String.valueOf(entity), "1001");
    }

    @Test
    public void intToTextsTest() throws Exception {
        int entity = Short.MAX_VALUE;
        this.setEntity(new Object[]{entity});
        int index = WSClientIT.getIndex("int");
        this.invokeTextSequences(index + 1, String.valueOf(entity));
        this.invokeTextSequencesWithPathParam(index, String.valueOf(entity), "100001");
    }

    @Test
    public void longToTextsTest() throws Exception {
        long entity = -32768L;
        this.setEntity(new Object[]{entity});
        int index = WSClientIT.getIndex("long");
        this.invokeTextSequences(index + 1, String.valueOf(entity));
        this.invokeTextSequencesWithPathParam(index, String.valueOf(entity), "100001");
    }

    @Test
    public void floatToTextsTest() throws Exception {
        float entity = Float.MIN_VALUE;
        this.setEntity(new Object[]{Float.valueOf(entity)});
        int index = WSClientIT.getIndex("float");
        this.invokeTextSequences(index + 1, String.valueOf(entity));
        this.invokeTextSequencesWithPathParam(index, String.valueOf(entity), String.valueOf(101.101f));
    }

    @Test
    public void doubleToTextsTest() throws Exception {
        double entity = Double.MAX_VALUE;
        this.setEntity(new Object[]{entity});
        this.invokeSequence(0, String.valueOf(entity), "", "", TEXT_TYPE_SEQUENCE);
        this.invokeSequence(0, String.valueOf(entity), "", "session", TEXT_TYPE_SEQUENCE);
        String pathParam = String.valueOf(101.101);
        this.invokeSequence(0, String.valueOf(entity) + pathParam, "", "pathparam/" + pathParam, TEXT_TYPE_SEQUENCE);
        this.invokeSequence(0, String.valueOf(entity) + pathParam, "", "sessionpathparam/" + pathParam, TEXT_TYPE_SEQUENCE);
    }

    @Test
    public void stringToTextsTest() throws Exception {
        String param = "StringParam";
        this.setEntity(new Object[]{ECHO});
        this.invokeSequence(0, ECHO, "", "", TEXT_TYPE_SEQUENCE);
        this.invokeSequence(0, ECHO, "", "session", TEXT_TYPE_SEQUENCE);
        this.invokeSequence(0, ECHO + param, "", "pathparam/" + param, TEXT_TYPE_SEQUENCE);
        this.invokeSequence(0, ECHO + param, "", "sessionpathparam/" + param, TEXT_TYPE_SEQUENCE);
    }

    @Test
    public void stringToAllNumbersTest() throws Exception {
        String entity = String.valueOf(127);
        String param = "111";
        this.setEntity(new Object[]{entity});
        this.invokeSequence(0, String.valueOf(entity), "primitive", "", TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(0, String.valueOf(entity), "full", "", TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(0, String.valueOf(entity), "primitive", "session", TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(0, String.valueOf(entity), "full", "session", TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(0, String.valueOf(entity) + param, "primitive", "pathparam/" + param, TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(0, String.valueOf(entity) + param, "full", "pathparam/" + param, TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(0, String.valueOf(entity) + param, "primitive", "sessionpathparam/" + param, TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(0, String.valueOf(entity) + param, "full", "sessionpathparam/" + param, TEXT_PRIMITIVE_SEQUENCE);
    }

    @Test
    public void booleanToBooleanWithPathParamTest() throws Exception {
        boolean entity = true;
        String[] SEQUENCE = new String[]{"primitiveboolean", "fullboolean"};
        this.setEntity(new Object[]{entity});
        this.invokeSequence(0, "true", "", "", SEQUENCE);
        this.invokeSequence(0, "true", "", "session", SEQUENCE);
        this.invokeSequence(0, "truefalse", "", "pathparam/false", SEQUENCE);
        this.invokeSequence(0, "truefalse", "", "sessionpathparam/false", SEQUENCE);
    }

    @Test
    public void stringToBooleanTest() throws Exception {
        String entity = "true";
        String[] SEQUENCE = new String[]{"primitiveboolean", "fullboolean"};
        this.setEntity(new Object[]{entity});
        this.invokeSequence(0, entity, "", "", SEQUENCE);
        this.invokeSequence(0, entity, "", "session", SEQUENCE);
        this.invokeSequence(0, "truefalse", "", "pathparam/false", SEQUENCE);
        this.invokeSequence(0, "truefalse", "", "sessionpathparam/false", SEQUENCE);
    }

    @Test
    public void stringToCharTest() throws Exception {
        String entity = "&";
        String[] SEQUENCE = new String[]{"primitivechar", "fullchar"};
        this.setEntity(new Object[]{entity});
        this.invokeSequence(0, entity, "", "", SEQUENCE);
        this.invokeSequence(0, entity, "", "session", SEQUENCE);
        this.invokeSequence(0, entity + "X", "", "pathparam/X", SEQUENCE);
        this.invokeSequence(0, entity + "y", "", "sessionpathparam/y", SEQUENCE);
    }

    @Test
    public void charToTextsTest() throws Exception {
        char entity = '1';
        this.setEntity(new Object[]{Character.valueOf(entity)});
        this.invokeTextSequences(0, String.valueOf(entity));
        this.invokeTextSequencesWithPathParam(0, String.valueOf(entity), "99");
    }

    @Test
    public void partialStringTest() throws Exception {
        this.setCountDownLatchCount(2);
        String partial2 = "partialStringTest";
        String response = "Echo message to be sent to server endpoint(false)" + partial2 + "(true)";
        this.setEntity(new Object[]{ECHO, partial2});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"partialstring"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, response);
        this.invoke();
    }

    @Test
    public void partialStringAndSessionTest() throws Exception {
        String partial2 = "partialStringAndSessionTest";
        String response = "Echo message to be sent to server endpoint(false)" + partial2 + "(true)";
        this.setEntity(new Object[]{ECHO, partial2});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"partialstringsession"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, response);
        this.invoke();
    }

    @Test
    public void partialStringWithPathParamTest() throws Exception {
        this.setCountDownLatchCount(2);
        String partial2 = "partialStringTest";
        String response = "Echo message to be sent to server endpoint(false)" + partial2 + partial2 + "(true)" + partial2;
        this.setEntity(new Object[]{ECHO, partial2});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"partialstringpathparam/" + partial2}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, response);
        this.invoke();
    }

    @Test
    public void partialStringAndSessionWithPathParamTest() throws Exception {
        String partial2 = "partialStringAndSessionTest";
        String response = "Echo message to be sent to server endpoint(false)" + partial2 + partial2 + "(true)" + partial2;
        this.setEntity(new Object[]{ECHO, partial2});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"partialstringsessionpathparam/" + partial2}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, response);
        this.invoke();
    }

    @Test
    public void echoByteBufferTest() throws Exception {
        this.setEntity(new Object[]{ByteBuffer.wrap(ECHO.getBytes())});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"bytebuffer"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.invoke();
    }

    @Test
    public void byteBufferToBytesTest() throws Exception {
        this.setEntity(new Object[]{ByteBuffer.wrap(ECHO.getBytes())});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"bytearray"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.invoke();
    }

    @Test
    public void byteBufferToBinaryTest() throws Exception {
        String param = "byteBufferToBinaryTest";
        this.setEntity(new Object[]{ByteBuffer.wrap(ECHO.getBytes())});
        this.invokeSequence(0, ECHO, "", "", BINARY_SEQUENCE);
        this.invokeSequence(0, ECHO, "", "session", BINARY_SEQUENCE);
        this.invokeSequence(0, ECHO + param, "", "pathparam/" + param, BINARY_SEQUENCE);
        this.invokeSequence(0, ECHO + param, "", "sessionpathparam/" + param, BINARY_SEQUENCE);
    }

    @Test
    public void pongToPongTest() throws Exception {
        this.setEntity(new Object[]{new StringPongMessage(ECHO)});
        String[] sequence = new String[]{"pongmessage", "pongmessagesession"};
        this.invokeSequence(0, ECHO, "", "", sequence);
        String[] paramsequence = new String[]{"pongmessagepathparam/param", "pongmessagesessionpathparam/param"};
        this.invokeSequence(0, "Echo message to be sent to server endpointparam", "", "", paramsequence);
    }

    @Test
    public void partialByteArrayTest() throws Exception {
        this.setCountDownLatchCount(2);
        String partial2 = "partialByteArrayTest";
        String response = "Echo message to be sent to server endpoint(false)" + partial2 + "(true)";
        this.setEntity(new Object[]{ByteBuffer.wrap(ECHO.getBytes()), ByteBuffer.wrap(partial2.getBytes())});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"partialbytearray"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, response);
        this.invoke();
    }

    @Test
    public void partialByteArrayAndSessionTest() throws Exception {
        String partial2 = "partialByteArrayAndSessionTest";
        String response = "Echo message to be sent to server endpoint(false)" + partial2 + "(true)";
        this.setEntity(new Object[]{ByteBuffer.wrap(ECHO.getBytes()), ByteBuffer.wrap(partial2.getBytes())});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"partialbytearraysession"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, response);
        this.invoke();
    }

    @Test
    public void partialByteArrayWithPathParamTest() throws Exception {
        this.setCountDownLatchCount(2);
        String partial2 = "partialByteArrayWithPathParamTest";
        String response = "Echo message to be sent to server endpoint(false)[" + partial2 + "]" + partial2 + "(true)[" + partial2 + "]";
        this.setEntity(new Object[]{ByteBuffer.wrap(ECHO.getBytes()), ByteBuffer.wrap(partial2.getBytes())});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"partialbytearraypathparam/" + partial2}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, response);
        this.invoke();
    }

    @Test
    public void partialByteArrayAndSessionWithPathParamTest() throws Exception {
        String partial2 = "partialByteArrayAndSessionWithPathParamTest";
        String response = "Echo message to be sent to server endpoint(false)[" + partial2 + "]" + partial2 + "(true)[" + partial2 + "]";
        this.setEntity(new Object[]{ByteBuffer.wrap(ECHO.getBytes()), ByteBuffer.wrap(partial2.getBytes())});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"partialbytearraysessionpathparam/" + partial2}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, response);
        this.invoke();
    }

    @Test
    public void partialByteBufferTest() throws Exception {
        this.setCountDownLatchCount(2);
        String partial2 = "partialByteBufferTest";
        String response = "Echo message to be sent to server endpoint(false)" + partial2 + "(true)";
        this.setEntity(new Object[]{ByteBuffer.wrap(ECHO.getBytes()), ByteBuffer.wrap(partial2.getBytes())});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"partialbytebuffer"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, response);
        this.invoke();
    }

    @Test
    public void partialByteBufferAndSessionTest() throws Exception {
        String partial2 = "partialByteBufferAndSessionTest";
        String response = "Echo message to be sent to server endpoint(false)" + partial2 + "(true)";
        this.setEntity(new Object[]{ByteBuffer.wrap(ECHO.getBytes()), ByteBuffer.wrap(partial2.getBytes())});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"partialbytebuffersession"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, response);
        this.invoke();
    }

    @Test
    public void partialByteBufferWithPathParamTest() throws Exception {
        this.setCountDownLatchCount(2);
        String partial2 = "partialByteBufferWithPathParamTest";
        String response = "Echo message to be sent to server endpoint(false)[" + partial2 + "]" + partial2 + "(true)[" + partial2 + "]";
        this.setEntity(new Object[]{ByteBuffer.wrap(ECHO.getBytes()), ByteBuffer.wrap(partial2.getBytes())});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"partialbytebufferpathparam/" + partial2}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, response);
        this.invoke();
    }

    @Test
    public void partialByteBufferAndSessionWithPathParamTest() throws Exception {
        String partial2 = "partialByteBufferAndSessionWithPathParamTest";
        String response = "Echo message to be sent to server endpoint(false)[" + partial2 + "]" + partial2 + "(true)[" + partial2 + "]";
        this.setEntity(new Object[]{ByteBuffer.wrap(ECHO.getBytes()), ByteBuffer.wrap(partial2.getBytes())});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"partialbytebuffersessionpathparam/" + partial2}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, response);
        this.invoke();
    }

    @Test
    public void maxLengthOKTest() throws Exception {
        String entity = "12345";
        this.setEntity(new Object[]{entity});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"maxlen"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, entity);
        this.invoke();
    }

    @Test
    public void maxLengthFailsTest() throws Exception {
        final AtomicInteger ai = new AtomicInteger(0);
        this.setEntity(new Object[]{"123456"});
        SendMessageCallback callback = new SendMessageCallback(this.entity){

            public void onClose(Session session, CloseReason closeReason) {
                ai.set(closeReason.getCloseCode().getCode());
                this.getCountDownLatch().countDown();
            }
        };
        this.setClientCallback((EndpointCallback)callback);
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"maxlen"}));
        this.invoke(false);
        WSClientIT.assertEqualsInt((int)1009, (int)ai.get(), (Object[])new Object[]{"Unexpected close reason found", ai.get()});
        WSClientIT.logMsg((Object[])new Object[]{"Found expected close reason code", 1009});
    }

    @Test
    public void defaultMaxLengthTest() throws Exception {
        this.setEntity(new Object[]{"123456789"});
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"defaultmaxlen"}));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "-1");
        this.invoke();
    }

    private void invokeSequence(int startIndex, String search, String prefix, String suffix, String[] sequence) throws Exception {
        for (int i = startIndex; i != sequence.length; ++i) {
            this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{prefix, sequence[i], suffix}));
            this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, search);
            this.invoke();
        }
    }

    private void invokeTextSequences(int startIndex, String search) throws Exception {
        this.invokeSequence(startIndex, search, "primitive", "", TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(startIndex, search, "full", "", TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(0, search, "", "", TEXT_TYPE_SEQUENCE);
        this.invokeSequence(startIndex, search, "primitive", "session", TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(startIndex, search, "full", "session", TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(0, search, "", "session", TEXT_TYPE_SEQUENCE);
    }

    private void invokeTextSequencesWithPathParam(int startIndex, String content, String pathParam) throws Exception {
        String suffix = "pathparam/" + pathParam;
        String search = content + pathParam;
        this.invokeSequence(startIndex, search, "primitive", suffix, TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(startIndex, search, "full", suffix, TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(0, search, "", suffix, TEXT_TYPE_SEQUENCE);
        this.invokeSequence(startIndex, search, "primitive", "session" + suffix, TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(startIndex, search, "full", "session" + suffix, TEXT_PRIMITIVE_SEQUENCE);
        this.invokeSequence(0, search, "", "session" + suffix, TEXT_TYPE_SEQUENCE);
    }
}

