/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import edu.uci.ics.jung.graph.UndirectedGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BicomponentClusterer<V, E>
implements Transformer<UndirectedGraph<V, E>, Set<Set<V>>> {
    protected Map<V, Number> dfs_num;
    protected Map<V, Number> high;
    protected Map<V, V> parents;
    protected Stack<E> stack;
    protected int converse_depth;

    public Set<Set<V>> transform(UndirectedGraph<V, E> theGraph) {
        LinkedHashSet<Set<V>> bicomponents = new LinkedHashSet<Set<V>>();
        if (theGraph.getVertices().isEmpty()) {
            return bicomponents;
        }
        this.dfs_num = new HashMap<V, Number>();
        for (Object v : theGraph.getVertices()) {
            this.dfs_num.put((Number)v, 0);
        }
        for (Object v : theGraph.getVertices()) {
            if (this.dfs_num.get(v).intValue() != 0) continue;
            this.high = new HashMap<V, Number>();
            this.stack = new Stack();
            this.parents = new HashMap<V, V>();
            this.converse_depth = theGraph.getVertexCount();
            this.findBiconnectedComponents(theGraph, v, bicomponents);
            if (theGraph.getVertexCount() - this.converse_depth != 1) continue;
            HashSet s = new HashSet();
            s.add(v);
            bicomponents.add(s);
        }
        return bicomponents;
    }

    protected void findBiconnectedComponents(UndirectedGraph<V, E> g, V v, Set<Set<V>> bicomponents) {
        int v_dfs_num = this.converse_depth--;
        this.dfs_num.put((Number)v, v_dfs_num);
        this.high.put((Number)v, v_dfs_num);
        for (V w : g.getNeighbors(v)) {
            int w_dfs_num = this.dfs_num.get(w).intValue();
            Object vw = g.findEdge(v, w);
            if (w_dfs_num == 0) {
                this.parents.put(w, v);
                this.stack.push(vw);
                this.findBiconnectedComponents(g, w, bicomponents);
                int w_high = this.high.get(w).intValue();
                if (w_high <= v_dfs_num) {
                    E e;
                    HashSet bicomponent = new HashSet();
                    do {
                        e = this.stack.pop();
                        bicomponent.addAll(g.getIncidentVertices(e));
                    } while (e != vw);
                    bicomponents.add(bicomponent);
                }
                this.high.put((Number)v, Math.max(w_high, this.high.get(v).intValue()));
                continue;
            }
            if (w == this.parents.get(v)) continue;
            this.high.put((Number)v, Math.max(w_dfs_num, this.high.get(v).intValue()));
        }
    }
}

