/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.buffer.UnboundedFifoBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakComponentClusterer<V, E>
implements Transformer<Graph<V, E>, Set<Set<V>>> {
    public Set<Set<V>> transform(Graph<V, E> graph) {
        HashSet<Set<V>> clusterSet = new HashSet<Set<V>>();
        HashSet unvisitedVertices = new HashSet(graph.getVertices());
        while (!unvisitedVertices.isEmpty()) {
            HashSet<Object> cluster = new HashSet<Object>();
            Object root = unvisitedVertices.iterator().next();
            unvisitedVertices.remove(root);
            cluster.add(root);
            UnboundedFifoBuffer queue = new UnboundedFifoBuffer();
            queue.add(root);
            while (!queue.isEmpty()) {
                Object currentVertex = queue.remove();
                Collection<Object> neighbors = graph.getNeighbors(currentVertex);
                for (Object neighbor : neighbors) {
                    if (!unvisitedVertices.contains(neighbor)) continue;
                    queue.add(neighbor);
                    unvisitedVertices.remove(neighbor);
                    cluster.add(neighbor);
                }
            }
            clusterSet.add(cluster);
        }
        return clusterSet;
    }
}

