/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import edu.uci.ics.jung.algorithms.generators.random.BarabasiAlbertGenerator;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixedRandomGraphGenerator {
    public static <V, E> Graph<V, E> generateMixedRandomGraph(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, Map<E, Number> edge_weight, int num_vertices, Set<V> seedVertices) {
        return MixedRandomGraphGenerator.generateMixedRandomGraph(graphFactory, vertexFactory, edgeFactory, edge_weight, num_vertices, true, seedVertices);
    }

    public static <V, E> Graph<V, E> generateMixedRandomGraph(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, Map<E, Number> edge_weights, int num_vertices, boolean parallel, Set<V> seedVertices) {
        int seed = (int)(Math.random() * 10000.0);
        BarabasiAlbertGenerator<V, E> bag = new BarabasiAlbertGenerator<V, E>(graphFactory, vertexFactory, edgeFactory, 4, 3, seed, seedVertices);
        bag.evolveGraph(num_vertices - 4);
        Object ug = bag.create();
        Graph g = (Graph)graphFactory.create();
        for (Object v : ug.getVertices()) {
            g.addVertex(v);
        }
        for (Object e : ug.getEdges()) {
            Object v1 = ug.getEndpoints(e).getFirst();
            Object v2 = ug.getEndpoints(e).getSecond();
            Object me = edgeFactory.create();
            g.addEdge(me, v1, v2, Math.random() < 0.5 ? EdgeType.DIRECTED : EdgeType.UNDIRECTED);
            edge_weights.put(me, Math.random());
        }
        return g;
    }
}

