/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.inject.Inject;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IPrefixMatcher;
import org.eclipse.xtext.ide.editor.contentassist.IProposalConflictHelper;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class IdeContentProposalCreator {
    @Inject
    private IPrefixMatcher prefixMatcher;
    @Inject
    private IProposalConflictHelper conflictHelper;

    public ContentAssistEntry createProposal(String proposal, ContentAssistContext context) {
        String _prefix = context.getPrefix();
        return this.createProposal(proposal, _prefix, context, null);
    }

    public ContentAssistEntry createProposal(String proposal, ContentAssistContext context, Procedures.Procedure1<? super ContentAssistEntry> init) {
        String _prefix = context.getPrefix();
        return this.createProposal(proposal, _prefix, context, init);
    }

    public ContentAssistEntry createProposal(String proposal, String prefix, ContentAssistContext context, Procedures.Procedure1<? super ContentAssistEntry> init) {
        boolean _isValidProposal = this.isValidProposal(proposal, prefix, context);
        if (_isValidProposal) {
            ContentAssistEntry result = new ContentAssistEntry();
            result.setProposal(proposal);
            result.setPrefix(prefix);
            if (init != null) {
                init.apply((Object)result);
            }
            return result;
        }
        return null;
    }

    public boolean isValidProposal(String proposal, String prefix, ContentAssistContext context) {
        return !StringExtensions.isNullOrEmpty((String)proposal) && this.prefixMatcher.isCandidateMatchingPrefix(proposal, prefix) && !this.conflictHelper.existsConflict(proposal, context);
    }
}

