/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.clustering;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titanium.graph.clustering.BaseCluster;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public class ModuleNameCluster
extends BaseCluster {
    protected static final String ALL = "/";
    protected Set<String> knownNames;
    private boolean checkUnderscore;
    private boolean checkAlternatingCase;
    private int depth;

    public ModuleNameCluster(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> graph) {
        this.moduleGraph = graph;
        this.successful = true;
        this.clusters = new HashSet();
        this.knownNames = new HashSet<String>();
        this.mapNameCluster = new HashMap();
        this.loadSettings();
    }

    private void loadSettings() {
        this.checkUnderscore = Platform.getPreferencesService().getBoolean("org.eclipse.titanium", "Check_Space_In_Name", true, null);
        this.checkAlternatingCase = Platform.getPreferencesService().getBoolean("org.eclipse.titanium", "Check_SmallLarga_Alt_In_Name", false, null);
        this.depth = Platform.getPreferencesService().getInt("org.eclipse.titanium", "Cluster_Split_Depth", 3, null);
    }

    @Override
    public boolean createClusters(IProgressMonitor monitor) {
        IProgressMonitor progress = monitor == null ? new NullProgressMonitor() : monitor;
        progress.beginTask("Creating clusters", 1 + this.moduleGraph.getVertexCount());
        if (!this.checkUnderscore && !this.checkAlternatingCase || this.depth == 0) {
            this.setErronous("Module names will not be split with the current settings.\nPlease visit the 'Clusters' Preference page to correct it.\n");
            return false;
        }
        this.createNames(progress);
        this.fillClusters();
        progress.done();
        if (this.clusters.size() > 1) {
            return true;
        }
        this.setErronous("Less than two clusters were found.\nThe settings might not be correct.");
        return false;
    }

    private void createNames(IProgressMonitor monitor) {
        this.addCluster(ALL);
        for (NodeDescriptor v : this.moduleGraph.getVertices()) {
            String name = v.getDisplayName();
            monitor.subTask("Checking " + name);
            boolean small = false;
            int splits = 0;
            int length = name.length();
            char prev = '0';
            for (int i = 0; i < length && splits < this.depth; ++i) {
                char c = name.charAt(i);
                if (this.checkDash(prev, c)) {
                    this.addSubName(name, i);
                    ++splits;
                }
                if (this.checkAlternatingCase) {
                    if (small && Character.isUpperCase(c)) {
                        this.addSubName(name, i);
                        ++splits;
                    }
                    small = Character.isLowerCase(c);
                }
                prev = c;
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(1);
        }
    }

    private boolean checkDash(char prev, char cur) {
        return this.checkUnderscore && prev != '_' && (cur == '-' || cur == '_');
    }

    private void addSubName(String name, int i) {
        String word = name.substring(0, i);
        this.addCluster(word);
    }

    private void addCluster(String word) {
        if (!this.knownNames.contains(word)) {
            this.knownNames.add(word);
            HashSet cluster = new HashSet();
            this.mapNameCluster.put(word, cluster);
        }
    }

    private void fillClusters() {
        for (NodeDescriptor v : this.moduleGraph.getVertices()) {
            Set cluster;
            String name = v.getDisplayName();
            int length = 0;
            String match = null;
            for (String word : this.knownNames) {
                if (word.length() <= length || !name.startsWith(word)) continue;
                match = word;
                length = word.length();
            }
            if (match == null) {
                cluster = (Set)this.mapNameCluster.get(ALL);
                cluster.add(v);
                v.setCluster(cluster);
                continue;
            }
            cluster = (Set)this.mapNameCluster.get(match);
            cluster.add(v);
            v.setCluster(cluster);
        }
        for (String word : this.knownNames) {
            Set cluster = (Set)this.mapNameCluster.get(word);
            if (cluster.isEmpty()) continue;
            this.clusters.add(cluster);
        }
    }

    @Override
    protected void createGraph() {
        HashSet<String> empty = new HashSet<String>();
        for (String name : this.knownNames) {
            if (!((Set)this.mapNameCluster.get(name)).isEmpty()) continue;
            empty.add(name);
        }
        for (String name : empty) {
            this.mapNameCluster.remove(name);
        }
        super.createGraph();
    }

    @Override
    protected void reportError() {
        this.errorHandler.reportBadSetting("Clustering failure", this.msg, "Open Clustering Preferences", "org.eclipse.titanium.preferences.pages.GraphClusterModuleNamePage");
    }

    @Override
    protected String getType() {
        return "Clustering by module names";
    }
}

