/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.statements.Start_Referenced_Component_Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class UnusedStartedRefFuncRetVal
extends BaseModuleCodeSmellSpotter {
    private static final String PROBLEM = "Return type of function type `{0}'' is `{1}'', which does not have the `done'' extension attibute.When the test component terminates the returnes value cannot be retrived with a `done'' operation";

    public UnusedStartedRefFuncRetVal() {
        super(CodeSmellType.UNUSED_STARTED_FUNCTION_RETURN_VALUES);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (node instanceof Start_Referenced_Component_Statement) {
            CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();
            Start_Referenced_Component_Statement s = (Start_Referenced_Component_Statement)node;
            Value dereferredValue = s.getDereferredValue();
            if (dereferredValue == null) {
                return;
            }
            switch (dereferredValue.getValuetype()) {
                case EXPRESSION_VALUE: {
                    if (!Expression_Value.Operation_type.REFERS_OPERATION.equals((Object)((Expression_Value)dereferredValue).getOperationType())) break;
                    return;
                }
                case TTCN3_NULL_VALUE: 
                case FAT_NULL_VALUE: {
                    return;
                }
            }
            IType type = dereferredValue.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            if (type != null) {
                type = type.getTypeRefdLast(timestamp);
            }
            if (type == null || type.getIsErroneous(timestamp)) {
                return;
            }
            if (!(type instanceof Function_Type)) {
                return;
            }
            Function_Type functionType = (Function_Type)type;
            if (functionType.isRunsOnSelf()) {
                return;
            }
            if (!functionType.isStartable(timestamp)) {
                return;
            }
            Type returnType = functionType.getReturnType();
            if (returnType == null) {
                return;
            }
            if (functionType.returnsTemplate()) {
                return;
            }
            Type lastType = returnType;
            boolean returnTypeCorrect = false;
            while (!returnTypeCorrect) {
                if (lastType.hasDoneAttribute()) {
                    returnTypeCorrect = true;
                    break;
                }
                if (!(lastType instanceof IReferencingType)) break;
                ReferenceChain refChain = ReferenceChain.getInstance((String)"Circular reference chain: `{0}''", (boolean)true);
                IType refd = ((IReferencingType)lastType).getTypeRefd(timestamp, (IReferenceChain)refChain);
                refChain.release();
                if (lastType == refd) break;
                lastType = refd;
            }
            if (!returnTypeCorrect) {
                String msg = MessageFormat.format(PROBLEM, functionType.getTypename(), returnType.getTypename());
                problems.report(dereferredValue.getLocation(), msg);
            }
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(Start_Referenced_Component_Statement.class);
        return ret;
    }
}

