/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.topview;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titanium.Activator;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.topview.Comparator;
import org.eclipse.titanium.metrics.topview.DCListener;
import org.eclipse.titanium.metrics.topview.MetricSelectorDialog;
import org.eclipse.titanium.metrics.utils.ModuleMetricsWrapper;
import org.eclipse.titanium.metrics.utils.WrapperStore;
import org.eclipse.titanium.utils.ProjectAnalyzerJob;
import org.eclipse.ui.part.ViewPart;

public class TopView
extends ViewPart {
    private static final String REFRESH_TOOLTIP = "Start measuring";
    private Composite parent;
    private Table moduleTable;
    private Combo projectSelector;
    private Button refresh;
    private ModuleMetricsWrapper mw;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout());
        Composite head = new Composite(parent, 0);
        this.createHead(head);
        this.createTable(Collections.<IMetricEnum>emptySet());
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    private void createHead(Composite head) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        head.setLayout((Layout)layout);
        GridData g = new GridData(-1, 35);
        g.grabExcessHorizontalSpace = true;
        g.horizontalAlignment = 4;
        head.setLayoutData((Object)g);
        this.projectSelector = new Combo(head, 8);
        for (IProject project : ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            if (!TITANNature.hasTITANNature((IProject)project)) continue;
            this.projectSelector.add(project.getName());
        }
        this.projectSelector.select(0);
        g = new GridData();
        g.horizontalAlignment = 4;
        g.grabExcessHorizontalSpace = true;
        this.projectSelector.setLayoutData((Object)g);
        this.refresh = new Button(head, 0);
        this.refresh.setImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.titanium", (String)"resources/icons/metrics_start_measure.gif").createImage());
        this.refresh.setToolTipText(REFRESH_TOOLTIP);
        this.refresh.setLayoutData((Object)new GridData(-1, 25));
        this.refresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                String selectedProjectName = TopView.this.projectSelector.getText();
                if ("".equals(selectedProjectName)) {
                    return;
                }
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(selectedProjectName);
                if (project != null) {
                    TopView.this.refresh.setEnabled(false);
                    new ProjectAnalyzerJob("Metrics calculations"){
                        private Set<IMetricEnum> metrics;

                        @Override
                        public IStatus doPreWork(IProgressMonitor monitor) {
                            MetricSelectorDialog mst = new MetricSelectorDialog();
                            Display.getDefault().syncExec((Runnable)mst);
                            this.metrics = mst.getUsed();
                            return Status.OK_STATUS;
                        }

                        @Override
                        public IStatus doPostWork(IProgressMonitor monitor) {
                            IStatus iStatus;
                            try {
                                TopView.this.mw = WrapperStore.getWrapper(this.getProject());
                                if (!TopView.this.moduleTable.isDisposed()) {
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            TopView.this.createTable(metrics);
                                        }
                                    });
                                }
                                iStatus = Status.OK_STATUS;
                            }
                            catch (Throwable throwable) {
                                if (!TopView.this.refresh.isDisposed()) {
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            TopView.this.refresh.setEnabled(true);
                                        }
                                    });
                                }
                                throw throwable;
                            }
                            if (!TopView.this.refresh.isDisposed()) {
                                Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                            }
                            return iStatus;
                        }
                    }.quickSchedule(project);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createTable(Set<IMetricEnum> metrics) {
        if (this.moduleTable != null) {
            this.moduleTable.dispose();
        }
        this.moduleTable = new Table(this.parent, 4);
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.moduleTable.setLayoutData((Object)gd);
        if (!metrics.isEmpty()) {
            TableViewer viewer = new TableViewer(this.moduleTable);
            viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            viewer.setInput(this.mw.getMetricData().getModules());
            this.moduleTable.setHeaderVisible(true);
            this.moduleTable.setLinesVisible(true);
            TableViewerColumn names = new TableViewerColumn(viewer, 16384);
            TableColumn namesCol = names.getColumn();
            namesCol.setAlignment(16384);
            namesCol.setText("Modules");
            namesCol.setWidth(250);
            names.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (!(element instanceof Module)) {
                        throw new AssertionError((Object)"Elements of the view should be modules");
                    }
                    Module module = (Module)element;
                    return module.getName();
                }
            });
            for (final IMetricEnum m : metrics) {
                TableViewerColumn cv = new TableViewerColumn(viewer, 0x1000000);
                TableColumn c = cv.getColumn();
                c.setAlignment(0x1000000);
                c.setText("(" + m.groupName() + " metrics)\n" + m.getName());
                c.setWidth(100);
                cv.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public Color getBackground(Object element) {
                        if (!(element instanceof Module)) {
                            throw new AssertionError((Object)"Elements of the view should be modules");
                        }
                        Module module = (Module)element;
                        double risk = TopView.this.mw.getRiskValue(m, module.getName());
                        if (risk < 1.0) {
                            return Display.getCurrent().getSystemColor(5);
                        }
                        if (risk < 2.0) {
                            return Display.getCurrent().getSystemColor(7);
                        }
                        return Display.getCurrent().getSystemColor(3);
                    }

                    public String getText(Object element) {
                        if (!(element instanceof Module)) {
                            throw new AssertionError((Object)"Elements of the view should be  modules");
                        }
                        Module module = (Module)element;
                        Number n = TopView.this.mw.getValue(m, module.getName());
                        return n == null ? "" : n.toString();
                    }
                });
            }
            viewer.addDoubleClickListener((IDoubleClickListener)new DCListener());
            viewer.setComparator((ViewerComparator)new Comparator(this.mw, metrics));
        }
        this.parent.layout();
    }

    public void setSelectedProject(IProject project) {
        String name = project.getName();
        int found = -1;
        for (int index = 0; index < this.projectSelector.getItemCount(); ++index) {
            if (!name.equals(this.projectSelector.getItem(index))) continue;
            found = index;
            break;
        }
        if (found >= 0) {
            this.projectSelector.select(found);
        }
    }

    public void startMeasuring() {
        this.refresh.notifyListeners(13, new Event());
    }
}

