/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.view;

import java.util.ArrayList;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titanium.metrics.AltstepMetric;
import org.eclipse.titanium.metrics.FunctionMetric;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.MetricData;
import org.eclipse.titanium.metrics.ModuleMetric;
import org.eclipse.titanium.metrics.StatColumn;
import org.eclipse.titanium.metrics.Statistics;
import org.eclipse.titanium.metrics.TestcaseMetric;
import org.eclipse.titanium.metrics.utils.RiskLevel;
import org.eclipse.titanium.metrics.view.IContentNode;
import org.eclipse.titanium.metrics.view.IOpenable;
import org.eclipse.titanium.metrics.view.ModuleNode;
import org.eclipse.titanium.metrics.view.ModuleStatNode;

class ProjectStatNode
implements IContentNode {
    private final IMetricEnum metric;
    private boolean initialized;
    private Object[] children;

    public ProjectStatNode(IMetricEnum metric) {
        this.metric = metric;
        this.initialized = false;
    }

    @Override
    public Object[] getChildren(MetricData data) {
        if (this.initialized) {
            return this.children;
        }
        ArrayList<IOpenable> c = new ArrayList<IOpenable>();
        if (this.metric instanceof FunctionMetric || this.metric instanceof AltstepMetric || this.metric instanceof TestcaseMetric) {
            for (Module m : data.getModules()) {
                ModuleStatNode n = new ModuleStatNode(this.metric, m);
                if (!n.hasChildren(data)) continue;
                c.add(n);
            }
        } else if (this.metric instanceof ModuleMetric) {
            for (Module m : data.getModules()) {
                c.add(new ModuleNode((ModuleMetric)this.metric, m));
            }
        } else {
            throw new AssertionError((Object)"ProjectStatNode should have a subProject-metric");
        }
        this.children = c.toArray();
        this.initialized = true;
        return this.children;
    }

    @Override
    public boolean hasChildren(MetricData data) {
        if (!this.initialized) {
            this.getChildren(data);
        }
        return this.children.length != 0;
    }

    @Override
    public RiskLevel getRiskLevel(MetricData data) {
        if (this.metric instanceof AltstepMetric) {
            return data.getRisk((AltstepMetric)this.metric);
        }
        if (this.metric instanceof FunctionMetric) {
            return data.getRisk((FunctionMetric)this.metric);
        }
        if (this.metric instanceof TestcaseMetric) {
            return data.getRisk((TestcaseMetric)this.metric);
        }
        if (this.metric instanceof ModuleMetric) {
            return data.getRisk((ModuleMetric)this.metric);
        }
        throw new IllegalArgumentException(this.metric.getName() + " is not a subproject metric");
    }

    @Override
    public double risk(MetricData data) {
        if (this.metric instanceof AltstepMetric) {
            return data.getRiskValue((AltstepMetric)this.metric);
        }
        if (this.metric instanceof FunctionMetric) {
            return data.getRiskValue((FunctionMetric)this.metric);
        }
        if (this.metric instanceof TestcaseMetric) {
            return data.getRiskValue((TestcaseMetric)this.metric);
        }
        if (this.metric instanceof ModuleMetric) {
            return data.getRiskValue((ModuleMetric)this.metric);
        }
        throw new IllegalArgumentException(this.metric.getName() + " is not a subproject metric");
    }

    @Override
    public String getColumnText(MetricData data, int i) {
        Statistics s;
        if (i == 0) {
            return this.metric.getName();
        }
        StatColumn c = null;
        switch (i) {
            case 1: {
                c = StatColumn.TOTAL;
                break;
            }
            case 2: {
                c = StatColumn.MAX;
                break;
            }
            case 3: {
                c = StatColumn.MEAN;
                break;
            }
            case 4: {
                c = StatColumn.DEV;
                break;
            }
            default: {
                return null;
            }
        }
        if (this.metric instanceof AltstepMetric) {
            s = data.getStatistics((AltstepMetric)this.metric);
        } else if (this.metric instanceof FunctionMetric) {
            s = data.getStatistics((FunctionMetric)this.metric);
        } else if (this.metric instanceof TestcaseMetric) {
            s = data.getStatistics((TestcaseMetric)this.metric);
        } else if (this.metric instanceof ModuleMetric) {
            s = data.getStatistics((ModuleMetric)this.metric);
        } else {
            throw new IllegalArgumentException(this.metric.getName() + " is not a subproject metric");
        }
        Number n = s.get(c);
        return n == null ? null : n.toString();
    }
}

