/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.extractors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.titan.log.viewer.extractors.ComponentEvent;
import org.eclipse.titan.log.viewer.extractors.Extractor;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;

public class ComponentExtractor
extends Extractor {
    private int currentProgress = 0;
    private int currentCompRef;
    private String currentCompName;
    private Map<Integer, String> components = new HashMap<Integer, String>();
    private static final char[] PTC_CREATION = "PTC was created. Component reference: ".toCharArray();
    private static final int PTC_CREATION_LENGTH = PTC_CREATION.length;
    private static final char[] COMP_NAME_START = "component name: ".toCharArray();
    private static final int COMP_NAME_START_LENGTH = COMP_NAME_START.length;
    private static final char[] COMP_NAME_END = ", process id: ".toCharArray();
    private static final char[] COMP_REF_END = ", component type: ".toCharArray();
    private static final char[] ALT_COMP_REF_END = ".".toCharArray();
    private static final char[] TTCN_3_PARALLEL_TEST_COMPONENT_STARTED_ON = "TTCN-3 Parallel Test Component started on ".toCharArray();
    private static final char[] COMP_REF = "Component reference:".toCharArray();
    private static final int COMP_REF_LENGTH = COMP_REF.length;
    private static final char[] TTCN_3_COMP_NAME_END = ". Version: ".toCharArray();
    private static final char[] COMP_TYPE = ", component type:".toCharArray();
    private static final char[] PTC_ALIVE = ", alive:".toCharArray();
    private static final char[] TESTCASE_NAME = ", testcase name:".toCharArray();

    public void extractComponentsFromLogFile(LogFileMetaData logFileMetaData, IProgressMonitor monitor) throws IOException {
        this.extractFromLogFile(logFileMetaData, monitor);
    }

    public List<String> getComponents() {
        ArrayList<String> componentsArray = new ArrayList<String>();
        Set<Integer> keys = this.components.keySet();
        ArrayList<Integer> sortedKeys = new ArrayList<Integer>(keys);
        Collections.sort(sortedKeys);
        for (Integer sortedKey : sortedKeys) {
            String compName = this.components.get(sortedKey);
            if (compName == null || componentsArray.contains(compName)) continue;
            componentsArray.add(compName);
        }
        return componentsArray;
    }

    @Override
    protected void processRow(int offsetStart, int offsetEnd, int recordNumber) throws IOException {
        int compRef;
        int compRefLength;
        this.currentCompRef = 0;
        this.currentCompName = null;
        int pos = this.findPos(PTC_CREATION, offsetStart, offsetEnd);
        if (pos > 0) {
            int compRefStartPos = pos + PTC_CREATION_LENGTH + 1;
            int compName = this.findPos(COMP_NAME_START, offsetStart, offsetEnd);
            if (compName > 0) {
                int compNameStartPos = compName + COMP_NAME_START_LENGTH + 1;
                int compNameLength = this.findPos(TESTCASE_NAME, offsetStart, offsetEnd) + 1 - compNameStartPos;
                if (compNameLength < 0 && (compNameLength = this.findPos(COMP_NAME_END, offsetStart, offsetEnd) + 1 - compNameStartPos) < 0) {
                    return;
                }
                this.currentCompName = new String(this.buffer, compNameStartPos, compNameLength);
                int compRefLength2 = this.findPos(COMP_REF_END, offsetStart, offsetEnd) + 1 - compRefStartPos;
                if (compRefLength2 < 0) {
                    return;
                }
                try {
                    this.currentCompRef = Integer.parseInt(new String(this.buffer, compRefStartPos, compRefLength2));
                }
                catch (NumberFormatException nfe) {
                    return;
                }
            }
            compRefLength = this.findPos(PTC_ALIVE, compRefStartPos, offsetEnd) - compRefStartPos + 1;
            if (compRefLength > 0) {
                this.currentCompName = new String(this.buffer, compRefStartPos, compRefLength);
                try {
                    this.currentCompRef = Integer.parseInt(this.currentCompName);
                }
                catch (NumberFormatException nfe) {
                    return;
                }
            }
            compRefLength = this.findPos(ALT_COMP_REF_END, compRefStartPos, offsetEnd) - compRefStartPos + 1;
            if (compRefLength > 0) {
                this.currentCompName = new String(this.buffer, compRefStartPos, compRefLength);
                try {
                    this.currentCompRef = Integer.parseInt(this.currentCompName);
                }
                catch (NumberFormatException nfe) {
                    return;
                }
            }
        }
        if ((pos = this.findPos(TTCN_3_PARALLEL_TEST_COMPONENT_STARTED_ON, offsetStart, offsetEnd)) > 0 && (compRef = this.findPos(COMP_REF, offsetStart, offsetEnd)) > 0) {
            int compRefStartPos = compRef + COMP_REF_LENGTH + 2;
            compRefLength = this.findPos(COMP_TYPE, offsetStart, offsetEnd) + 1 - compRefStartPos;
            if (compRefLength < 0) {
                return;
            }
            try {
                this.currentCompRef = Integer.parseInt(new String(this.buffer, compRefStartPos, compRefLength));
            }
            catch (NumberFormatException nfe) {
                return;
            }
            int compName = this.findPos(COMP_NAME_START, offsetStart, offsetEnd);
            if (compName > 0) {
                int compNameStartPos = compName + COMP_NAME_START_LENGTH + 1;
                int compNameLength = this.findPos(TTCN_3_COMP_NAME_END, offsetStart, offsetEnd) + 1 - compNameStartPos;
                if (compNameLength < 0) {
                    return;
                }
                this.currentCompName = new String(this.buffer, compNameStartPos, compNameLength);
            } else {
                this.currentCompName = Integer.toString(this.currentCompRef);
            }
        }
        if (this.currentCompRef > 0 && this.currentCompName != null) {
            this.currentProgress = (int)((double)this.filePointer * (100.0 / (double)this.fileSize));
            this.addComponent();
        }
    }

    @Override
    protected void processRowsFinished(int offsetStart, int offsetEnd, int recordNumber) throws IOException {
    }

    private void addComponent() {
        if (this.components.containsKey(this.currentCompRef)) {
            if (this.components.get(this.currentCompRef).contentEquals(String.valueOf(this.currentCompRef))) {
                this.components.put(this.currentCompRef, this.currentCompName);
                this.notifyAddedComponent();
            }
        } else {
            this.components.put(this.currentCompRef, this.currentCompName);
            this.notifyAddedComponent();
        }
    }

    private void notifyAddedComponent() {
        this.setChanged();
        this.notifyObservers(new ComponentEvent(this.currentCompName, this.currentProgress));
    }
}

