/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.readers;

import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.Assert;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.readers.ILogReader;

public class CachedLogReader
implements ILogReader {
    private final ILogReader logReader;
    private LogRecord[] cachedRecords = null;
    private int minIndex = 0;
    private int maxIndex = 0;

    public CachedLogReader(ILogReader logReader) throws IOException {
        Assert.notNull((Object)logReader, (String)"logReader should not be null");
        this.logReader = logReader;
    }

    public void cacheRecords(int minIndex, int maxIndex) throws IOException, ParseException {
        if (this.isCached(minIndex, maxIndex)) {
            return;
        }
        int tempMin = minIndex;
        int tempMax = maxIndex;
        if (tempMax >= this.size()) {
            tempMax = this.size() - 1;
        }
        LogRecord[] newRecords = new LogRecord[tempMax - tempMin + 1];
        if (minIndex > this.minIndex) {
            if (minIndex >= this.maxIndex) {
                tempMin = minIndex;
            } else {
                int temp = tempMin - this.minIndex;
                System.arraycopy(this.cachedRecords, temp, newRecords, 0, this.cachedRecords.length - temp);
                tempMin = this.maxIndex + 1;
            }
        } else if (maxIndex < this.maxIndex) {
            if (maxIndex <= this.minIndex) {
                tempMax = maxIndex;
            } else {
                System.arraycopy(this.cachedRecords, 0, newRecords, tempMax - minIndex - (tempMax - this.minIndex), tempMax - this.minIndex + 1);
                tempMax = this.minIndex - 1;
            }
        }
        this.cachedRecords = newRecords;
        if (tempMin < this.size()) {
            this.fillCache(minIndex, tempMin, tempMax);
        }
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
    }

    private boolean isCached(int minIndex, int maxIndex) {
        return minIndex >= this.minIndex && maxIndex <= this.maxIndex;
    }

    protected void fillCache(int minIndex, int minRecordIndex, int maxRecordIndex) throws IOException, ParseException {
        for (int i = minRecordIndex; i <= maxRecordIndex; ++i) {
            try {
                this.cachedRecords[i - minIndex] = this.logReader.getRecord(i);
                continue;
            }
            catch (ParseException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                this.cachedRecords[i - minIndex] = null;
                ParseException throwable = new ParseException("Could not parse the " + i + "th record ", 0);
                throwable.initCause(e);
                throw throwable;
            }
        }
    }

    @Override
    public LogRecord getRecord(int index) throws IOException, ParseException {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isCached(index)) {
            return this.cachedRecords[index - this.minIndex];
        }
        return this.logReader.getRecord(index);
    }

    @Override
    public int size() {
        return this.logReader.size();
    }

    private boolean isCached(int index) {
        return index >= this.minIndex && index <= this.maxIndex;
    }

    @Override
    public void close() {
        this.logReader.close();
        this.cachedRecords = null;
    }

    @Override
    public LogRecord getRecordById(int id) throws IOException, ParseException {
        if (id < this.cachedRecords[this.minIndex].getRecordNumber() || id > this.cachedRecords[this.maxIndex].getRecordNumber()) {
            return this.logReader.getRecordById(id);
        }
        LogRecord tmp = new LogRecord();
        tmp.setRecordNumber(id);
        int index = Arrays.binarySearch(this.cachedRecords, tmp, new Comparator<LogRecord>(){

            @Override
            public int compare(LogRecord o1, LogRecord o2) {
                return o1.getRecordNumber() - o2.getRecordNumber();
            }
        });
        if (index > 0) {
            return this.cachedRecords[index];
        }
        return null;
    }

    @Override
    public int getPositionFromRecordNumber(int id) {
        return this.logReader.getPositionFromRecordNumber(id);
    }

    @Override
    public boolean contains(int id) {
        return this.logReader.contains(id);
    }
}

