/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.FileUtils;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.extractors.TestCaseExtractor;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.models.LogRecordIndex;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.utils.ActionUtils;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.titan.log.viewer.utils.LogFileHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;

public final class LogFileCacheHandler {
    private static final int LOG_RECORD_INDEX_SIZE = 16;
    private static final int BUFFER_SIZE = 131072;

    private LogFileCacheHandler() {
    }

    public static boolean hasLogFileChanged(IFile logFile) {
        File file = new File(logFile.getLocationURI());
        File propertyFile = LogFileCacheHandler.getPropertyFileForLogFile(logFile);
        if (!propertyFile.exists()) {
            return true;
        }
        if (LogFileCacheHandler.isPropertyFileInvalid(logFile, propertyFile)) {
            return true;
        }
        File indexFile = LogFileCacheHandler.getIndexFileForLogFile(logFile);
        if (!indexFile.exists()) {
            return true;
        }
        File logRecordIndexFile = LogFileCacheHandler.getLogRecordIndexFileForLogFile(logFile);
        if (!logRecordIndexFile.exists()) {
            return true;
        }
        return LogFileCacheHandler.updateNeeded(file, propertyFile);
    }

    private static boolean isPropertyFileInvalid(IFile logFile, File propertyFile) {
        try {
            LogFileMetaData logFileMetaData = LogFileCacheHandler.logFileMetaDataReader(propertyFile);
            String projectName = logFile.getProject().getName();
            String projectRelativePath = File.separator + projectName + File.separator + logFile.getProjectRelativePath().toOSString();
            URI logFilePath = logFile.getLocationURI();
            if (!logFileMetaData.getProjectRelativePath().contentEquals(projectRelativePath) || !logFileMetaData.getFilePath().equals(logFilePath)) {
                return true;
            }
        }
        catch (IOException e) {
            return true;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        return false;
    }

    private static void clearLogFilePropertyFile(IFile logFile) {
        File propertyFile = LogFileCacheHandler.getPropertyFileForLogFile(logFile);
        if (propertyFile.exists()) {
            propertyFile.delete();
        }
    }

    private static void clearLogFileIndexFile(IFile logFile) {
        File indexFile = LogFileCacheHandler.getIndexFileForLogFile(logFile);
        FileUtils.deleteQuietly((File)indexFile);
    }

    private static void clearLogFileLogRecordIndexFile(IFile logFile) {
        File indexFile = LogFileCacheHandler.getLogRecordIndexFileForLogFile(logFile);
        FileUtils.deleteQuietly((File)indexFile);
    }

    public static void clearLogFolderCache(IFolder logFolder) {
        File indexFile = LogFileCacheHandler.getCacheFolderFor(logFolder);
        if (indexFile.exists() && indexFile.isDirectory()) {
            File[] filesInFolder;
            for (File aFilesInFolder : filesInFolder = indexFile.listFiles()) {
                aFilesInFolder.delete();
            }
            FileUtils.deleteQuietly((File)indexFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createIndexFile(File indexFile, List<TestCase> testCaseVector) throws IOException {
        ObjectOutputStream objectFile = null;
        try {
            if (indexFile.exists()) {
                try {
                    indexFile.delete();
                }
                catch (SecurityException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                    throw new IOException(Messages.getString("LogFileCacheHandler.0"));
                }
            }
            indexFile.createNewFile();
            objectFile = new ObjectOutputStream(new FileOutputStream(indexFile));
            objectFile.writeObject(testCaseVector);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(objectFile);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)objectFile);
    }

    public static File getPropertyFileForLogFile(IFile logFile) {
        return new File(LogFileCacheHandler.getPropertyIFileForLogFile(logFile).getLocationURI());
    }

    public static IFile getPropertyIFileForLogFile(IFile logFile) {
        IFolder cacheFolder = LogFileCacheHandler.getCacheFolderFor(logFile);
        String propertyFileName = logFile.getName() + ".property";
        return cacheFolder.getFile(propertyFileName);
    }

    public static File getIndexFileForLogFile(IFile logFile) {
        return new File(LogFileCacheHandler.getIndexIFileForLogFile(logFile).getLocationURI());
    }

    public static IFile getIndexIFileForLogFile(IFile logFile) {
        IFolder cacheFolder = LogFileCacheHandler.getCacheFolderFor(logFile);
        String indexFileName = logFile.getName() + ".index";
        return cacheFolder.getFile(indexFileName);
    }

    public static File getLogRecordIndexFileForLogFile(IFile logFile) {
        return new File(LogFileCacheHandler.getLogRecordIndexIFileForLogFile(logFile).getLocationURI());
    }

    public static IFile getLogRecordIndexIFileForLogFile(IFile logFile) {
        IFolder cacheFolder = LogFileCacheHandler.getCacheFolderFor(logFile);
        String logFileName = logFile.getName() + ".lrindex";
        return cacheFolder.getFile(logFileName);
    }

    private static File getCacheFolderFor(IFolder logFolder) {
        IPath projectRelativePath = Path.fromOSString((String)(".cache" + File.separator + logFolder.getProjectRelativePath().toOSString()));
        IProject project = logFolder.getProject();
        return new File(project.getFolder(projectRelativePath).getLocationURI());
    }

    private static IFolder getCacheFolderFor(IFile logFile) {
        IProject project = logFile.getProject();
        IPath projectRelativePath = Path.fromOSString((String)(".cache" + File.separator + logFile.getProjectRelativePath().removeLastSegments(1).toOSString()));
        return project.getFolder(projectRelativePath);
    }

    private static boolean updateNeeded(File logFile, File propertyFile) {
        LogFileMetaData storedData;
        try {
            storedData = LogFileCacheHandler.logFileMetaDataReader(propertyFile);
        }
        catch (IOException e) {
            return true;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        return !"4.0.0".equals(storedData.getVersion()) || storedData.getSize() != logFile.length() || storedData.getLastModified() != logFile.lastModified();
    }

    private static void createPropertyFile(File propertyFile, LogFileMetaData logFileMetaData) throws IOException {
        if (propertyFile.exists()) {
            try {
                propertyFile.delete();
            }
            catch (SecurityException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                throw new IOException(Messages.getString("LogFileCacheHandler.1"));
            }
        } else {
            propertyFile.getParentFile().mkdirs();
        }
        propertyFile.createNewFile();
        LogFileCacheHandler.logFileMetaDataSerializer(logFileMetaData, propertyFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logFileMetaDataSerializer(LogFileMetaData logFileMetaData, File propertyFile) throws IOException {
        FileOutputStream stream = null;
        ObjectOutputStream objectFile = null;
        try {
            stream = new FileOutputStream(propertyFile);
            objectFile = new ObjectOutputStream(stream);
            objectFile.writeObject(logFileMetaData);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable[])new Closeable[]{stream, objectFile});
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{stream, objectFile});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFileMetaData logFileMetaDataReader(File propertyFile) throws IOException, ClassNotFoundException {
        FileInputStream stream = null;
        LogFileMetaData logFileMetaData = null;
        ObjectInputStream objectFile = null;
        try {
            stream = new FileInputStream(propertyFile);
            objectFile = new ObjectInputStream(stream);
            logFileMetaData = (LogFileMetaData)objectFile.readObject();
        }
        catch (InvalidClassException e) {
            try {
                FileUtils.deleteQuietly((File)propertyFile);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Closeable[])new Closeable[]{stream, objectFile});
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable[])new Closeable[]{stream, objectFile});
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{stream, objectFile});
        return logFileMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogRecordIndex[] readLogRecordIndexFile(File indexFile, int startRecordIndex, int numberOfRecords) throws IOException {
        LogRecordIndex[] logRecordIndexArray;
        int bytesToRead = numberOfRecords * 16;
        ByteBuffer buffer = ByteBuffer.allocateDirect(bytesToRead);
        FileInputStream fileInputStream = new FileInputStream(indexFile);
        FileChannel fileChannel = fileInputStream.getChannel();
        try {
            fileChannel.position((long)startRecordIndex * 16L);
            int bytesRead = fileChannel.read(buffer);
            buffer.rewind();
            LogRecordIndex[] logRecordIndexes = null;
            if (bytesRead == bytesToRead) {
                logRecordIndexes = new LogRecordIndex[numberOfRecords];
                for (int counter = 0; counter < numberOfRecords; ++counter) {
                    logRecordIndexes[counter] = new LogRecordIndex(buffer.getLong(), buffer.getInt(), buffer.getInt());
                }
            }
            logRecordIndexArray = logRecordIndexes;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable[])new Closeable[]{fileChannel, fileInputStream});
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{fileChannel, fileInputStream});
        return logRecordIndexArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLogRecordIndexFile(File indexFile, List<LogRecordIndex> logRecordIndexes) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(131072);
        FileOutputStream fileOutputStream = new FileOutputStream(indexFile);
        FileChannel file = fileOutputStream.getChannel();
        file.truncate(0L);
        try {
            for (LogRecordIndex currLogRecordIndex : logRecordIndexes) {
                buffer.putLong(currLogRecordIndex.getFileOffset());
                buffer.putInt(currLogRecordIndex.getRecordLength());
                buffer.putInt(currLogRecordIndex.getRecordNumber());
                if (buffer.hasRemaining()) continue;
                buffer.rewind();
                file.write(buffer);
                buffer.clear();
            }
            if (buffer.position() != 0) {
                buffer.flip();
                file.write(buffer);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable[])new Closeable[]{file, fileOutputStream});
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{file, fileOutputStream});
    }

    public static int getNumberOfLogRecordIndexes(File indexFile) {
        return (int)(indexFile.length() / 16L);
    }

    public static void fillCache(IFile logFile, LogFileMetaData logFileMetaData, List<TestCase> testCaseVector, List<LogRecordIndex> logRecordIndexVector) throws IOException {
        LogFileCacheHandler.createPropertyFile(LogFileCacheHandler.getPropertyFileForLogFile(logFile), logFileMetaData);
        LogFileCacheHandler.createIndexFile(LogFileCacheHandler.getIndexFileForLogFile(logFile), testCaseVector);
        LogFileCacheHandler.writeLogRecordIndexFile(LogFileCacheHandler.getLogRecordIndexFileForLogFile(logFile), logRecordIndexVector);
    }

    public static void clearCache(IFile logFile) {
        LogFileCacheHandler.clearLogFileIndexFile(logFile);
        LogFileCacheHandler.clearLogFileLogRecordIndexFile(logFile);
        LogFileCacheHandler.clearLogFilePropertyFile(logFile);
    }

    public static void handleLogFileChange(final IFile logFile) {
        final IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] viewReferences = activePage.getViewReferences();
        ActionUtils.closeAssociatedViews(activePage, viewReferences, (IResource)logFile);
        LogFileCacheHandler.clearCache(logFile);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart view = activePage.findView("org.eclipse.ui.navigator.ProjectExplorer");
                if (view instanceof CommonNavigator) {
                    CommonNavigator navigator = (CommonNavigator)view;
                    navigator.getCommonViewer().collapseToLevel((Object)logFile, -1);
                }
            }
        });
        MessageBox mb = new MessageBox(activePage.getActivePart().getSite().getShell(), 289);
        mb.setText("The log file has been modified.");
        mb.setMessage("The log file has been modified. Click on OK to extract the test cases or CANCEL to close the associated views.");
        if (mb.open() == 32) {
            WorkspaceJob job = new WorkspaceJob("Testcase extraction from log file: " + logFile.getName()){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    boolean completed = LogFileCacheHandler.processLogFile(logFile, monitor, false);
                    return completed ? Status.OK_STATUS : Status.CANCEL_STATUS;
                }
            };
            job.setPriority(30);
            job.setUser(true);
            job.setRule((ISchedulingRule)logFile.getProject());
            job.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processLogFile(final IFile logFile, IProgressMonitor pMonitor, boolean quietMode) {
        IProgressMonitor monitor;
        Object object = monitor = pMonitor == null ? new NullProgressMonitor() : pMonitor;
        if (!logFile.exists()) {
            if (!quietMode) {
                TitanLogExceptionHandler.handleException(new UserException("The log file does not exist: " + logFile.getName()));
            }
            return false;
        }
        try {
            Object temp = logFile.getSessionProperty(Constants.EXTRACTION_RUNNING);
            if (temp != null && ((Boolean)temp).booleanValue()) {
                if (!quietMode) {
                    TitanLogExceptionHandler.handleException(new TechnicalException("Test case extraction is running on the given logfile: " + logFile.getName()));
                }
                return false;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            TitanLogExceptionHandler.handleException(new UserException(e.getMessage()));
            return false;
        }
        if (!LogFileCacheHandler.hasLogFileChanged(logFile)) {
            return true;
        }
        try {
            logFile.setSessionProperty(Constants.EXTRACTION_RUNNING, (Object)true);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        LogFileHandler logFileHandler = new LogFileHandler(logFile);
        try {
            LogFileMetaData logFileMetaData = logFileHandler.autoDetect();
            TestCaseExtractor testCaseExtractor = new TestCaseExtractor();
            testCaseExtractor.extractTestCasesFromLogFile(logFileMetaData, monitor);
            if (monitor.isCanceled()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IViewPart view = activePage.findView("org.eclipse.ui.navigator.ProjectExplorer");
                        if (view instanceof CommonNavigator) {
                            CommonNavigator navigator = (CommonNavigator)view;
                            navigator.getCommonViewer().update((Object)logFile, null);
                            navigator.getCommonViewer().collapseToLevel((Object)logFile, -1);
                        }
                    }
                });
                boolean bl = false;
                return bl;
            }
            LogFileCacheHandler.fillCache(logFile, logFileMetaData, testCaseExtractor.getTestCases(), testCaseExtractor.getLogRecordIndexes());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewPart view = activePage.findView("org.eclipse.ui.navigator.ProjectExplorer");
                    if (view instanceof CommonNavigator) {
                        CommonNavigator navigator = (CommonNavigator)view;
                        navigator.getCommonViewer().refresh((Object)logFile, true);
                        navigator.getCommonViewer().expandToLevel((Object)logFile, -1);
                    }
                }
            });
            if (testCaseExtractor.failedDuringExtraction()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation(null, (String)Messages.getString("OpenTextTableProjectsViewMenuAction.8"), (String)Messages.getString("OpenTextTableProjectsViewMenuAction.9"));
                    }
                });
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            if (!quietMode) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenTextTableProjectsViewMenuAction.2") + e.getMessage()));
            }
            boolean bl = false;
            return bl;
        }
        catch (TechnicalException e) {
            if (!quietMode) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Invalid log file", (String)e.getMessage());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                logFile.setSessionProperty(Constants.EXTRACTION_RUNNING, (Object)false);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        return true;
    }

    public static ISchedulingRule getSchedulingRule(IFile logFile) {
        ISchedulingRule[] rules = new ISchedulingRule[]{logFile, LogFileCacheHandler.getPropertyIFileForLogFile(logFile), LogFileCacheHandler.getIndexIFileForLogFile(logFile), LogFileCacheHandler.getLogRecordIndexIFileForLogFile(logFile)};
        return new MultiRule(rules);
    }
}

