/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.text.table;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.actions.OpenMSCViewAction;
import org.eclipse.titan.log.viewer.extractors.TestCaseExtractor;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.views.text.table.TextTableView;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

class SwitchToMscAction
extends Action {
    private TextTableView textTableView;

    public SwitchToMscAction(TextTableView textTableView) {
        super("", ImageDescriptor.createFromImage((Image)Activator.getDefault().getIcon("icons/msc.gif")));
        this.textTableView = textTableView;
        this.setId("switchToMSC");
        this.setToolTipText("Switch to MSC view");
    }

    public void run() {
        LogFileMetaData logFileMetaData;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject((logFileMetaData = this.textTableView.getLogFileMetaData()).getProjectName());
        IFile logFile = project.getFile(logFileMetaData.getProjectRelativePath().substring(logFileMetaData.getProjectName().length() + 1));
        if (LogFileCacheHandler.hasLogFileChanged(logFile)) {
            LogFileCacheHandler.handleLogFileChange(logFile);
            return;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TestCaseExtractor extractor = new TestCaseExtractor();
        try {
            extractor.extractTestCasesFromIndexedLogFile(logFile);
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            MessageBox mb = new MessageBox(activePage.getActivePart().getSite().getShell(), 33);
            mb.setText("Test case extraction failed.");
            mb.setMessage("Error while extracting the test cases.");
            return;
        }
        catch (ClassNotFoundException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            MessageBox mb = new MessageBox(activePage.getActivePart().getSite().getShell(), 33);
            mb.setText("Test case extraction failed.");
            mb.setMessage("Error while extracting the test cases.");
            return;
        }
        List<TestCase> testCases = extractor.getTestCases();
        if (this.textTableView.getSelectedRecord() == null) {
            MessageBox mb = new MessageBox(activePage.getActivePart().getSite().getShell(), 33);
            mb.setText("Invalid selection.");
            mb.setMessage("Please select a record to open the MSC view.");
            return;
        }
        int recordNumber = this.textTableView.getSelectedRecord().getRecordNumber();
        int testCaseNumber = this.findContainingTestCase(testCases, recordNumber);
        if (testCaseNumber == -1) {
            MessageBox mb = new MessageBox(activePage.getActivePart().getSite().getShell(), 33);
            mb.setText("Testcase can not be found.");
            mb.setMessage("The testcase containing the selected log record can not be found.");
            return;
        }
        OpenMSCViewAction openMSCAction = new OpenMSCViewAction();
        openMSCAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)testCases.get(testCaseNumber)));
        openMSCAction.setFirstRow(recordNumber);
        openMSCAction.run();
    }

    private int findContainingTestCase(List<TestCase> testCases, int recordNumber) {
        int testCaseNumber = -1;
        int min = 0;
        int max = testCases.size() - 1;
        int mid = (min + max) / 2;
        while (min <= max) {
            if (recordNumber > testCases.get(mid).getEndRecordNumber()) {
                min = mid + 1;
            } else if (recordNumber < testCases.get(mid).getStartRecordNumber()) {
                max = mid - 1;
            } else {
                testCaseNumber = mid;
                break;
            }
            mid = (min + max) / 2;
        }
        return testCaseNumber;
    }
}

