/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Date;
import java.util.Formatter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.executor.Activator;
import org.eclipse.titan.executor.TITANConsole;
import org.eclipse.titan.executor.executors.BaseExecutor;
import org.eclipse.titan.executor.graphics.ImageCache;
import org.eclipse.titan.executor.views.notification.Notification;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.progress.IProgressConstants;

public final class HostJob
extends Job {
    private static final String EMPTY = "";
    private final Process proc;
    private final BaseExecutor executor;
    private boolean firstOutput = false;
    private final StringBuilder builder = new StringBuilder();
    private String fastLine;
    private int fastOffset;

    public HostJob(String name, Process proc, BaseExecutor executor) {
        super(name);
        this.proc = proc;
        this.executor = executor;
        this.setProperty(IProgressConstants.ICON_PROPERTY, ImageCache.getImageDescriptor("titan.gif"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        IProcess process = DebugPlugin.newProcess((ILaunch)this.executor.getLaunchStarted(), (Process)this.proc, (String)this.getName());
        IStreamsProxy proxy = process.getStreamsProxy();
        if (null != proxy) {
            IStreamMonitor outputStreamMonitor = proxy.getOutputStreamMonitor();
            IStreamListener listener = new IStreamListener(){

                public void streamAppended(String text, IStreamMonitor monitor) {
                    HostJob.this.processConsoleOutput(text);
                }
            };
            if (null != outputStreamMonitor) {
                String temp = outputStreamMonitor.getContents();
                this.processConsoleOutput(temp);
                outputStreamMonitor.addListener(listener);
            }
        }
        MessageConsoleStream stream = TITANConsole.getConsole().newMessageStream();
        BufferedReader stdout = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
        BufferedReader stderr = new BufferedReader(new InputStreamReader(this.proc.getErrorStream()));
        try {
            int exitVal = this.proc.waitFor();
            if (0 == exitVal) {
                this.executor.addNotification(new Notification(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), EMPTY, EMPTY, "Host Controller executed successfully"));
            } else if (stderr.ready()) {
                String tempDate = new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString();
                this.executor.addNotification(new Notification(tempDate, EMPTY, EMPTY, "Host Controller execution failed"));
                this.executor.addNotification(new Notification(tempDate, EMPTY, EMPTY, "  returned with value:" + exitVal));
                this.executor.addNotification(new Notification(tempDate, EMPTY, EMPTY, "Sent the following error messages:"));
                String line = stderr.readLine();
                while (null != line) {
                    this.executor.addNotification(new Notification(tempDate, EMPTY, EMPTY, line));
                    line = stderr.readLine();
                }
            }
            this.proc.destroy();
        }
        catch (IOException e) {
            stream.println("execution failed beacuse of interrupion");
            ErrorReporter.logExceptionStackTrace((Exception)e);
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (InterruptedException e) {
            stream.println("execution failed beacuse of interrupion");
            ErrorReporter.logExceptionStackTrace((Exception)e);
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            try {
                stdout.close();
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
            try {
                stderr.close();
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        return Status.OK_STATUS;
    }

    public void dispose() {
        this.proc.destroy();
        this.done(Status.OK_STATUS);
    }

    private void processConsoleOutput(String text) {
        this.builder.append(text);
        StringReader reader = new StringReader(this.builder.toString());
        BufferedReader stdout = new BufferedReader(reader);
        this.fastOffset = 0;
        this.readFullLineOnly(stdout);
        while (null != this.fastLine) {
            this.executor.addNotification(new Notification(new Formatter().format("%1$tF %1$tH:%1$tM:%1$tS.%1$tL000", new Date()).toString(), EMPTY, EMPTY, this.fastLine));
            this.builder.delete(0, this.fastOffset);
            if (!this.firstOutput && null != Activator.getMainView()) {
                Activator.getMainView().refreshIfSelected(this.executor.mainControllerRoot);
                this.firstOutput = true;
            }
            this.fastOffset = 0;
            this.readFullLineOnly(stdout);
        }
        try {
            stdout.close();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        reader.close();
    }

    public void readFullLineOnly(BufferedReader stdout) {
        try {
            this.fastLine = stdout.readLine();
            if (null == this.fastLine) {
                return;
            }
            this.fastOffset += this.fastLine.length();
            if (this.builder.length() < this.fastOffset + 1) {
                this.fastLine = null;
                return;
            }
            char c = this.builder.charAt(this.fastOffset);
            if ('\n' == c) {
                ++this.fastOffset;
                return;
            }
            if ('\r' == c) {
                if (this.builder.length() > this.fastOffset + 1 && '\n' == this.builder.charAt(this.fastOffset + 1)) {
                    ++this.fastOffset;
                }
                ++this.fastOffset;
                return;
            }
            this.fastLine = null;
            return;
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return;
        }
    }
}

