/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.ui;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.sew.launcher.Activator;
import org.eclipse.efm.sew.launcher.LaunchConfigurationTabGroup;
import org.eclipse.efm.sew.launcher.ui.AbstractSewLaunchConfigurationTab;
import org.eclipse.efm.sew.launcher.ui.ExpertTab;
import org.eclipse.efm.sew.launcher.ui.internal.SWTFactory;
import org.eclipse.efm.sew.launcher.ui.internal.fieldeditor.StringFieldEditor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class MainTab
extends AbstractSewLaunchConfigurationTab {
    private static final String[] MODEL_COMBO_ITEMS = new String[]{"Exploration", "Transition Coverage", "Behavior Selection"};
    private final String WORKSPACE_SELECTION_DIALOG = "org.eclipse.efm.sew.launcher.WORKSPACE_SELECTION_DIALOG";
    private boolean fEnabledSymbexDeveloperMode;
    private boolean fEnabledSymbexIncubationMode;
    StringFieldEditor fWorkspaceRootFolderNameStringField;
    StringFieldEditor fWorkspaceOuputFolderNameStringField;
    StringFieldEditor fWorkspaceLogFolderNameStringField;
    StringFieldEditor fWorkspaceDebugFolderNameStringField;
    private String fProjectName;
    private Text fModelPathText;
    private String currentModelPath = "";
    private Button fModelWorkspaceBrowse;
    private String specMainFileLocation = "<model file location>";
    private Button fModelButton = null;
    private String fAnalysisProfile = "MODEL";
    private Combo fModelCombo = null;
    private String fModelAnalysis = "Exploration";
    private StringFieldEditor fElementNameListStringField;
    private Group fGroupTestOffline;
    private Button fTestOfflineButton = null;
    private Group fGroupTestOfflineConfiguration;
    private Text fTestOfflineTracePathText;
    private Button fTestOfflineTraceWorkspaceBrowse;
    private Text fOfflineTestTestPurposePathText;
    private Button fTestOfflineTestPurposeWorkspaceBrowse;
    private Composite compModelAnalysisBehavior;
    private Composite compModelAnalysisTransitionCoverage;
    private Composite compTransitionCoverageDetails;
    private Button fAllTransitionButton = null;
    private Button fDetailsTransitionButton = null;
    private String fTransitionButton = "All";
    private Table fTransitionTable1;
    private TableColumn colonne1;
    private Table fTransitionTable2;
    private TableColumn colonne2;
    private List<String> transitionsToBeSelected;
    private List<String> selectedTransitions;
    private TabListener fListener = new TabListener();
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent evt) {
            MainTab.this.scheduleUpdateJob();
        }
    };
    private static final String BEHAVIOR_DESCRIPTION = "Select a list of elements to characterize the behavior to be find.\nThe list can be a set of following elements:\n\t- transition=\"a transition name\" \n\t- state=\"a state name\" \n\t- input=\"an input name used in a statement\" \n\t- output=\"an output name used in a statement\" \n\t- com=\"a com (input or output) name used in a statement\" \nAll items must be separated by newline or semicolon.";
    private static final String BEHAVIOR_INITIAL_SAMPLE = "// Sequence of elements (separated by newline or semicolon) characterizing the desired behavior.\n// The elements of the sequence may be selected from:\ntransition=\"<transition-name-id>\"\nstate=\"<state-name-id>\"\ninput=\"<input-port-or-signal-name-id>\"\ninout=\"<inout-port-or-signal-name-id>\"\noutput=\"<output-port-or-signal-name-id>\"\ncom=\"<input-or-output-port-or-signal-name-id>\"\n";

    public MainTab(LaunchConfigurationTabGroup groupTab) {
        super(groupTab);
        this.setHelpContextId("org.eclipse.efm.sew.launcher.efm_runconf_main_tab");
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        this.fEnabledSymbexDeveloperMode = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_SYMBEX_DEVELOPER_MODE");
        prefs = Activator.getDefault().getPreferenceStore();
        this.fEnabledSymbexIncubationMode = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_INCUBATION_MODE");
    }

    public void handleSelectedTransition() {
        boolean refresh = false;
        int i = 0;
        while (i < this.transitionsToBeSelected.size()) {
            if (this.fTransitionTable1.getItem(i).getChecked()) {
                if (!this.selectedTransitions.contains(this.transitionsToBeSelected.get(i))) {
                    this.selectedTransitions.add(this.transitionsToBeSelected.get(i));
                    refresh = true;
                }
            } else if (this.selectedTransitions.contains(this.transitionsToBeSelected.get(i))) {
                this.selectedTransitions.remove(this.transitionsToBeSelected.get(i));
                refresh = true;
            }
            ++i;
        }
        if (refresh) {
            this.selectedTransitions.sort(null);
            this.updateTransitionTable2();
        }
        this.updateLaunchConfigurationDialog();
    }

    public void handleModelButtonSelected() {
        if (this.fModelButton.getSelection()) {
            this.fAnalysisProfile = "MODEL";
            this.enableAnalysisModel(true);
            if (this.fEnabledSymbexIncubationMode) {
                this.enableAnalysisTestOfflineTrace(false);
            }
            if (this.fModelAnalysis.equals("Behavior Selection")) {
                this.visibleAndExclude((Control)this.compModelAnalysisBehavior, true);
                this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, false);
                this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
            } else if (this.fModelAnalysis.equals("Transition Coverage")) {
                this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, true);
                if (this.fTransitionButton.equals("All")) {
                    this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
                } else {
                    this.visibleAndExclude((Control)this.compTransitionCoverageDetails, true);
                }
                this.visibleAndExclude((Control)this.compModelAnalysisBehavior, false);
            } else {
                this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, false);
                this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
                this.visibleAndExclude((Control)this.compModelAnalysisBehavior, false);
            }
        }
        this.updateLaunchConfigurationDialog();
    }

    public void handleAllTransitionButtonSelected() {
        if (this.fAllTransitionButton.getSelection()) {
            this.fTransitionButton = "All";
            this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
        }
        this.updateLaunchConfigurationDialog();
    }

    public void handleDetailedTransitionSelected() {
        if (this.fDetailsTransitionButton.getSelection()) {
            this.fTransitionButton = "Details";
            this.visibleAndExclude((Control)this.compTransitionCoverageDetails, true);
        }
        this.updateLaunchConfigurationDialog();
    }

    public void handleTestOfflineButtonSelected() {
        if (this.fTestOfflineButton.getSelection()) {
            this.fAnalysisProfile = "TESTOFFLINE";
            this.enableAnalysisModel(false);
            this.enableAnalysisTestOfflineTrace(true);
            this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, false);
            this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
            this.visibleAndExclude((Control)this.compModelAnalysisBehavior, false);
        }
        this.updateLaunchConfigurationDialog();
    }

    private void handleModelSelectionChange() {
        this.fModelAnalysis = this.fModelCombo.getText();
        ExpertTab expertTab = this.getGroupTab().getExpertTab();
        if (expertTab != null) {
            expertTab.setTabName("Expert <" + this.fModelAnalysis + ">");
        }
        if (this.fModelAnalysis.equals("Behavior Selection")) {
            this.visibleAndExclude((Control)this.compModelAnalysisBehavior, true);
            this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, false);
            this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
        } else if (this.fModelAnalysis.equals("Transition Coverage")) {
            this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, true);
            if (this.fTransitionButton.equals("All")) {
                this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
            } else {
                this.visibleAndExclude((Control)this.compTransitionCoverageDetails, true);
            }
            this.visibleAndExclude((Control)this.compModelAnalysisBehavior, false);
        } else {
            this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, false);
            this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
            this.visibleAndExclude((Control)this.compModelAnalysisBehavior, false);
        }
        this.updateLaunchConfigurationDialog();
    }

    IDialogSettings getDialogBoundsSettings(String id) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(id);
        if (section == null) {
            section = settings.addNewSection(id);
        }
        return section;
    }

    public void createControl(Composite parent) {
        Composite simpleComposite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 1808, 0, 0);
        this.setControl((Control)simpleComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        this.createModelFileSelectionComponent(simpleComposite);
        this.createWorkspaceComponent(simpleComposite);
        this.createAnalyseProfileComponent(simpleComposite);
    }

    private void createModelFileSelectionComponent(Composite parent) {
        Group group = SWTFactory.createGroup(parent, "Model File Selection", 1, 1, 768);
        Composite comp = SWTFactory.createComposite((Composite)group, group.getFont(), 2, 1, 1808, 0, 0);
        this.fModelPathText = SWTFactory.createSingleText(comp, 1);
        this.fModelPathText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Model File";
            }
        });
        this.fModelPathText.addModifyListener(this.fBasicModifyListener);
        this.fModelWorkspaceBrowse = this.createPushButton(comp, "&Workspace...", null);
        this.fModelWorkspaceBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(MainTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Select a Diversity Specification:");
                dialog.setMessage("Select a resource to redirect output to:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.setDialogBoundsSettings(MainTab.this.getDialogBoundsSettings("org.eclipse.efm.sew.launcher.WORKSPACE_SELECTION_DIALOG"), 2);
                if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                    MainTab.this.fProjectName = resource.getProject().getName();
                    String specFile = resource.getLocation().toString();
                    MainTab.this.fModelPathText.setText(specFile);
                    MainTab.this.updateWorkspaceRootPath(resource);
                }
            }
        });
    }

    private void updateWorkspaceRootPath(IResource resource) {
        this.fWorkspaceRootFolderNameStringField.setStringValue(resource.getProject().getLocation().toString());
    }

    private void updateWorkspaceRootPath(String modelPath) {
        Path path;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)(path = new Path(modelPath)));
        if (resource != null && resource.exists()) {
            this.fWorkspaceRootFolderNameStringField.setStringValue(resource.getProject().getLocation().toString());
        } else if (root.getLocation().isPrefixOf((IPath)path)) {
            path = root.getLocation().append(path.segment(path.matchingFirstSegments(root.getLocation())));
            this.fWorkspaceRootFolderNameStringField.setStringValue(path.toString());
        } else {
            this.fWorkspaceRootFolderNameStringField.setStringValue(root.getLocation().append("<project-folder>").toString());
        }
        this.fWorkspaceRootFolderNameStringField.updateLaunchConfigurationDialog();
    }

    protected void createWorkspaceComponent(Composite parent) {
        String root = ResourcesPlugin.getWorkspace().getRoot().getLocation().append("<project-folder>").toString();
        String toolTipText = "Name of the subfolder in the root folder";
        String toolTipText2 = "Name of the subfolder in the output folder";
        Group group = SWTFactory.createGroup(parent, "&Workspace Folder Name", 1, 1, 768);
        group.setToolTipText(toolTipText);
        Composite comp = SWTFactory.createComposite((Composite)group, 1, 1, 768);
        comp.setToolTipText(toolTipText);
        this.fWorkspaceRootFolderNameStringField = new StringFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_WORKSPACE_ROOT_FOLDER_NAME", "Root", comp, root);
        this.fWorkspaceRootFolderNameStringField.setEnabled(false);
        this.fWorkspaceOuputFolderNameStringField = new StringFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_WORKSPACE_OUTPUT_FOLDER_NAME", "Output", comp, "output");
        this.fWorkspaceOuputFolderNameStringField.setToolTipText(toolTipText);
        if (this.fEnabledSymbexDeveloperMode) {
            this.fWorkspaceLogFolderNameStringField = new StringFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_WORKSPACE_LOG_FOLDER_NAME", "Log", comp, "log");
            this.fWorkspaceLogFolderNameStringField.setToolTipText(toolTipText2);
            this.fWorkspaceDebugFolderNameStringField = new StringFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_WORKSPACE_DEBUG_FOLDER_NAME", "Debug", comp, "debug");
            this.fWorkspaceDebugFolderNameStringField.setToolTipText(toolTipText2);
        }
    }

    protected void createAnalyseProfileComponent(Composite parent) {
        Group groupAnalysisProfile = SWTFactory.createGroup(parent, "&Analysis Profile", 1, 1, 768);
        Group group = SWTFactory.createGroup((Composite)groupAnalysisProfile, "&Classical Model Analysis: Exploration, Transition Coverage...", 2, 1, 768);
        Composite comp1 = SWTFactory.createComposite((Composite)group, 1, 2, 768);
        this.fModelButton = SWTFactory.createRadioButton(comp1, "&Selected");
        this.fModelButton.setToolTipText("Symbolic execution of the model");
        this.fModelButton.addSelectionListener((SelectionListener)this.fListener);
        this.fModelCombo = SWTFactory.createCombo(comp1, 12, 1, MODEL_COMBO_ITEMS);
        this.fModelCombo.setToolTipText("Choice of the strategy for the symbolic execution of the model\n\t- Exploration: basic symbolic execution of the model\n\t- Transition Coverage: compute a symbolic tree which covers all transitions of the model\n\t- Behavior Selection: compute one or more symbolic path(s) which cover(s)\n\t\t\t   a predefined behavior\n");
        this.fModelCombo.addSelectionListener((SelectionListener)this.fListener);
        this.createTransitionCoverageComponent((Composite)group);
        this.createBehaviorComponent((Composite)group);
        if (this.fEnabledSymbexIncubationMode) {
            this.createIncubationTestOfflineComponent((Composite)groupAnalysisProfile);
        } else {
            this.fModelButton.setSelection(true);
            this.visibleAndExclude((Control)this.fModelButton, false);
        }
    }

    protected void createIncubationTestOfflineComponent(Composite parent) {
        this.fGroupTestOffline = SWTFactory.createGroup(parent, "&Test Verdict Computation: Offline testing...", 2, 1, 768);
        Composite comp = SWTFactory.createComposite((Composite)this.fGroupTestOffline, 1, 5, 768);
        this.fTestOfflineButton = SWTFactory.createRadioButton(comp, "&Selected");
        this.fTestOfflineButton.addSelectionListener((SelectionListener)this.fListener);
        this.fGroupTestOfflineConfiguration = SWTFactory.createGroup(comp, "&Offline Testing Configuration", 1, 1, 768);
        Group group = SWTFactory.createGroup((Composite)this.fGroupTestOfflineConfiguration, "&Trace File Selection", 1, 1, 768);
        comp = SWTFactory.createComposite((Composite)group, 3, 1, 768);
        this.fTestOfflineTracePathText = SWTFactory.createSingleText(comp, 1);
        this.fTestOfflineTracePathText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Trace File";
            }
        });
        this.fTestOfflineTracePathText.addModifyListener(this.fBasicModifyListener);
        this.fTestOfflineTraceWorkspaceBrowse = this.createPushButton(comp, "&Workspace...", null);
        this.fTestOfflineTraceWorkspaceBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(MainTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Select a Resource:");
                dialog.setMessage("Select a resource to redirect output to:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.setDialogBoundsSettings(MainTab.this.getDialogBoundsSettings("org.eclipse.efm.sew.launcher.WORKSPACE_SELECTION_DIALOG"), 2);
                if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                    String arg = resource.getLocation().toString();
                    MainTab.this.fTestOfflineTracePathText.setText(arg);
                }
            }
        });
        group = SWTFactory.createGroup((Composite)this.fGroupTestOfflineConfiguration, "&Test Purpose File Selection", 1, 1, 768);
        comp = SWTFactory.createComposite((Composite)group, 2, 1, 768);
        this.fOfflineTestTestPurposePathText = SWTFactory.createSingleText(comp, 1);
        this.fOfflineTestTestPurposePathText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Test Purpose File";
            }
        });
        this.fOfflineTestTestPurposePathText.addModifyListener(this.fBasicModifyListener);
        this.fTestOfflineTestPurposeWorkspaceBrowse = this.createPushButton(comp, "&Workspace...", null);
        this.fTestOfflineTestPurposeWorkspaceBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(MainTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Select a Resource:");
                dialog.setMessage("Select a resource to redirect output to:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.setDialogBoundsSettings(MainTab.this.getDialogBoundsSettings("org.eclipse.efm.sew.launcher.WORKSPACE_SELECTION_DIALOG"), 2);
                if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                    String arg = resource.getLocation().toString();
                    MainTab.this.fOfflineTestTestPurposePathText.setText(arg);
                }
            }
        });
    }

    private void createTransitionCoverageComponent(Composite parent) {
        this.compModelAnalysisTransitionCoverage = SWTFactory.createGroup(parent, "&Transition To Be Covered", 1, 1, 768);
        Composite compButton = SWTFactory.createComposite(this.compModelAnalysisTransitionCoverage, 2, 1, 768);
        this.fAllTransitionButton = SWTFactory.createRadioButton(compButton, "&All");
        this.fAllTransitionButton.addSelectionListener((SelectionListener)this.fListener);
        this.fAllTransitionButton.setToolTipText("All transitions must be covered");
        this.fDetailsTransitionButton = SWTFactory.createRadioButton(compButton, "&Details");
        this.fDetailsTransitionButton.addSelectionListener((SelectionListener)this.fListener);
        this.fDetailsTransitionButton.setToolTipText("Select a detailed list of transitions to be covered");
        this.fAllTransitionButton.setSelection(false);
        this.fDetailsTransitionButton.setSelection(false);
        this.compTransitionCoverageDetails = SWTFactory.createComposite(this.compModelAnalysisTransitionCoverage, 2, 1, 768);
        this.fTransitionTable1 = new Table(this.compTransitionCoverageDetails, 2080);
        this.colonne1 = new TableColumn(this.fTransitionTable1, 0);
        this.colonne1.setText("Transitions to be selected");
        this.fTransitionTable1.setHeaderVisible(true);
        this.fTransitionTable2 = new Table(this.compTransitionCoverageDetails, 2048);
        this.colonne2 = new TableColumn(this.fTransitionTable2, 0);
        this.colonne2.setText("Selected transitions");
        this.fTransitionTable2.setHeaderVisible(true);
        int listHeight = this.fTransitionTable1.getItemHeight() * 10;
        Rectangle trim = this.fTransitionTable1.computeTrim(0, 0, 0, listHeight);
        GridData gridDataLeft = new GridData();
        gridDataLeft.heightHint = trim.height;
        gridDataLeft.horizontalIndent = 0;
        gridDataLeft.verticalIndent = 10;
        this.fTransitionTable1.setLayoutData((Object)gridDataLeft);
        GridData gridDataRight = new GridData();
        gridDataRight.heightHint = trim.height;
        gridDataRight.horizontalIndent = 0;
        gridDataRight.verticalIndent = 10;
        this.fTransitionTable2.setLayoutData((Object)gridDataRight);
        this.fTransitionTable1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MainTab.this.selectedTransitions.clear();
                boolean refresh = false;
                int i = 0;
                while (i < MainTab.this.transitionsToBeSelected.size()) {
                    if (MainTab.this.fTransitionTable1.getItem(i).getChecked()) {
                        if (!MainTab.this.selectedTransitions.contains(MainTab.this.transitionsToBeSelected.get(i))) {
                            MainTab.this.selectedTransitions.add((String)MainTab.this.transitionsToBeSelected.get(i));
                            refresh = true;
                        }
                    } else if (MainTab.this.selectedTransitions.contains(MainTab.this.transitionsToBeSelected.get(i))) {
                        MainTab.this.selectedTransitions.remove(MainTab.this.transitionsToBeSelected.get(i));
                        refresh = true;
                    }
                    ++i;
                }
                if (refresh) {
                    MainTab.this.selectedTransitions.sort(null);
                }
                MainTab.this.updateTransitionTable2();
                MainTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createBehaviorComponent(Composite parent) {
        this.compModelAnalysisBehavior = SWTFactory.createGroup(parent, "&Behavior Characterization", 1, 1, 768);
        this.compModelAnalysisBehavior.setToolTipText(BEHAVIOR_DESCRIPTION);
        Composite comp2 = SWTFactory.createComposite(this.compModelAnalysisBehavior, 1, 1, 768);
        this.fElementNameListStringField = new StringFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_BEHAVIOR_ANALYSIS_ELEMENT_NAME_LIST", "", comp2, BEHAVIOR_DESCRIPTION, 2);
        this.fElementNameListStringField.setToolTipText(BEHAVIOR_DESCRIPTION);
    }

    private void initTransitionTable() {
        this.createTransitionToBeSelectedList();
        this.fTransitionTable1.removeAll();
        int i = 0;
        while (i < this.transitionsToBeSelected.size()) {
            TableItem item = new TableItem(this.fTransitionTable1, 0);
            item.setChecked(false);
            item.setText(new String[]{this.transitionsToBeSelected.get(i), ""});
            ++i;
        }
    }

    private void updateTransitionTable2() {
        this.fTransitionTable2.removeAll();
        int i = 0;
        while (i < this.transitionsToBeSelected.size()) {
            TableItem item = new TableItem(this.fTransitionTable2, 0);
            if (i < this.selectedTransitions.size()) {
                item.setText(new String[]{this.selectedTransitions.get(i)});
            } else {
                item.setText(new String[]{""});
            }
            ++i;
        }
    }

    private void createTransitionToBeSelectedList() {
        String pathFile = this.fModelPathText.getText();
        this.transitionsToBeSelected = new ArrayList<String>();
        try {
            if (!pathFile.equals("<model file location>") && !pathFile.equals("")) {
                String ligne;
                FileInputStream ips = new FileInputStream(pathFile);
                InputStreamReader ipsr = new InputStreamReader(ips);
                BufferedReader br = new BufferedReader(ipsr);
                String transitionName = "";
                int maxSizetransitionName = 0;
                while ((ligne = br.readLine()) != null) {
                    int pos = ligne.indexOf("transition");
                    if (pos >= 0) {
                        transitionName = (ligne = ligne.substring(pos + "transition".length())).replaceAll("\\s*(<[^>]*>\\s*)?([^\\s-{]*).*", "$2");
                        if (transitionName.isEmpty()) continue;
                        this.transitionsToBeSelected.add(transitionName);
                        maxSizetransitionName = Math.max(maxSizetransitionName, transitionName.length());
                        continue;
                    }
                    if (!ligne.contains("-->") || ligne.contains("}") || ligne.contains("output ") || ligne.contains("procedure ") || ligne.contains("call ")) continue;
                    ligne = ligne.replaceAll("\t", "");
                    ligne = ligne.substring(0, ligne.indexOf("-->"));
                    transitionName = (ligne = ligne.replaceAll(" ", "")).replaceFirst("@", "");
                    if (transitionName.length() == 0) continue;
                    this.transitionsToBeSelected.add(transitionName);
                    maxSizetransitionName = Math.max(maxSizetransitionName, transitionName.length());
                }
                br.close();
                this.transitionsToBeSelected.sort(null);
                if (maxSizetransitionName <= 30) {
                    this.colonne1.setWidth(200);
                    this.colonne2.setWidth(200);
                } else {
                    this.colonne1.setWidth(maxSizetransitionName * 9 + 30);
                    this.colonne2.setWidth(maxSizetransitionName * 9 + 10);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void enableAnalysisModel(boolean bEnabled) {
        this.fModelButton.setSelection(bEnabled);
        this.fModelCombo.setEnabled(bEnabled);
    }

    private void enableAnalysisTestOfflineTrace(boolean bEnabled) {
        this.fTestOfflineButton.setSelection(bEnabled);
        this.visibleAndExclude((Control)this.fGroupTestOfflineConfiguration, bEnabled);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.fAnalysisProfile.equals("MODEL") && this.fModelAnalysis.equals("Behavior Selection")) {
            String[] tabString;
            String[] stringArray = tabString = this.fElementNameListStringField.getStringValue().split(";\n");
            int n = tabString.length;
            int n2 = 0;
            while (n2 < n) {
                String eltString = stringArray[n2];
                if ((eltString = eltString.trim()).length() == 0) {
                    this.setErrorMessage("You must select at least one element");
                    return false;
                }
                if (!eltString.startsWith("//")) {
                    int pos = eltString.indexOf(61);
                    if (pos > 0) {
                        String kind = eltString.substring(0, pos).trim();
                        if (!(kind.equals("transition") || kind.equals("state") || kind.equals("input") || kind.equals("output") || kind.equals("inout") || kind.equals("com"))) {
                            this.setErrorMessage("The element \"" + eltString + "\" is not a valid element");
                            return false;
                        }
                    } else {
                        this.setErrorMessage("The element \"" + eltString + "\" is not a valid element");
                        return false;
                    }
                }
                ++n2;
            }
        }
        if (this.fModelAnalysis.equals("Transition Coverage") && this.fTransitionButton.equals("Details") && this.selectedTransitions.size() == 0) {
            this.setErrorMessage("You must select at least one transition");
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_PROJECT_NAME", "<project location>");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", "<model file location>");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_WORKSPACE_OUTPUT_FOLDER_NAME", "output");
        if (this.fEnabledSymbexDeveloperMode) {
            configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_WORKSPACE_LOG_FOLDER_NAME", "log");
            configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_WORKSPACE_DEBUG_FOLDER_NAME", "debug");
        }
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYSIS_PROFILE", "MODEL");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_ANALYSIS", "Exploration");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRANSITION_BUTTON", "All");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_BEHAVIOR_ANALYSIS_ELEMENT_NAME_LIST", BEHAVIOR_INITIAL_SAMPLE);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TRACE_FILE_LOCATION", "<merge-trace-file-path>");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TEST_PURPOSE_FILE_LOCATION", "<test-purpose-file-path>");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SELECTED_TRANSITIONS", new ArrayList());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fProjectName = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_PROJECT_NAME", "");
            this.fWorkspaceRootFolderNameStringField.initializeFrom(configuration);
            this.specMainFileLocation = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", "<model file location>");
            this.fModelPathText.setText(this.specMainFileLocation);
            this.updateWorkspaceRootPath(this.specMainFileLocation);
            if (!this.fModelPathText.getText().equals(this.currentModelPath)) {
                this.currentModelPath = this.fModelPathText.getText();
                this.initTransitionTable();
            }
            this.fWorkspaceOuputFolderNameStringField.initializeFrom(configuration);
            if (this.fEnabledSymbexDeveloperMode) {
                this.fWorkspaceLogFolderNameStringField.initializeFrom(configuration);
                this.fWorkspaceDebugFolderNameStringField.initializeFrom(configuration);
            }
            this.fAnalysisProfile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYSIS_PROFILE", "MODEL");
            this.initializeAnalysisProfile();
            this.fModelAnalysis = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_ANALYSIS", "Exploration");
            this.initializeModelAnalysis();
            this.fTransitionButton = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRANSITION_BUTTON", "All");
            this.initializeTransitionOption(configuration);
            this.selectedTransitions = new ArrayList<String>();
            this.selectedTransitions.addAll(configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SELECTED_TRANSITIONS", new ArrayList()));
            this.updateTransitionTable2();
            if (this.fEnabledSymbexIncubationMode) {
                String traceFile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TRACE_FILE_LOCATION", "<merge-trace-file-path>");
                this.fTestOfflineTracePathText.setText(traceFile);
                String testPurposeFile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_TEST_PURPOSE_FILE_LOCATION", "<test-purpose-file-path>");
                this.fOfflineTestTestPurposePathText.setText(testPurposeFile);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.fElementNameListStringField.initializeFrom(configuration);
        if (this.fAnalysisProfile.equals("MODEL") && this.fModelAnalysis.equals("Behavior Selection")) {
            this.visibleAndExclude((Control)this.compModelAnalysisBehavior, true);
            this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, false);
            this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
        } else if (this.fAnalysisProfile.equals("MODEL") && this.fModelAnalysis.equals("Transition Coverage")) {
            this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, true);
            if (this.fTransitionButton.equals("All")) {
                this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
            } else {
                this.visibleAndExclude((Control)this.compTransitionCoverageDetails, true);
            }
            this.visibleAndExclude((Control)this.compModelAnalysisBehavior, false);
        } else {
            this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, false);
            this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
            this.visibleAndExclude((Control)this.compModelAnalysisBehavior, false);
        }
    }

    private void initializeModelAnalysis() {
        switch (this.fModelAnalysis) {
            case "Exploration": {
                this.fModelCombo.select(0);
                break;
            }
            case "Transition Coverage": {
                this.fModelCombo.select(1);
                break;
            }
            case "Behavior Selection": {
                this.fModelCombo.select(2);
                break;
            }
            default: {
                this.fModelCombo.select(0);
            }
        }
    }

    private void initializeAnalysisProfile() {
        if (!this.fEnabledSymbexIncubationMode) {
            this.fAnalysisProfile = "MODEL";
        }
        switch (this.fAnalysisProfile) {
            case "MODEL": {
                this.fModelButton.setSelection(true);
                this.enableAnalysisModel(true);
                if (this.fEnabledSymbexIncubationMode) {
                    this.fTestOfflineButton.setSelection(false);
                    this.enableAnalysisTestOfflineTrace(false);
                }
                if (this.fModelAnalysis.equals("Behavior Selection")) {
                    this.visibleAndExclude((Control)this.compModelAnalysisBehavior, true);
                    this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, false);
                    this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
                    break;
                }
                if (this.fModelAnalysis.equals("Transition Coverage")) {
                    this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, true);
                    if (this.fTransitionButton.equals("All")) {
                        this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
                    } else {
                        this.visibleAndExclude((Control)this.compTransitionCoverageDetails, true);
                    }
                    this.visibleAndExclude((Control)this.compModelAnalysisBehavior, false);
                    break;
                }
                this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, false);
                this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
                this.visibleAndExclude((Control)this.compModelAnalysisBehavior, false);
                break;
            }
            case "TESTOFFLINE": {
                this.fModelButton.setSelection(false);
                this.enableAnalysisModel(false);
                if (this.fEnabledSymbexIncubationMode) {
                    this.fTestOfflineButton.setSelection(true);
                    this.enableAnalysisTestOfflineTrace(true);
                }
                this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, false);
                this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
                this.visibleAndExclude((Control)this.compModelAnalysisBehavior, false);
                break;
            }
            default: {
                this.fModelButton.setSelection(true);
                this.fAnalysisProfile = "MODEL";
                this.enableAnalysisModel(true);
                if (this.fEnabledSymbexIncubationMode) {
                    this.fTestOfflineButton.setSelection(false);
                    this.enableAnalysisTestOfflineTrace(false);
                }
                if (this.fModelAnalysis.equals("Behavior Selection")) {
                    this.visibleAndExclude((Control)this.compModelAnalysisBehavior, true);
                    this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, false);
                    this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
                    break;
                }
                if (this.fModelAnalysis.equals("Transition Coverage")) {
                    this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, true);
                    if (this.fTransitionButton.equals("All")) {
                        this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
                    } else {
                        this.visibleAndExclude((Control)this.compTransitionCoverageDetails, true);
                    }
                    this.visibleAndExclude((Control)this.compModelAnalysisBehavior, false);
                    break;
                }
                this.visibleAndExclude((Control)this.compModelAnalysisTransitionCoverage, false);
                this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
                this.visibleAndExclude((Control)this.compModelAnalysisBehavior, false);
            }
        }
        this.updateLaunchConfigurationDialog();
    }

    private void initializeTransitionOption(ILaunchConfiguration configuration) {
        switch (this.fTransitionButton) {
            case "All": {
                this.fAllTransitionButton.setSelection(true);
                this.fDetailsTransitionButton.setSelection(false);
                this.visibleAndExclude((Control)this.compTransitionCoverageDetails, false);
                break;
            }
            case "Details": {
                this.fAllTransitionButton.setSelection(false);
                this.fDetailsTransitionButton.setSelection(true);
                this.visibleAndExclude((Control)this.compTransitionCoverageDetails, true);
                break;
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_PROJECT_NAME", this.fProjectName);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", this.fModelPathText.getText());
        if (!this.fModelPathText.getText().equals(this.currentModelPath)) {
            this.currentModelPath = this.fModelPathText.getText();
            this.initTransitionTable();
        }
        this.fWorkspaceRootFolderNameStringField.performApply(configuration);
        this.fWorkspaceOuputFolderNameStringField.performApply(configuration);
        if (this.fEnabledSymbexDeveloperMode) {
            this.fWorkspaceLogFolderNameStringField.performApply(configuration);
            this.fWorkspaceDebugFolderNameStringField.performApply(configuration);
        }
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYSIS_PROFILE", this.fAnalysisProfile);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_ANALYSIS", this.fModelAnalysis);
        if (this.fEnabledSymbexIncubationMode) {
            configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TRACE_FILE_LOCATION", this.fTestOfflineTracePathText.getText());
            configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_TEST_PURPOSE_FILE_LOCATION", this.fOfflineTestTestPurposePathText.getText());
        }
        this.fElementNameListStringField.performApply(configuration);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_BASIC_TRANSITION_BUTTON", this.fTransitionButton);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SELECTED_TRANSITIONS", this.selectedTransitions);
    }

    public String getName() {
        return "Main";
    }

    private class TabListener
    extends SelectionAdapter
    implements ModifyListener {
        private TabListener() {
        }

        public void modifyText(ModifyEvent e) {
            MainTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == MainTab.this.fModelButton) {
                MainTab.this.handleModelButtonSelected();
            } else if (source == MainTab.this.fTestOfflineButton) {
                MainTab.this.handleTestOfflineButtonSelected();
            } else if (source == MainTab.this.fModelCombo) {
                MainTab.this.handleModelSelectionChange();
            } else if (source == MainTab.this.fAllTransitionButton) {
                MainTab.this.handleAllTransitionButtonSelected();
            } else if (source == MainTab.this.fDetailsTransitionButton) {
                MainTab.this.handleDetailedTransitionSelected();
            }
        }
    }
}

