/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.decorators.DecoratableResource;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceHelper;
import org.eclipse.egit.ui.internal.resources.IResourceState;
import org.eclipse.egit.ui.internal.resources.ResourceStateFactory;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

class DecoratableResourceAdapter
extends DecoratableResource {
    public DecoratableResourceAdapter(@NonNull IndexDiffData indexDiffData, @NonNull IResource resourceToWrap) throws IOException {
        super(resourceToWrap);
        boolean trace = GitTraceLocation.DECORATION.isActive();
        long start = 0L;
        if (trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.DECORATION.getLocation(), "Decorate " + resourceToWrap.getFullPath());
            start = System.currentTimeMillis();
        }
        try {
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resourceToWrap);
            if (mapping == null) {
                return;
            }
            Repository repository = mapping.getRepository();
            if (repository == null) {
                return;
            }
            this.setIsRepositoryContainer(resourceToWrap.equals((Object)mapping.getContainer()));
            IResourceState baseState = ResourceStateFactory.getInstance().get(indexDiffData, resourceToWrap);
            this.setTracked(baseState.isTracked());
            this.setIgnored(baseState.isIgnored());
            this.setDirty(baseState.isDirty());
            this.setConflicts(baseState.hasConflicts());
            this.setAssumeUnchanged(baseState.isAssumeUnchanged());
            this.setStagingState(baseState.getStagingState());
            if (this.isRepositoryContainer()) {
                this.repositoryName = DecoratableResourceHelper.getRepositoryName(repository);
                this.branch = DecoratableResourceHelper.getShortBranch(repository);
                this.branchStatus = DecoratableResourceHelper.getBranchStatus(repository);
                RevCommit headCommit = DecoratableResourceHelper.getHeadCommit(repository);
                if (headCommit != null) {
                    this.commitMessage = headCommit.getShortMessage();
                }
            }
        }
        finally {
            if (trace) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.DECORATION.getLocation(), "Decoration took " + (System.currentTimeMillis() - start) + " ms");
            }
        }
    }

    public String toString() {
        return "DecoratableResourceAdapter[" + this.getName() + (this.isTracked() ? ", tracked" : "") + (this.isIgnored() ? ", ignored" : "") + (this.isDirty() ? ", dirty" : "") + (this.hasConflicts() ? ",conflicts" : "") + ", staged=" + (Object)((Object)this.getStagingState()) + "]";
    }
}

